/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeglossless;

import com.idrsolutions.image.DataReader;
import java.io.IOException;

class QTable {
    private final int[] precision = new int[4];
    public final int[][] qTables = new int[4][64];

    QTable() {
    }

    public void read(DataReader data, int[] table) throws IOException {
        int cc = 2;
        int len = data.getU16();
        while (cc < len) {
            int i;
            int temp = data.getU8();
            ++cc;
            int t = temp & 0xF;
            if (t > 3) {
                throw new IOException("Quantization table error");
            }
            this.precision[t] = temp >> 4;
            switch (this.precision[t]) {
                case 0: {
                    this.precision[t] = 8;
                    break;
                }
                case 1: {
                    this.precision[t] = 16;
                    break;
                }
                default: {
                    throw new IOException("Quantization table error");
                }
            }
            if (this.precision[t] == 8) {
                for (i = 0; i < 64; ++i) {
                    if (cc > len) {
                        throw new IOException("Quantization table error");
                    }
                    this.qTables[t][i] = data.getU8();
                    ++cc;
                }
                QTable.expand(this.qTables[t], table);
                continue;
            }
            for (i = 0; i < 64; ++i) {
                if (cc > len) {
                    throw new IOException("Quantization table error");
                }
                this.qTables[t][i] = data.getU16();
                cc += 2;
            }
            QTable.expand(this.qTables[t], table);
        }
        if (cc != len) {
            throw new IOException("Quantization table error");
        }
    }

    private static void expand(int[] qt, int[] tbl) {
        int i;
        for (i = 0; i < 8; ++i) {
            int n = tbl[i];
            qt[n] = qt[n] * 90;
            int n2 = tbl[32 + i];
            qt[n2] = qt[n2] * 90;
            int n3 = tbl[16 + i];
            qt[n3] = qt[n3] * 118;
            int n4 = tbl[48 + i];
            qt[n4] = qt[n4] * 49;
            int n5 = tbl[40 + i];
            qt[n5] = qt[n5] * 71;
            int n6 = tbl[8 + i];
            qt[n6] = qt[n6] * 126;
            int n7 = tbl[56 + i];
            qt[n7] = qt[n7] * 25;
            int n8 = tbl[24 + i];
            qt[n8] = qt[n8] * 106;
        }
        for (i = 0; i < 8; ++i) {
            int n = tbl[i << 3];
            qt[n] = qt[n] * 90;
            int n9 = tbl[4 + (i << 3)];
            qt[n9] = qt[n9] * 90;
            int n10 = tbl[2 + (i << 3)];
            qt[n10] = qt[n10] * 118;
            int n11 = tbl[6 + (i << 3)];
            qt[n11] = qt[n11] * 49;
            int n12 = tbl[5 + (i << 3)];
            qt[n12] = qt[n12] * 71;
            int n13 = tbl[1 + (i << 3)];
            qt[n13] = qt[n13] * 126;
            int n14 = tbl[7 + (i << 3)];
            qt[n14] = qt[n14] * 25;
            int n15 = tbl[3 + (i << 3)];
            qt[n15] = qt[n15] * 106;
        }
        i = 0;
        while (i < 64) {
            int n = i++;
            qt[n] = qt[n] >> 6;
        }
    }
}

