/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeglossless;

import com.idrsolutions.image.DataReader;
import com.idrsolutions.image.jpeglossless.Sampler;
import java.io.IOException;

class Frame {
    private Sampler[] samples;
    int width;
    int height;
    int precision;

    Frame() {
    }

    public Sampler[] getSamples() {
        return (Sampler[])this.samples.clone();
    }

    void read(DataReader data) throws IOException {
        int cc = 8;
        int len = data.getU16();
        this.precision = data.getU8();
        this.height = data.getU16();
        this.width = data.getU16();
        int nComp = data.getU8();
        this.samples = new Sampler[256];
        for (int i = 1; i <= nComp; ++i) {
            if (cc > len) {
                throw new IOException("corrupted Jpeg Frame Data");
            }
            int c = data.getU8();
            if (++cc >= len) {
                throw new IOException("corrupted Jpeg Frame Data");
            }
            int temp = data.getU8();
            ++cc;
            if (this.samples[c] == null) {
                this.samples[c] = new Sampler();
            }
            this.samples[c].h = temp >> 4;
            this.samples[c].v = temp & 0xF;
            this.samples[c].qt = data.getU8();
            ++cc;
        }
        if (cc != len) {
            throw new IOException("corrupted Jpeg Frame Data");
        }
    }
}

