/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

class JPXReader {
    private final int length;
    final byte[] data;
    private int p;

    JPXReader(byte[] data) {
        this.data = data;
        this.length = data.length;
    }

    public int getLimit() {
        return this.length;
    }

    public byte readByte() {
        return this.data[this.p++];
    }

    public int readUByte() {
        return this.data[this.p++] & 0xFF;
    }

    public int readUShort() {
        return (this.data[this.p++] & 0xFF) << 8 | this.data[this.p++] & 0xFF;
    }

    public short readShort() {
        return (short)((this.data[this.p++] & 0xFF) << 8 | this.data[this.p++] & 0xFF);
    }

    public int readInt() {
        return this.readUShort() << 16 | this.readUShort();
    }

    public int getPosition() {
        return this.p;
    }

    public long readLong() {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value += ((long)this.data[this.p++] & 0xFFL) << (i << 3);
        }
        return value;
    }

    public void setPosition(int pos) {
        this.p = pos;
    }

    public int getRemaining() {
        return this.length - this.p;
    }
}

