/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.JDeliImage;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.OutputStream;

public class JpegEncoder
extends JDeliImage {
    private int quality = 50;
    private static final int[] QL = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
    private static final int[] QC = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    private static final int[] ZIGZAG = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    private static final int[] CODESDCL = new int[]{0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] SYMBOLSDCL = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] CODESACL = new int[]{0, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
    private static final int[] SYMBOLSACL = new int[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, 129, 145, 161, 8, 35, 66, 177, 193, 21, 82, 209, 240, 36, 51, 98, 114, 130, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    private static final int[] CODESDCC = new int[]{0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final int[] SYMBOLSDCC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] CODESACC = new int[]{0, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
    private static final int[] SYMBOLSACC = new int[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, 129, 8, 20, 66, 145, 161, 177, 193, 9, 35, 51, 82, 240, 21, 98, 114, 209, 10, 22, 36, 52, 225, 37, 241, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232, 233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    private final int[] TL = new int[64];
    private final int[] TC = new int[64];
    private final float[] FDL = new float[64];
    private final float[] FDC = new float[64];
    private final int[] DU = new int[64];
    private final int[] DCHTL = new int[12];
    private final int[] DCHTC = new int[12];
    private final int[] ACHTL = new int[256];
    private final int[] ACHTC = new int[256];
    private final int[] codes = new int[65536];
    private final int[] items = new int[65536];
    private int buffer;
    private int pointer = 7;
    private byte[] pixelBytes;
    private int[] pixelInts;
    private final byte[] bArr = new byte[1024];
    private int bp;
    private final int bLen = this.bArr.length;
    private OutputStream stream;

    public void write(BufferedImage image, OutputStream out) throws IOException {
        this.stream = out;
        this.updatePixelHolder(image);
        this.encode(image.getWidth(), image.getHeight(), image.getType());
        if (this.bp > 0) {
            this.stream.write(this.bArr, 0, this.bp);
        }
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public int getQuality() {
        return this.quality;
    }

    private void generateQTables(float qq) {
        int j;
        int i;
        for (i = 0; i < 64; ++i) {
            j = (int)(((float)QL[i] * qq + 50.0f) / 100.0f);
            this.TL[JpegEncoder.ZIGZAG[i]] = j < 1 ? 1 : (j > 255 ? 255 : j);
        }
        for (i = 0; i < 64; ++i) {
            j = (int)(((float)QC[i] * qq + 50.0f) / 100.0f);
            this.TC[JpegEncoder.ZIGZAG[i]] = j < 1 ? 1 : (j > 255 ? 255 : j);
        }
        float[] multipliyer = new float[]{1.0f, 1.3870399f, 1.306563f, 1.1758755f, 1.0f, 0.78569496f, 0.5411961f, 0.27589938f};
        int k = 0;
        for (int row = 0; row < 8; ++row) {
            for (int col = 0; col < 8; ++col) {
                double mrc8 = (double)(multipliyer[row] * multipliyer[col]) * 8.0;
                this.FDL[k] = (float)(1.0 / ((double)this.TL[ZIGZAG[k]] * mrc8));
                this.FDC[k] = (float)(1.0 / ((double)this.TC[ZIGZAG[k]] * mrc8));
                ++k;
            }
        }
    }

    private static void generateHuffmanMapping(int[] huffman, int[] codes, int[] lookup) {
        int value = 0;
        int index = 0;
        for (int i = 1; i <= 16; ++i) {
            for (int j = 1; j <= codes[i]; ++j) {
                int t = lookup[index];
                huffman[t] = value << 16 | i;
                ++index;
                ++value;
            }
            value *= 2;
        }
    }

    private void generateHuffmanItems() {
        int low = 1;
        int high = 2;
        for (int i = 1; i <= 15; ++i) {
            for (int j = low; j < high; ++j) {
                this.items[Short.MAX_VALUE + j] = i;
                this.codes[Short.MAX_VALUE + j] = j << 16 | i;
            }
            for (int nrneg = -(high - 1); nrneg <= -low; ++nrneg) {
                this.items[Short.MAX_VALUE + nrneg] = i;
                this.codes[Short.MAX_VALUE + nrneg] = high - 1 + nrneg << 16 | i;
            }
            low <<= 1;
            high <<= 1;
        }
    }

    private void putHuffBits(int bs) throws IOException {
        int value = bs >> 16;
        int pp = (bs & 0xFFFF) - 1;
        while (pp >= 0) {
            if ((value & 1 << pp) != 0) {
                this.buffer |= 1 << this.pointer;
            }
            --pp;
            --this.pointer;
            if (this.pointer >= 0) continue;
            if (this.buffer == 255) {
                this.putByte(255);
                this.putByte(0);
            } else {
                this.putByte(this.buffer);
            }
            this.pointer = 7;
            this.buffer = 0;
        }
    }

    private void putByte(int v) throws IOException {
        if (this.bp == this.bLen) {
            this.stream.write(this.bArr);
            this.bp = 0;
        }
        this.bArr[this.bp++] = (byte)v;
    }

    private void putChar(int v) throws IOException {
        this.putByte(v >> 8 & 0xFF);
        this.putByte(v & 0xFF);
    }

    private static void forwardDCT(float[] inp) {
        float t12;
        float t11;
        float t13;
        float t10;
        float t4;
        float t3;
        float t5;
        float t2;
        float t6;
        float t1;
        float t7;
        float t0;
        float d7;
        float d6;
        float d5;
        float d4;
        float d3;
        float d2;
        float d1;
        float d0;
        int p;
        for (p = 0; p < 64; p += 8) {
            d0 = inp[p];
            d1 = inp[p + 1];
            d2 = inp[p + 2];
            d3 = inp[p + 3];
            d4 = inp[p + 4];
            d5 = inp[p + 5];
            d6 = inp[p + 6];
            d7 = inp[p + 7];
            t0 = d0 + d7;
            t7 = d0 - d7;
            t1 = d1 + d6;
            t6 = d1 - d6;
            t2 = d2 + d5;
            t5 = d2 - d5;
            t3 = d3 + d4;
            t4 = d3 - d4;
            t10 = t0 + t3;
            t13 = t0 - t3;
            t11 = t1 + t2;
            t12 = t1 - t2;
            inp[p] = t10 + t11;
            inp[p + 4] = t10 - t11;
            d1 = (t12 + t13) * 0.70710677f;
            inp[p + 2] = t13 + d1;
            inp[p + 6] = t13 - d1;
            t10 = t4 + t5;
            t12 = t6 + t7;
            d5 = (t10 - t12) * 0.38268343f;
            d2 = 0.5411961f * t10 + d5;
            d4 = 1.306563f * t12 + d5;
            d3 = (t5 + t6) * 0.70710677f;
            d6 = t7 + d3;
            d7 = t7 - d3;
            inp[p + 5] = d7 + d2;
            inp[p + 3] = d7 - d2;
            inp[p + 1] = d6 + d4;
            inp[p + 7] = d6 - d4;
        }
        for (p = 0; p < 8; ++p) {
            d0 = inp[p];
            d1 = inp[p + 8];
            d2 = inp[p + 16];
            d3 = inp[p + 24];
            d4 = inp[p + 32];
            d5 = inp[p + 40];
            d6 = inp[p + 48];
            d7 = inp[p + 56];
            t0 = d0 + d7;
            t7 = d0 - d7;
            t1 = d1 + d6;
            t6 = d1 - d6;
            t2 = d2 + d5;
            t5 = d2 - d5;
            t3 = d3 + d4;
            t4 = d3 - d4;
            t10 = t0 + t3;
            t13 = t0 - t3;
            t11 = t1 + t2;
            t12 = t1 - t2;
            inp[p] = t10 + t11;
            inp[p + 32] = t10 - t11;
            d1 = (t12 + t13) * 0.70710677f;
            t10 = t4 + t5;
            t12 = t6 + t7;
            d5 = (t10 - t12) * 0.38268343f;
            d2 = 0.5411961f * t10 + d5;
            d4 = 1.306563f * t12 + d5;
            d3 = (t5 + t6) * 0.70710677f;
            d6 = t7 + d3;
            d7 = t7 - d3;
            inp[p + 16] = t13 + d1;
            inp[p + 48] = t13 - d1;
            inp[p + 40] = d7 + d2;
            inp[p + 24] = d7 - d2;
            inp[p + 8] = d6 + d4;
            inp[p + 56] = d6 - d4;
        }
    }

    private void writeAPP0() throws IOException {
        this.putChar(65504);
        this.putChar(16);
        this.putByte(74);
        this.putByte(70);
        this.putByte(73);
        this.putByte(70);
        this.putByte(0);
        this.putByte(1);
        this.putByte(1);
        this.putByte(0);
        this.putChar(1);
        this.putChar(1);
        this.putByte(0);
        this.putByte(0);
    }

    private void writeSOF0(int width, int height, boolean isGray) throws IOException {
        this.putChar(65472);
        if (isGray) {
            this.putChar(11);
            this.putByte(8);
            this.putChar(height);
            this.putChar(width);
            this.putByte(1);
            this.putByte(0);
            this.putByte(17);
            this.putByte(0);
        } else {
            this.putChar(17);
            this.putByte(8);
            this.putChar(height);
            this.putChar(width);
            this.putByte(3);
            this.putByte(1);
            this.putByte(17);
            this.putByte(0);
            this.putByte(2);
            this.putByte(17);
            this.putByte(1);
            this.putByte(3);
            this.putByte(17);
            this.putByte(1);
        }
    }

    private void writeSOS(boolean isGray) throws IOException {
        this.putChar(65498);
        if (isGray) {
            this.putChar(8);
            this.putByte(1);
            this.putByte(0);
            this.putByte(0);
        } else {
            this.putChar(12);
            this.putByte(3);
            this.putByte(1);
            this.putByte(0);
            this.putByte(2);
            this.putByte(17);
            this.putByte(3);
            this.putByte(17);
        }
        this.putByte(0);
        this.putByte(63);
        this.putByte(0);
    }

    private void writeDQT(boolean isGray) throws IOException {
        this.putChar(65499);
        if (isGray) {
            this.putChar(67);
            this.putByte(0);
            for (int i = 0; i < 64; ++i) {
                this.putByte(this.TL[i]);
            }
        } else {
            this.putChar(132);
            this.putByte(0);
            for (int i = 0; i < 64; ++i) {
                this.putByte(this.TL[i]);
            }
            this.putByte(1);
            for (int j = 0; j < 64; ++j) {
                this.putByte(this.TC[j]);
            }
        }
    }

    private void writeDHT(boolean isGray) throws IOException {
        this.putChar(65476);
        if (isGray) {
            int i;
            this.putChar(210);
            this.putByte(0);
            for (i = 0; i < 16; ++i) {
                this.putByte(CODESDCL[i + 1]);
            }
            for (i = 0; i < 12; ++i) {
                this.putByte(SYMBOLSDCL[i]);
            }
            this.putByte(16);
            for (i = 0; i < 16; ++i) {
                this.putByte(CODESACL[i + 1]);
            }
            for (i = 0; i <= 161; ++i) {
                this.putByte(SYMBOLSACL[i]);
            }
        } else {
            int i;
            this.putChar(418);
            this.putByte(0);
            for (i = 0; i < 16; ++i) {
                this.putByte(CODESDCL[i + 1]);
            }
            for (i = 0; i <= 11; ++i) {
                this.putByte(SYMBOLSDCL[i]);
            }
            this.putByte(16);
            for (i = 0; i < 16; ++i) {
                this.putByte(CODESACL[i + 1]);
            }
            for (i = 0; i <= 161; ++i) {
                this.putByte(SYMBOLSACL[i]);
            }
            this.putByte(1);
            for (i = 0; i < 16; ++i) {
                this.putByte(CODESDCC[i + 1]);
            }
            for (i = 0; i <= 11; ++i) {
                this.putByte(SYMBOLSDCC[i]);
            }
            this.putByte(17);
            for (int o = 0; o < 16; ++o) {
                this.putByte(CODESACC[o + 1]);
            }
            for (int p = 0; p <= 161; ++p) {
                this.putByte(SYMBOLSACC[p]);
            }
        }
    }

    private int compress(float[] CDU, float[] fdtbl, int DC, int[] huffDC, int[] huffAC) throws IOException {
        int end0pos;
        int pos;
        int EOB = huffAC[0];
        int M16zeroes = huffAC[240];
        JpegEncoder.forwardDCT(CDU);
        for (int j = 0; j < 64; ++j) {
            float fq = CDU[j] * fdtbl[j];
            this.DU[JpegEncoder.ZIGZAG[j]] = (int)(fq > 0.0f ? (double)fq + 0.5 : (double)fq - 0.5);
        }
        int Diff = this.DU[0] - DC;
        DC = this.DU[0];
        if (Diff == 0) {
            this.putHuffBits(huffDC[0]);
        } else {
            pos = Short.MAX_VALUE + Diff;
            this.putHuffBits(huffDC[this.items[pos]]);
            this.putHuffBits(this.codes[pos]);
        }
        for (end0pos = 63; end0pos > 0 && this.DU[end0pos] == 0; --end0pos) {
        }
        if (end0pos == 0) {
            this.putHuffBits(EOB);
            return DC;
        }
        for (int i = 1; i <= end0pos; ++i) {
            int startpos = i;
            while (this.DU[i] == 0 && i <= end0pos) {
                ++i;
            }
            int nrzeroes = i - startpos;
            if (nrzeroes >= 16) {
                int lng = nrzeroes >> 4;
                for (int nrmarker = 1; nrmarker <= lng; ++nrmarker) {
                    this.putHuffBits(M16zeroes);
                }
                nrzeroes &= 0xF;
            }
            pos = Short.MAX_VALUE + this.DU[i];
            this.putHuffBits(huffAC[(nrzeroes << 4) + this.items[pos]]);
            this.putHuffBits(this.codes[pos]);
        }
        if (end0pos != 63) {
            this.putHuffBits(EOB);
        }
        return DC;
    }

    private void encode(int width, int height, int type) throws IOException {
        this.quality = this.quality <= 0 ? 1 : (this.quality > 100 ? 100 : this.quality);
        int qq = this.quality < 50 ? 5000 / this.quality : 200 - (this.quality << 1);
        this.generateQTables(qq);
        JpegEncoder.generateHuffmanMapping(this.DCHTL, CODESDCL, SYMBOLSDCL);
        JpegEncoder.generateHuffmanMapping(this.DCHTC, CODESDCC, SYMBOLSDCC);
        JpegEncoder.generateHuffmanMapping(this.ACHTL, CODESACL, SYMBOLSACL);
        JpegEncoder.generateHuffmanMapping(this.ACHTC, CODESACC, SYMBOLSACC);
        this.generateHuffmanItems();
        boolean isGray = type == 10;
        this.buffer = 0;
        this.pointer = 7;
        this.putChar(65496);
        this.writeAPP0();
        this.writeDQT(isGray);
        this.writeSOF0(width, height, isGray);
        this.writeDHT(isGray);
        this.writeSOS(isGray);
        int DCY = 0;
        int DCU = 0;
        int DCV = 0;
        this.buffer = 0;
        this.pointer = 7;
        float[] unitY = new float[64];
        float[] unitU = new float[64];
        float[] unitV = new float[64];
        int maxLen = width * height;
        for (int y = 0; y < height; y += 8) {
            for (int x = 0; x < width; x += 8) {
                int start = width * y + x;
                for (int pos = 0; pos < 64; ++pos) {
                    int row = pos >> 3;
                    int col = pos & 7;
                    int p = start + row * width + col;
                    if (y + row >= height) {
                        p -= width * (y + 1 + row - height);
                    }
                    if (x + col >= width) {
                        p -= x + col - width + 4;
                    }
                    if (p > maxLen || p < 0) continue;
                    JpegEncoder.updateYUV(this.pixelBytes, this.pixelInts, p, type, unitY, unitU, unitV, pos);
                }
                if (isGray) {
                    DCY = this.compress(unitY, this.FDL, DCY, this.DCHTL, this.ACHTL);
                    continue;
                }
                DCY = this.compress(unitY, this.FDL, DCY, this.DCHTL, this.ACHTL);
                DCU = this.compress(unitU, this.FDC, DCU, this.DCHTC, this.ACHTC);
                DCV = this.compress(unitV, this.FDC, DCV, this.DCHTC, this.ACHTC);
            }
        }
        if (this.pointer >= 0) {
            int n = this.pointer + 1;
            int m = (1 << this.pointer + 1) - 1;
            this.putHuffBits(m << 16 | n);
        }
        this.putChar(65497);
    }

    private void updatePixelHolder(BufferedImage source) {
        switch (source.getType()) {
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                this.pixelBytes = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.pixelInts = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                break;
            }
            default: {
                BufferedImage image2 = new BufferedImage(source.getWidth(), source.getHeight(), 1);
                Graphics g2 = image2.getGraphics();
                g2.drawImage(source, 0, 0, null);
                g2.dispose();
                this.pixelInts = ((DataBufferInt)image2.getRaster().getDataBuffer()).getData();
            }
        }
    }

    private static void updateYUV(byte[] pixelBytes, int[] pixelInts, int p, int type, float[] unitY, float[] unitU, float[] unitV, int pos) {
        int r;
        int g;
        int b;
        switch (type) {
            case 5: {
                int v = p * 3;
                b = pixelBytes[v] & 0xFF;
                g = pixelBytes[v + 1] & 0xFF;
                r = pixelBytes[v + 2] & 0xFF;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int v = pixelInts[p];
                r = v >> 16 & 0xFF;
                g = v >> 8 & 0xFF;
                b = v & 0xFF;
                break;
            }
            case 4: {
                int v = pixelInts[p];
                r = v & 0xFF;
                g = v >> 8 & 0xFF;
                b = v >> 16 & 0xFF;
                break;
            }
            case 6: 
            case 7: {
                int v = p * 4;
                b = pixelBytes[v + 1] & 0xFF;
                g = pixelBytes[v + 2] & 0xFF;
                r = pixelBytes[v + 3] & 0xFF;
                break;
            }
            case 10: {
                int v;
                g = b = (v = pixelBytes[p] & 0xFF);
                r = b;
                break;
            }
            default: {
                int v = pixelInts[p];
                r = v >> 16 & 0xFF;
                g = v >> 8 & 0xFF;
                b = v & 0xFF;
            }
        }
        unitY[pos] = (128 + 76 * r + 150 * g + 29 * b >> 8) - 128;
        unitU[pos] = 128 + 127 * b - 84 * g - 43 * r >> 8;
        unitV[pos] = 128 + 127 * r - 106 * g - 21 * b >> 8;
    }
}

