/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.jpeg.Component;

class DCT {
    private static final double[][] a = new double[8][8];
    private static final double[][] b = new double[8][8];

    DCT() {
    }

    public static void IDCTQ12(Component component, int offset) {
        int k;
        int j;
        int i;
        short[] pixels = component.codeBlock;
        int[] qt = component.qTable;
        int p = 0;
        double[][] input = new double[8][8];
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j2 = 0; j2 < 8; ++j2) {
                input[i2][j2] = pixels[offset + p] * qt[p];
                ++p;
            }
        }
        double[][] temp = new double[8][8];
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 8; ++j) {
                temp[i][j] = 0.0;
                for (k = 0; k < 8; ++k) {
                    double[] dArray = temp[i];
                    int n = j;
                    dArray[n] = dArray[n] + input[i][k] * a[k][j];
                }
            }
        }
        p = 0;
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 8; ++j) {
                double temp1 = 0.0;
                for (k = 0; k < 8; ++k) {
                    temp1 += b[i][k] * temp[k][j];
                }
                if ((temp1 += 2048.0) < 0.0) {
                    pixels[offset + p] = 0;
                } else if (temp1 > 4095.0) {
                    pixels[offset + p] = 255;
                } else {
                    int v = (int)Math.round(temp1);
                    pixels[offset + p] = (short)(v >> 4);
                }
                ++p;
            }
        }
    }

    public static void IDCTQ(Component component, int offset, int[] p) {
        int[] qt = component.qTable;
        short[] inp = component.codeBlock;
        DCT.processRows(offset, p, qt, inp);
        DCT.processCols(offset, p, inp);
    }

    private static void processRows(int offset, int[] p, int[] qt, short[] inp) {
        for (int row = 0; row < 64; row += 8) {
            int t;
            int temp = offset + row;
            int p0 = inp[temp];
            int p1 = inp[temp + 1];
            int p2 = inp[temp + 2];
            int p3 = inp[temp + 3];
            int p4 = inp[temp + 4];
            int p5 = inp[temp + 5];
            int p6 = inp[temp + 6];
            int p7 = inp[temp + 7];
            p0 *= qt[row];
            if ((p1 | p2 | p3 | p4 | p5 | p6 | p7) == 0) {
                p[row] = t = 5793 * p0 + 512 >> 10;
                p[row + 1] = t;
                p[row + 2] = t;
                p[row + 3] = t;
                p[row + 4] = t;
                p[row + 5] = t;
                p[row + 6] = t;
                p[row + 7] = t;
                continue;
            }
            p1 *= qt[row + 1];
            p2 *= qt[row + 2];
            p3 *= qt[row + 3];
            p5 *= qt[row + 5];
            p6 *= qt[row + 6];
            int v0 = 5793 * p0 + 128 >> 8;
            int v1 = 5793 * (p4 *= qt[row + 4]) + 128 >> 8;
            int v4 = 2896 * (p1 - (p7 *= qt[row + 7])) + 128 >> 8;
            int v7 = 2896 * (p1 + p7) + 128 >> 8;
            int v5 = p3 << 4;
            int v6 = p5 << 4;
            v0 = v0 + v1 + 1 >> 1;
            v1 = v0 - v1;
            t = p2 * 3784 + p6 * 1567 + 128 >> 8;
            int v2 = p2 * 1567 - p6 * 3784 + 128 >> 8;
            v4 = v4 + v6 + 1 >> 1;
            v6 = v4 - v6;
            v7 = v7 + v5 + 1 >> 1;
            v5 = v7 - v5;
            v0 = v0 + t + 1 >> 1;
            int v3 = v0 - t;
            v1 = v1 + v2 + 1 >> 1;
            v2 = v1 - v2;
            t = v4 * 2276 + v7 * 3406 + 2048 >> 12;
            v4 = v4 * 3406 - v7 * 2276 + 2048 >> 12;
            v7 = t;
            t = v5 * 799 + v6 * 4017 + 2048 >> 12;
            v5 = v5 * 4017 - v6 * 799 + 2048 >> 12;
            p[row] = v0 + v7;
            p[row + 7] = v0 - v7;
            p[row + 1] = v1 + t;
            p[row + 6] = v1 - t;
            p[row + 2] = v2 + v5;
            p[row + 5] = v2 - v5;
            p[row + 3] = v3 + v4;
            p[row + 4] = v3 - v4;
        }
    }

    private static void processCols(int offset, int[] p, short[] inp) {
        for (int col = 0; col < 8; ++col) {
            int tt;
            int p0 = p[col];
            int p1 = p[col + 8];
            int p2 = p[col + 16];
            int p3 = p[col + 24];
            int p4 = p[col + 32];
            int p5 = p[col + 40];
            int p6 = p[col + 48];
            int p7 = p[col + 56];
            int temp = offset + col;
            if ((p1 | p2 | p3 | p4 | p5 | p6 | p7) == 0) {
                int t;
                tt = 5793 * p0 + 8192 >> 14;
                inp[temp] = t = (short)(tt < -2040 ? 0 : (short)(tt >= 2024 ? 255 : (short)(tt + 2056 >> 4)));
                inp[temp + 8] = t;
                inp[temp + 16] = t;
                inp[temp + 24] = t;
                inp[temp + 32] = t;
                inp[temp + 40] = t;
                inp[temp + 48] = t;
                inp[temp + 56] = t;
                continue;
            }
            int v0 = 5793 * p0 + 2048 >> 12;
            int v1 = 5793 * p4 + 2048 >> 12;
            int v4 = 2896 * (p1 - p7) + 2048 >> 12;
            int v7 = 2896 * (p1 + p7) + 2048 >> 12;
            v0 = (v0 + v1 + 1 >> 1) + 4112;
            v1 = v0 - v1;
            int v3 = p2 * 3784 + p6 * 1567 + 2048 >> 12;
            int v2 = p2 * 1567 - p6 * 3784 + 2048 >> 12;
            v4 = v4 + p5 + 1 >> 1;
            int v6 = v4 - p5;
            v7 = v7 + p3 + 1 >> 1;
            int v5 = v7 - p3;
            v0 = v0 + v3 + 1 >> 1;
            v3 = v0 - v3;
            v1 = v1 + v2 + 1 >> 1;
            v2 = v1 - v2;
            tt = v4 * 2276 + v7 * 3406 + 2048 >> 12;
            v4 = v4 * 3406 - v7 * 2276 + 2048 >> 12;
            v7 = tt;
            tt = v5 * 799 + v6 * 4017 + 2048 >> 12;
            v5 = v5 * 4017 - v6 * 799 + 2048 >> 12;
            p0 = v0 + v7;
            p7 = v0 - v7;
            p1 = v1 + tt;
            p6 = v1 - tt;
            p2 = v2 + v5;
            p5 = v2 - v5;
            p3 = v3 + v4;
            p4 = v3 - v4;
            short s = (short)(p0 < 16 ? 0 : (short)(inp[temp] = (short)(p0 >= 4080 ? 255 : (short)(p0 >> 4))));
            short s2 = (short)(p1 < 16 ? 0 : (short)(inp[temp + 8] = (short)(p1 >= 4080 ? 255 : (short)(p1 >> 4))));
            short s3 = (short)(p2 < 16 ? 0 : (short)(inp[temp + 16] = (short)(p2 >= 4080 ? 255 : (short)(p2 >> 4))));
            short s4 = (short)(p3 < 16 ? 0 : (short)(inp[temp + 24] = (short)(p3 >= 4080 ? 255 : (short)(p3 >> 4))));
            short s5 = (short)(p4 < 16 ? 0 : (short)(inp[temp + 32] = (short)(p4 >= 4080 ? 255 : (short)(p4 >> 4))));
            short s6 = (short)(p5 < 16 ? 0 : (short)(inp[temp + 40] = (short)(p5 >= 4080 ? 255 : (short)(p5 >> 4))));
            short s7 = (short)(p6 < 16 ? 0 : (short)(inp[temp + 48] = (short)(p6 >= 4080 ? 255 : (short)(p6 >> 4))));
            inp[temp + 56] = (short)(p7 < 16 ? 0 : (short)(p7 >= 4080 ? 255 : (short)(p7 >> 4)));
        }
    }

    static {
        for (int j = 0; j < 8; ++j) {
            DCT.a[0][j] = 1.0 / Math.sqrt(8.0);
            DCT.b[j][0] = a[0][j];
        }
        for (int i = 1; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                DCT.a[i][j] = Math.sqrt(0.25) * Math.cos(2.0 * (double)j * (double)i * Math.PI / 16.0);
                DCT.b[j][i] = a[i][j];
            }
        }
    }
}

