/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image;

import com.idrsolutions.image.ImageTypeFinder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.bmp.BmpDecoder;
import com.idrsolutions.image.bmp.BmpEncoder;
import com.idrsolutions.image.dicom.DicomDecoder;
import com.idrsolutions.image.gif.GifDecoder;
import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg.JpegEncoder;
import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import com.idrsolutions.image.png.PngCompressor;
import com.idrsolutions.image.png.PngDecoder;
import com.idrsolutions.image.png.PngEncoder;
import com.idrsolutions.image.psd.PsdDecoder;
import com.idrsolutions.image.tiff.TiffDecoder;
import com.idrsolutions.image.tiff.TiffEncoder;
import com.idrsolutions.image.webm.WebpDecoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JDeli
extends JDeliImage {
    private static final Color BACKGROUND_COLOR;
    private static final Color FOREGROUND_COLOR;
    private static final Font FONT;

    public static BufferedImage read(File imageFile) throws Exception {
        Object dec;
        byte[] test;
        try (FileInputStream fis = new FileInputStream(imageFile);){
            test = new byte[Math.min(140, (int)imageFile.length())];
            fis.read(test);
        }
        BufferedImage image = null;
        if (ImageTypeFinder.isPNG(test)) {
            dec = new PngDecoder();
            image = ((PngDecoder)dec).read(imageFile);
        } else if (ImageTypeFinder.isJpeg(test)) {
            dec = new JpegDecoder();
            try (FileInputStream fis = new FileInputStream(imageFile);){
                byte[] data = new byte[(int)imageFile.length()];
                fis.read(data);
                image = ((JpegDecoder)dec).read(data);
            }
        } else if (ImageTypeFinder.isJpeg2000(test)) {
            dec = new Jpeg2000Decoder();
            try (FileInputStream fis = new FileInputStream(imageFile);){
                byte[] data = new byte[(int)imageFile.length()];
                fis.read(data);
                image = ((Jpeg2000Decoder)dec).read(data);
            }
        } else if (ImageTypeFinder.isTiff(test)) {
            RandomAccessFile raf = new RandomAccessFile(imageFile, "r");
            TiffDecoder dec2 = new TiffDecoder(raf);
            image = dec2.read();
            raf.close();
        } else if (ImageTypeFinder.isGif(test)) {
            dec = new GifDecoder();
            image = ((GifDecoder)dec).read(imageFile);
        } else if (ImageTypeFinder.isWebp(test)) {
            dec = new WebpDecoder();
            try (FileInputStream fis = new FileInputStream(imageFile);){
                byte[] data = new byte[(int)imageFile.length()];
                fis.read(data);
                image = ((WebpDecoder)dec).read(data);
            }
        } else if (ImageTypeFinder.isPsd(test)) {
            dec = new PsdDecoder();
            image = ((PsdDecoder)dec).read(imageFile);
        } else if (ImageTypeFinder.isBmp(test)) {
            dec = new BmpDecoder();
            image = ((BmpDecoder)dec).read(imageFile);
        } else if (ImageTypeFinder.isDicom(test)) {
            dec = new DicomDecoder();
            image = ((DicomDecoder)dec).read(imageFile);
        }
        return image;
    }

    public static BufferedImage read(byte[] data) throws Exception {
        BufferedImage image = null;
        if (ImageTypeFinder.isPNG(data)) {
            PngDecoder dec = new PngDecoder();
            image = dec.read(data);
        } else if (ImageTypeFinder.isJpeg(data)) {
            JpegDecoder dec = new JpegDecoder();
            image = dec.read(data);
        } else if (ImageTypeFinder.isJpeg2000(data)) {
            Jpeg2000Decoder dec = new Jpeg2000Decoder();
            image = dec.read(data);
        } else if (ImageTypeFinder.isTiff(data)) {
            TiffDecoder dec = new TiffDecoder(data);
            image = dec.read();
        } else if (ImageTypeFinder.isGif(data)) {
            GifDecoder dec = new GifDecoder();
            image = dec.read(data);
        } else if (ImageTypeFinder.isWebp(data)) {
            WebpDecoder dec = new WebpDecoder();
            image = dec.read(data);
        } else if (ImageTypeFinder.isPsd(data)) {
            PsdDecoder dec = new PsdDecoder();
            image = dec.read(data);
        } else if (ImageTypeFinder.isBmp(data)) {
            BmpDecoder dec = new BmpDecoder();
            image = dec.read(data);
        } else if (ImageTypeFinder.isDicom(data)) {
            DicomDecoder dec = new DicomDecoder();
            image = dec.read(data);
        }
        return image;
    }

    public static void write(BufferedImage image, OutputFormat format, File outputFile) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));
        JDeli.write(image, format, bos);
        bos.close();
    }

    public static void write(BufferedImage image, OutputFormat format, OutputStream outputStream) throws Exception {
        switch (format) {
            case PNG: {
                PngEncoder enc1 = new PngEncoder();
                enc1.write(image, outputStream);
                break;
            }
            case TIFF: {
                TiffEncoder enc2 = new TiffEncoder();
                enc2.write(image, outputStream);
                break;
            }
            case JPEG: {
                JpegEncoder enc3 = new JpegEncoder();
                enc3.write(image, outputStream);
                break;
            }
            case BMP: {
                BmpEncoder enc4 = new BmpEncoder();
                enc4.write(image, outputStream);
            }
        }
    }

    private static void doAction(String actionAsString, String[] args) {
        Action action;
        try {
            action = Action.valueOf(actionAsString.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            action = null;
        }
        if (action == null) {
            System.out.println("JDeli action '" + actionAsString + "' not recognised. Available actions are: " + Arrays.toString((Object[])Action.values()));
        } else {
            switch (action) {
                case COMPRESSPNG: {
                    PngCompressor.main(args);
                }
            }
        }
    }

    private static String[] removeFirstValue(String[] inputValues) {
        int newArraySize = inputValues.length - 1;
        String[] outputValues = new String[newArraySize];
        System.arraycopy(inputValues, 1, outputValues, 0, newArraySize);
        return outputValues;
    }

    private static JLabel getStyledLabel(JLabel label) {
        label.setFont(FONT);
        label.setForeground(FOREGROUND_COLOR);
        return label;
    }

    private static void showHelpWindow() {
        JFrame jf = new JFrame("JDeli - Java Decoding and Encoding Library for Images");
        jf.setSize(440, 400);
        jf.setDefaultCloseOperation(3);
        final JPanel panel = new JPanel();
        panel.setBackground(BACKGROUND_COLOR);
        panel.setLayout(new GridLayout(0, 1));
        ImageIcon logo = new ImageIcon(JDeli.class.getResource("/com/idrsolutions/image/res/logo.png"));
        JLabel idrLogo = new JLabel(logo);
        jf.getContentPane().add((Component)idrLogo, "North");
        panel.add(JDeli.getStyledLabel(new JLabel(" JDeli - Java Decoding and Encoding Library for Images")));
        panel.add(JDeli.getStyledLabel(new JLabel(" ")));
        panel.add(JDeli.getStyledLabel(new JLabel(" Features: ")));
        panel.add(JDeli.getStyledLabel(new JLabel("          TiffEncoder (Single/Multi Page)")));
        panel.add(JDeli.getStyledLabel(new JLabel("          TiffDecoder (Single/Multi Page)")));
        panel.add(JDeli.getStyledLabel(new JLabel("          PngEncoder")));
        panel.add(JDeli.getStyledLabel(new JLabel("          PngCompressor")));
        panel.add(JDeli.getStyledLabel(new JLabel("          JpegEncoder")));
        panel.add(JDeli.getStyledLabel(new JLabel("          JpegDecoder")));
        panel.add(JDeli.getStyledLabel(new JLabel("          Jpeg2000Decoder")));
        panel.add(JDeli.getStyledLabel(new JLabel(" ")));
        final JLabel homeURL = new JLabel("<html>&nbsp;Homepage: https://www.idrsolutions.com/jdeli</html>");
        homeURL.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setCursor(new Cursor(12));
                homeURL.setText("<html>&nbsp;Homepage: <u>https://www.idrsolutions.com/jdeli</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setCursor(new Cursor(0));
                homeURL.setText("<html>&nbsp;Homepage: https://www.idrsolutions.com/jdeli</html>");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.idrsolutions.com/jdeli"));
                }
                catch (IOException | URISyntaxException e1) {
                    JDeli.writeLog("Exception: " + e1.getMessage());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        panel.add(JDeli.getStyledLabel(homeURL));
        final JLabel licenceURL = new JLabel("<html>&nbsp;License: https://www.idrsolutions.com/jdeli/license</html>");
        licenceURL.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setCursor(new Cursor(12));
                licenceURL.setText("<html>&nbsp;License: <u>https://www.idrsolutions.com/jdeli/license</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setCursor(new Cursor(0));
                licenceURL.setText("<html>&nbsp;License: https://www.idrsolutions.com/jdeli/license</html>");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.idrsolutions.com/jdeli/license"));
                }
                catch (URISyntaxException e1) {
                    JDeli.writeLog("Exception: " + e1.getMessage());
                }
                catch (IOException ex) {
                    JDeli.writeLog("Exception :" + ex.getMessage());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        panel.add(JDeli.getStyledLabel(licenceURL));
        final JLabel javadocURL = new JLabel("<html>&nbsp;Javadoc: https://files.idrsolutions.com/jdeli-javadoc/</html>");
        javadocURL.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setCursor(new Cursor(12));
                javadocURL.setText("<html>&nbsp;Javadoc: <u>https://files.idrsolutions.com/jdeli-javadoc/</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setCursor(new Cursor(0));
                javadocURL.setText("<html>&nbsp;Javadoc: https://files.idrsolutions.com/jdeli-javadoc/</html>");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://files.idrsolutions.com/jdeli-javadoc/"));
                }
                catch (IOException | URISyntaxException e1) {
                    JDeli.writeLog("Exception: " + e1.getMessage());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        panel.add(JDeli.getStyledLabel(javadocURL));
        panel.add(JDeli.getStyledLabel(new JLabel(" ")));
        panel.add(JDeli.getStyledLabel(new JLabel(" Available command line arguments are: " + Arrays.toString((Object[])Action.values()))));
        panel.add(JDeli.getStyledLabel(new JLabel(" ")));
        jf.getContentPane().add((Component)panel, "Center");
        JPanel bPanel = new JPanel();
        bPanel.setBackground(BACKGROUND_COLOR);
        JButton button = new JButton("OK");
        button.addActionListener(e -> jf.dispose());
        button.setSize(150, 75);
        button.setMaximumSize(new Dimension(150, 75));
        bPanel.add(button);
        jf.getContentPane().add((Component)bPanel, "South");
        jf.setVisible(true);
        jf.setLocationRelativeTo(null);
        jf.setResizable(false);
    }

    private static void writeLog(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JDeli.showHelp();
        } else {
            JDeli.doAction(args[0], JDeli.removeFirstValue(args));
        }
    }

    private static void showHelp() {
        String info = "JDeli - Java Decoding and Encoding Library for Images\n\nFeatures:\n\tTiffEncoder (Single/Multi Page)\n\tTiffDecoder (Single/Multi Page)\n\tPngEncoder\n\tPngCompressor\n\tJpegEncoder\n\tJpegDecoder\n\tJpeg2000Decoder\n\nHomepage: https://www.idrsolutions.com/jdeli\nLicense: https://www.idrsolutions.com/jdeli/license\nJavadoc: https://files.idrsolutions.com/jdeli-javadoc/\n\nAvailable command line arguments are: " + Arrays.toString((Object[])Action.values());
        if (System.console() != null) {
            System.out.println(info);
        } else if (!GraphicsEnvironment.isHeadless()) {
            JDeli.showHelpWindow();
        }
    }

    static {
        String imageLib2ClassPath = "com/idrsolutions/image/JDeliImageSupport.class";
        ClassLoader loader = JDeli.class.getClassLoader();
        if (loader.getResource("com/idrsolutions/image/JDeliImageSupport.class") != null) {
            try {
                loader.loadClass("com.idrsolutions.image.JDeliImageSupport").newInstance();
            }
            catch (Exception ex) {
                System.out.println("[PDF] Unable to instance JDeli " + ex);
            }
        }
        BACKGROUND_COLOR = new Color(84, 130, 31);
        FOREGROUND_COLOR = Color.WHITE;
        FONT = new Font("SansSerif", 1, 13);
    }

    private static enum Action {
        COMPRESSPNG;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum OutputFormat {
        PNG,
        TIFF,
        JPEG,
        BMP;

    }
}

