/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image;

import java.nio.ByteBuffer;

public class ImageTypeFinder {
    public static boolean isPNG(byte[] data) {
        byte[] pngMark = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        for (int i = 0; i < pngMark.length; ++i) {
            if (data[i] == pngMark[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isTiff(byte[] data) {
        return data[0] == 73 && data[1] == 73 || data[0] == 77 && data[1] == 77;
    }

    public static boolean isJpeg(byte[] data) {
        return (data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 216;
    }

    public static boolean isJpeg2000(byte[] data) {
        if ((data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 79) {
            return true;
        }
        ByteBuffer buff = ByteBuffer.wrap(data);
        int signLen = buff.getInt();
        int signType = buff.getInt();
        return signLen == 12 && signType == 1783636000;
    }

    public static boolean isGif(byte[] data) {
        return data[0] == 71 && data[1] == 73 && data[2] == 70 && data[3] == 56 && data[4] == 55 | data[4] == 57 && data[5] == 97;
    }

    public static boolean isPsd(byte[] data) {
        ByteBuffer buff = ByteBuffer.wrap(data);
        int signLen = buff.getInt();
        return signLen == 943870035;
    }

    public static boolean isWebp(byte[] data) {
        String str = new String(data);
        return str.startsWith("RIFF") && str.contains("WEBP");
    }

    public static boolean isBmp(byte[] data) {
        int TYPE_BM = 19778;
        int type = data[0] & 0xFF | (data[1] & 0xFF) << 8;
        return type == 19778;
    }

    public static boolean isDicom(byte[] data) {
        return data.length > 132 && data[128] == 68 && data[129] == 73 && data[130] == 67 && data[131] == 77;
    }
}

