/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import coldfusion.xml.rpc.module.CFWSDL20ToAllAxisServicesBuilder;
import coldfusion.xml.rpc.module.ParserUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.WSDL11ToAllAxisServicesBuilder;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAxisServiceBuilder;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.Emitter;
import org.apache.axis2.wsdl.codegen.extension.CodeGenExtension;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class CFCodeGenerationEngine {
    private static final Log log = LogFactory.getLog(CodeGenerationEngine.class);
    private List preExtensions = new ArrayList();
    private List postExtensions = new ArrayList();
    private CodeGenConfiguration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFCodeGenerationEngine(CommandLineOptionParser parser, Document wsdlDocument) throws CodeGenerationException {
        Map allOptions = parser.getAllOptions();
        try {
            CommandLineOption option = (CommandLineOption)allOptions.get("uri");
            String wsdlUri = option.getOptionValue();
            if (wsdlUri.startsWith("http")) {
                URL url = new URL(wsdlUri);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setInstanceFollowRedirects(false);
                connection.getResponseCode();
                String newLocation = connection.getHeaderField("Location");
                if (newLocation != null) {
                    wsdlUri = newLocation;
                }
            }
            this.configuration = new CodeGenConfiguration(allOptions);
            if ("2.0".equals(this.configuration.getWSDLVersion())) {
                WSDL20ToAxisServiceBuilder builder;
                if (this.configuration.getServiceName() != null || this.configuration.getDatabindingType().equals("jibx")) {
                    builder = new WSDL20ToAxisServiceBuilder(wsdlUri, this.configuration.getServiceName(), this.configuration.getPortName(), this.configuration.isAllPorts());
                    builder.setCodegen(true);
                    this.configuration.addAxisService(builder.populateService());
                } else {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    InputStream is = null;
                    try {
                        DOMSource xmlSource = new DOMSource(wsdlDocument);
                        StreamResult outputTarget = new StreamResult(outputStream);
                        ParserUtils.createSecureTransformerFactory().newTransformer().transform(xmlSource, outputTarget);
                        is = new ByteArrayInputStream(outputStream.toByteArray());
                        builder = new CFWSDL20ToAllAxisServicesBuilder(is, this.configuration.getPortName());
                        builder.setCodegen(true);
                        builder.setAllPorts(this.configuration.isAllPorts());
                        this.configuration.setAxisServices(((CFWSDL20ToAllAxisServicesBuilder)builder).populateAllServices());
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        outputStream.close();
                    }
                }
            } else {
                Definition wsdl4jDef = this.readInTheWSDLFile(wsdlUri, wsdlDocument);
                Map imports = wsdl4jDef.getImports();
                if (imports != null && imports.size() > 0) {
                    this.configuration.setWsdlDefinition(this.readInTheWSDLFile(wsdlUri, wsdlDocument));
                } else {
                    this.configuration.setWsdlDefinition(wsdl4jDef);
                }
                QName serviceQname = null;
                if (this.configuration.getServiceName() != null) {
                    serviceQname = new QName(wsdl4jDef.getTargetNamespace(), this.configuration.getServiceName());
                }
                if (serviceQname != null || this.configuration.getDatabindingType().equals("jibx")) {
                    WSDL11ToAxisServiceBuilder builder = new WSDL11ToAxisServiceBuilder(wsdl4jDef, serviceQname, this.configuration.getPortName(), this.configuration.isAllPorts());
                    builder.setCodegen(true);
                    this.configuration.addAxisService(builder.populateService());
                } else {
                    WSDL11ToAllAxisServicesBuilder builder = new WSDL11ToAllAxisServicesBuilder(wsdl4jDef, this.configuration.getPortName());
                    builder.setCodegen(true);
                    builder.setAllPorts(this.configuration.isAllPorts());
                    this.configuration.setAxisServices(builder.populateAllServices());
                }
            }
            this.configuration.setBaseURI(this.getBaseURI(wsdlUri));
        }
        catch (AxisFault axisFault) {
            throw new CodeGenerationException(CodegenMessages.getMessage((String)"engine.wsdlParsingException"), (Throwable)axisFault);
        }
        catch (WSDLException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage((String)"engine.wsdlParsingException"), (Throwable)e);
        }
        catch (Exception e) {
            throw new CodeGenerationException(CodegenMessages.getMessage((String)"engine.wsdlParsingException"), (Throwable)e);
        }
        this.loadExtensions();
    }

    private void loadExtensions() throws CodeGenerationException {
        String[] postExtensions;
        String[] extensions = ConfigPropertyFileLoader.getExtensionClassNames();
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                this.addPreExtension((CodeGenExtension)this.getObjectFromClassName(extensions[i].trim()));
            }
        }
        if ((postExtensions = ConfigPropertyFileLoader.getPostExtensionClassNames()) != null) {
            for (int i = 0; i < postExtensions.length; ++i) {
                this.addPostExtension((CodeGenExtension)this.getObjectFromClassName(postExtensions[i].trim()));
            }
        }
    }

    private void addPreExtension(CodeGenExtension ext) {
        if (ext != null) {
            this.preExtensions.add(ext);
        }
    }

    private void addPostExtension(CodeGenExtension ext) {
        if (ext != null) {
            this.postExtensions.add(ext);
        }
    }

    public void generate() throws CodeGenerationException {
        try {
            for (int i = 0; i < this.preExtensions.size(); ++i) {
                ((CodeGenExtension)this.preExtensions.get(i)).engage(this.configuration);
            }
            TypeMapper mapper = this.configuration.getTypeMapper();
            if (mapper == null) {
                throw new CodeGenerationException(CodegenMessages.getMessage((String)"engine.noProperDatabindingException"));
            }
            Map emitterMap = ConfigPropertyFileLoader.getLanguageEmitterMap();
            String className = (String)emitterMap.get(this.configuration.getOutputLanguage());
            if (className == null) {
                throw new Exception(CodegenMessages.getMessage((String)"engine.emitterMissing"));
            }
            Emitter emitter = (Emitter)this.getObjectFromClassName(className);
            emitter.setCodeGenConfiguration(this.configuration);
            emitter.setMapper(mapper);
            if (this.configuration.isServerSide()) {
                emitter.emitSkeleton();
                if (this.configuration.isGenerateAll()) {
                    emitter.emitStub();
                }
            } else {
                emitter.emitStub();
            }
            for (int i = 0; i < this.postExtensions.size(); ++i) {
                ((CodeGenExtension)this.postExtensions.get(i)).engage(this.configuration);
            }
        }
        catch (ClassCastException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage((String)"engine.wrongEmitter"), (Throwable)e);
        }
        catch (Exception e) {
            throw new CodeGenerationException((Throwable)e);
        }
    }

    public Definition readInTheWSDLFile(String uri, Document wsdlDocument) throws WSDLException {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.importDocuments", true);
        return reader.readWSDL(uri, wsdlDocument);
    }

    private Object getObjectFromClassName(String className) throws CodeGenerationException {
        try {
            Class<?> extensionClass = this.getClass().getClassLoader().loadClass(className);
            return extensionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)CodegenMessages.getMessage((String)"engine.extensionLoadProblem"), (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage((String)"engine.extensionInstantiationProblem"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage((String)"engine.illegalExtension"), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            log.debug((Object)CodegenMessages.getMessage((String)"engine.extensionLoadProblem"), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            throw new CodeGenerationException((Throwable)e);
        }
    }

    private String getBaseURI(String currentURI) throws URISyntaxException, IOException {
        File file = new File(currentURI);
        if (file.exists()) {
            return file.getCanonicalFile().getParentFile().toURI().toString();
        }
        String uriFragment = currentURI.substring(0, currentURI.lastIndexOf("/"));
        return uriFragment + (uriFragment.endsWith("/") ? "" : "/");
    }

    public CodeGenConfiguration getConfiguration() {
        return this.configuration;
    }
}

