/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfFontList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] DEFAULT_FONT = "\\deff".getBytes();
    private static final byte[] FONT_TABLE = "\\fonttbl".getBytes();
    public static final byte[] FONT_NUMBER = "\\f".getBytes();
    private ArrayList fontList = new ArrayList();

    public RtfFontList(RtfDocument rtfDocument) {
        super(rtfDocument);
        this.fontList.add(new RtfFont(this.document, 0));
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public int getFontNumber(RtfFont rtfFont) {
        if (rtfFont instanceof RtfParagraphStyle) {
            rtfFont = new RtfFont(this.document, rtfFont);
        }
        int n = -1;
        for (int i = 0; i < this.fontList.size(); ++i) {
            if (!this.fontList.get(i).equals(rtfFont)) continue;
            n = i;
        }
        if (n == -1) {
            n = this.fontList.size();
            this.fontList.add(rtfFont);
        }
        return n;
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        outputStream.write(DEFAULT_FONT);
        outputStream.write(this.intToByteArray(0));
        outputStream.write(OPEN_GROUP);
        outputStream.write(FONT_TABLE);
        for (int i = 0; i < this.fontList.size(); ++i) {
            outputStream.write(OPEN_GROUP);
            outputStream.write(FONT_NUMBER);
            outputStream.write(this.intToByteArray(i));
            RtfFont rtfFont = (RtfFont)this.fontList.get(i);
            rtfFont.writeDefinition(outputStream);
            outputStream.write(COMMA_DELIMITER);
            outputStream.write(CLOSE_GROUP);
        }
        outputStream.write(CLOSE_GROUP);
        outputStream.write(10);
    }
}

