/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.image;

import coldfusion.log.CFLogs;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NodeList;

public class ConvertCMYKToRGB {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage returnRGBImage(File fileName) throws IOException {
        BufferedImage img = null;
        ImageInputStream stream = null;
        try {
            stream = ImageIO.createImageInputStream(fileName);
            img = ConvertCMYKToRGB.returnRGBImage(stream);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return img;
    }

    public static BufferedImage returnRGBImage(ImageInputStream stream) throws IOException {
        ImageReader reader = ConvertCMYKToRGB.getJpegImageReader();
        reader.setInput(stream, true, true);
        String format = reader.getFormatName();
        if ("JPEG".equalsIgnoreCase(format) || "JPG".equalsIgnoreCase(format)) {
            try {
                IIOMetadata metadata = reader.getImageMetadata(0);
                String metadataFormat = metadata.getNativeMetadataFormatName();
                IIOMetadataNode iioNode = (IIOMetadataNode)metadata.getAsTree(metadataFormat);
                NodeList children = iioNode.getElementsByTagName("app14Adobe");
                if (children.getLength() > 0) {
                    iioNode = (IIOMetadataNode)children.item(0);
                    int transform = Integer.parseInt(iioNode.getAttribute("transform"));
                    Raster raster = reader.readRaster(0, reader.getDefaultReadParam());
                    reader.dispose();
                    return ConvertCMYKToRGB.createJPEG4(raster, transform);
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error((Throwable)e);
                Raster raster = reader.readRaster(0, reader.getDefaultReadParam());
                reader.dispose();
                return ConvertCMYKToRGB.createJPEG4(raster, 1);
            }
        }
        throw new RuntimeException("No ImageReaders found");
    }

    private static BufferedImage createJPEG4(Raster raster, int xform) {
        int w = raster.getWidth();
        int h = raster.getHeight();
        byte[] rgb = new byte[w * h * 3];
        if (xform == 2) {
            float[] Y = raster.getSamples(0, 0, w, h, 0, (float[])null);
            float[] Cb = raster.getSamples(0, 0, w, h, 1, (float[])null);
            float[] Cr = raster.getSamples(0, 0, w, h, 2, (float[])null);
            float[] K = raster.getSamples(0, 0, w, h, 3, (float[])null);
            int i = 0;
            int imax = Y.length;
            int base = 0;
            while (i < imax) {
                float k = 220.0f - K[i];
                float y = 255.0f - Y[i];
                float cb = 255.0f - Cb[i];
                float cr = 255.0f - Cr[i];
                double val = (double)y + 1.402 * (double)(cr - 128.0f) - (double)k;
                rgb[base] = (byte)((val = (val - 128.0) * (double)0.65f + 128.0) < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                val = (double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f) - (double)k;
                val = (val - 128.0) * (double)0.65f + 128.0;
                rgb[base + 1] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                val = (double)y + 1.772 * (double)(cb - 128.0f) - (double)k;
                val = (val - 128.0) * (double)0.65f + 128.0;
                rgb[base + 2] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                ++i;
                base += 3;
            }
        } else {
            int[] C = raster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] M = raster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] Y = raster.getSamples(0, 0, w, h, 2, (int[])null);
            int[] K = raster.getSamples(0, 0, w, h, 3, (int[])null);
            int i = 0;
            int imax = C.length;
            int base = 0;
            while (i < imax) {
                int c = 255 - C[i];
                int m = 255 - M[i];
                int y = 255 - Y[i];
                int k = 255 - K[i];
                float kk = (float)k / 255.0f;
                rgb[base] = (byte)(255.0f - Math.min(255.0f, (float)c * kk + (float)k));
                rgb[base + 1] = (byte)(255.0f - Math.min(255.0f, (float)m * kk + (float)k));
                rgb[base + 2] = (byte)(255.0f - Math.min(255.0f, (float)y * kk + (float)k));
                ++i;
                base += 3;
            }
        }
        raster = Raster.createInterleavedRaster(new DataBufferByte(rgb, rgb.length), w, h, w * 3, 3, new int[]{0, 1, 2}, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, false, true, 1, 0);
        return new BufferedImage(cm, (WritableRaster)raster, true, null);
    }

    private static ImageReader getJpegImageReader() {
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName("jpeg");
        ImageReader reader = null;
        while (iter.hasNext() && (reader = iter.next()).getClass().getName().equals("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader")) {
        }
        return reader;
    }

    private static BufferedImage sophisticatedColorConvert(BufferedImage src, BufferedImage dst) {
        ICC_ColorSpace srcCS = (ICC_ColorSpace)src.getColorModel().getColorSpace();
        ICC_Profile srcProf = srcCS.getProfile();
        byte[] header = srcProf.getData(1751474532);
        ConvertCMYKToRGB.intToBigEndian(1935896178, header, 12);
        srcProf.setData(1751474532, header);
        ColorConvertOp op = new ColorConvertOp(null);
        return op.filter(src, dst);
    }

    private static void intToBigEndian(int value, byte[] array, int index) {
        array[index] = (byte)(value >> 24);
        array[index + 1] = (byte)(value >> 16);
        array[index + 2] = (byte)(value >> 8);
        array[index + 3] = (byte)value;
    }

    private static boolean isCMYK(File file) {
        boolean result = false;
        BufferedImage img = null;
        try {
            img = ImageIO.read(file);
        }
        catch (IOException e) {
            System.out.println(e.getMessage() + ": " + file.getName());
        }
        if (img != null) {
            int colorSpaceType = img.getColorModel().getColorSpace().getType();
            result = colorSpaceType == 9;
        }
        return result;
    }
}

