/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.image;

import coldfusion.image.core.ImageExceptions;
import coldfusion.util.RB;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;

public class CaptchaMaker {
    static final int MAX_LINES = 51;
    static final int MAX_SHAPES = 16;
    static final int MAX_POLYGON_SIDE = 7;
    static final int MAX_STROKE_SIZE = 4;
    static final int MAX_TEXT_COLOR_RANGE = 50;
    static final int MIN_COLOR_RANGE = 80;
    static final int MIN_TEXT_ALPHA_RANGE = 180;
    static final float MIN_SIDE_PROPORTION = 0.1f;
    static final float MAX_SIDE_PROPORTION = 0.75f;
    String text;
    int width;
    int height;
    int fontSize;
    BufferedImage bImg;
    long seed = new GregorianCalendar().getTimeInMillis();
    Random randomizer = new Random(this.seed);
    private Font[] userFonts = null;
    private static Font[] availableSystemFonts = null;
    private static Map systemFontMap = null;
    float top;
    int left;
    PrintWriter prn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public CaptchaMaker(int width, int height, String text, int fontSize, String fontList) {
        this.width = width;
        this.height = height;
        this.text = text;
        this.fontSize = fontSize;
        if (text == null) throw new ImageExceptions.InvalidCaptchaArgumentException(RB.getString((Object)this, (String)"EmptyCaptchaTextException"));
        if (text.trim().length() == 0) {
            throw new ImageExceptions.InvalidCaptchaArgumentException(RB.getString((Object)this, (String)"EmptyCaptchaTextException"));
        }
        if (width <= 0) throw new ImageExceptions.InvalidCaptchaArgumentException(RB.getString((Object)this, (String)"InvalidCaptchaDimension"));
        if (height <= 0) throw new ImageExceptions.InvalidCaptchaArgumentException(RB.getString((Object)this, (String)"InvalidCaptchaDimension"));
        if (fontSize <= 0) {
            throw new ImageExceptions.InvalidCaptchaArgumentException(RB.getString((Object)this, (String)"InvalidCaptchaDimension"));
        }
        if ((double)width < 1.5 * (double)text.length() * (double)fontSize * 0.72) {
            throw new ImageExceptions.InvalidCaptchaArgumentException(RB.getString((Object)this, (String)"CaptchaWidthException") + Math.round(1.5 * (double)text.length() * (double)fontSize * 0.72));
        }
        if ((double)height < (double)(2 * fontSize) * 0.72) {
            throw new ImageExceptions.InvalidCaptchaArgumentException(RB.getString((Object)this, (String)"CaptchaHeightException") + Math.round((double)(2 * fontSize) * 0.72));
        }
        this.bImg = new BufferedImage(width, height, 2);
        if (availableSystemFonts == null || systemFontMap == null) {
            Class<CaptchaMaker> clazz = CaptchaMaker.class;
            // MONITORENTER : coldfusion.image.CaptchaMaker.class
            if (availableSystemFonts == null && systemFontMap == null) {
                GraphicsEnvironment graphicsEvn = GraphicsEnvironment.getLocalGraphicsEnvironment();
                availableSystemFonts = graphicsEvn.getAllFonts();
                systemFontMap = this.getMap();
            }
            // MONITOREXIT : clazz
        }
        this.userFonts = this.getUserFonts(fontList);
        this.left = (int)(0.01f * (float)width) + (int)(this.randomizer.nextFloat() * (float)width / (2.0f * (float)text.length()));
    }

    public BufferedImage createCaptcha(int difficulty) {
        int i;
        Graphics2D g = this.bImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawBackground(g);
        if (difficulty > 0) {
            int numLines = this.randomizer.nextInt(51 * difficulty / 2);
            for (i = 0; i < numLines; ++i) {
                this.drawQCurve(g);
            }
        }
        if (difficulty > 1) {
            int numShapes = this.randomizer.nextInt(7);
            for (i = 0; i < numShapes; ++i) {
                this.drawShape(g);
            }
        }
        this.drawText(g);
        g.dispose();
        return this.bImg;
    }

    public Point getRandomPoint() {
        Point borderPt = null;
        switch (this.randomizer.nextInt(4)) {
            case 0: {
                borderPt = new Point(0, this.randomizer.nextInt(this.height));
                break;
            }
            case 1: {
                borderPt = new Point(this.randomizer.nextInt(this.width), 0);
                break;
            }
            case 2: {
                borderPt = new Point(this.width, this.randomizer.nextInt(this.height));
                break;
            }
            case 3: {
                borderPt = new Point(this.randomizer.nextInt(this.width), this.height);
            }
        }
        return borderPt;
    }

    public void drawBackground(Graphics2D g) {
        Color startColor = this.getRandomColor();
        Color endColor = this.getRandomColor();
        GradientPaint gradientPaint = null;
        if (this.randomizer.nextBoolean()) {
            gradientPaint = new GradientPaint(this.getRandomPoint(), startColor, this.getRandomPoint(), endColor.brighter(), true);
            g.setPaint(gradientPaint);
        } else {
            g.setColor(startColor);
        }
        Rectangle background = new Rectangle(this.width, this.height);
        g.fill(background);
    }

    public void drawShape(Graphics2D g) {
        int numEdges = 3 + this.randomizer.nextInt(7);
        int minEdge = Math.round((float)this.height * 0.1f);
        int maxEdge = Math.round((float)this.height * 0.75f);
        g.setColor(this.getRandomColor());
        g.setStroke(this.getRandomStroke());
        Polygon p = new Polygon();
        for (int i = 0; i < numEdges; ++i) {
            p.addPoint(this.randomizer.nextInt(this.width + 1), this.randomizer.nextInt(this.height + 1));
        }
        if (this.randomizer.nextBoolean()) {
            g.drawPolygon(p);
        } else {
            g.fillPolygon(p);
        }
    }

    public void drawQCurve(Graphics2D g) {
        Point point1 = new Point(this.randomizer.nextInt(this.width + 1), this.randomizer.nextInt(this.height + 1));
        Point point2 = new Point(this.randomizer.nextInt(this.width + 1), this.randomizer.nextInt(this.height + 1));
        Point point3 = new Point(this.randomizer.nextInt(this.width + 1), this.randomizer.nextInt(this.height + 1));
        g.setStroke(this.getRandomStroke());
        g.setColor(this.getRandomColor());
        QuadCurve2D.Double qcurve = new QuadCurve2D.Double(point1.getX(), point1.getY(), point2.getX(), point2.getY(), point3.getX(), point3.getY());
        g.draw(qcurve);
    }

    public Stroke getRandomStroke() {
        return new BasicStroke(this.randomizer.nextInt(4) + 1);
    }

    public AffineTransform getRotateTransform() {
        double angle = -1.0 * this.randomizer.nextDouble() + this.randomizer.nextDouble();
        AffineTransform transformation = new AffineTransform();
        if (this.randomizer.nextBoolean()) {
            transformation.rotate(angle, 0.0, 0.0);
        }
        return transformation;
    }

    public Color getRandomColor() {
        int r = 80 + this.randomizer.nextInt(176);
        int g = this.randomizer.nextInt(176);
        int b = this.randomizer.nextInt(176);
        int alpha = this.randomizer.nextInt(256);
        return new Color(r, g, b, alpha);
    }

    public Color getRandomTextColor() {
        int r = this.randomizer.nextInt(50);
        int g = this.randomizer.nextInt(50);
        int b = this.randomizer.nextInt(50);
        int alpha = 180 + this.randomizer.nextInt(76);
        return new Color(r, g, b, alpha);
    }

    public Font getTextFont() {
        AffineTransform at1 = this.getRotateTransform();
        int fontNumber = this.randomizer.nextInt(this.userFonts.length);
        Font f = this.userFonts[fontNumber].deriveFont((float)this.fontSize);
        f = f.deriveFont(at1);
        return f;
    }

    public void drawText(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double prevLetterEnd = 0.0;
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            Font font = this.getTextFont();
            while (!font.canDisplay(c)) {
                font = this.getTextFont();
            }
            g.setFont(font);
            FontRenderContext frc = g.getFontRenderContext();
            GlyphVector gv = font.createGlyphVector(frc, new String("" + c));
            Rectangle rect = gv.getGlyphPixelBounds(0, null, 0.0f, 0.0f);
            double originX = rect.getMinX();
            double originY = rect.getMaxY();
            double width = ((RectangularShape)rect).getWidth();
            double height = ((RectangularShape)rect).getHeight();
            int remainingWidth = (int)Math.floor(((double)this.width - width - prevLetterEnd) / (double)(this.text.length() - i));
            int x = 0;
            x = remainingWidth <= 0 ? remainingWidth : this.randomizer.nextInt(remainingWidth);
            double thisX = prevLetterEnd + (double)x - originX;
            int remainingHeight = (int)Math.floor((double)this.height - height);
            int y = 0;
            y = remainingHeight <= 0 ? remainingHeight : this.randomizer.nextInt(remainingHeight);
            double thisY = height + (double)y - originY;
            g.translate((int)thisX, (int)thisY);
            g.setColor(this.getRandomTextColor());
            Shape glyph = gv.getGlyphOutline(0);
            g.fill(glyph);
            g.translate(-1 * (int)thisX, -1 * (int)thisY);
            prevLetterEnd = thisX + width;
        }
    }

    private Font[] getUserFonts(String fontList) {
        if (fontList == null) {
            return availableSystemFonts;
        }
        if (fontList.trim().length() == 0) {
            return availableSystemFonts;
        }
        fontList = fontList.toUpperCase();
        HashSet<Font> fonts = new HashSet<Font>();
        String[] fontNames = fontList.split(",");
        for (int i = 0; i < fontNames.length; ++i) {
            Font font = (Font)systemFontMap.get(fontNames[i]);
            if (font == null) continue;
            fonts.add(font);
        }
        if (fonts.size() == 0) {
            return availableSystemFonts;
        }
        return fonts.toArray(new Font[0]);
    }

    private Map getMap() {
        HashMap<String, Font> map = new HashMap<String, Font>();
        for (int i = 0; i < availableSystemFonts.length; ++i) {
            Font availableFont = availableSystemFonts[i];
            map.put(availableFont.getFamily().toUpperCase(), availableFont);
            map.put(availableFont.getName().toUpperCase(), availableFont);
        }
        return map;
    }
}

