/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.validation;

import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.schema.ImportedSchema;
import org.apache.woden.schema.InlinedSchema;
import org.apache.woden.schema.Schema;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;

public class WSDLDocumentValidator {
    public boolean validate(DescriptionElement descElement, ErrorReporter errorReporter) throws WSDLException {
        boolean isValid = true;
        isValid = this.testAssertionDescription1006(descElement, errorReporter);
        ImportElement[] imports = descElement.getImportElements();
        int numImports = imports.length;
        for (int i = 0; i < numImports; ++i) {
        }
        if (!this.validateTypes(descElement.getTypesElement(), errorReporter)) {
            isValid = false;
        }
        if (!this.validateInterfaces(descElement, descElement.getInterfaceElements(), errorReporter)) {
            isValid = false;
        }
        return isValid;
    }

    protected boolean validateTypes(TypesElement types, ErrorReporter errorReporter) throws WSDLException {
        boolean isValid = true;
        if (types == null) {
            return true;
        }
        for (ImportedSchema schema : types.getImportedSchemas()) {
            if (!this.testAssertionSchema1069(schema, errorReporter)) {
                isValid = false;
            }
            if (this.testAssertionSchema1070(schema, errorReporter)) continue;
            isValid = false;
        }
        InlinedSchema[] inlinedSchemas = types.getInlinedSchemas();
        if (!this.testAssertionSchema1073(inlinedSchemas, errorReporter)) {
            isValid = false;
        }
        return isValid;
    }

    protected boolean validateInterfaces(DescriptionElement descElement, InterfaceElement[] interfaces, ErrorReporter errorReporter) throws WSDLException {
        boolean isValid = true;
        for (InterfaceElement interfaceElem : interfaces) {
            if (!this.testAssertionInterface1012(interfaceElem, errorReporter)) {
                isValid = false;
            }
            if (!this.validateInterfaceFaults(descElement, interfaceElem.getInterfaceFaultElements(), errorReporter)) {
                isValid = false;
            }
            if (this.validateInterfaceOperations(descElement, interfaceElem.getInterfaceOperationElements(), errorReporter)) continue;
            isValid = false;
        }
        return isValid;
    }

    protected boolean validateInterfaceFaults(DescriptionElement descElement, InterfaceFaultElement[] faultElements, ErrorReporter errorReporter) throws WSDLException {
        boolean isValid = true;
        for (InterfaceFaultElement faultElement : faultElements) {
            if (this.testAssertionSchema1066(descElement, faultElement.getElement().getQName(), errorReporter)) continue;
            isValid = false;
        }
        return isValid;
    }

    protected boolean validateInterfaceOperations(DescriptionElement descElement, InterfaceOperationElement[] interfaceOperations, ErrorReporter errorReporter) throws WSDLException {
        boolean isValid = true;
        for (InterfaceOperationElement interfaceOperation : interfaceOperations) {
            if (!this.validateInterfaceMessageReferences(descElement, interfaceOperation.getInterfaceMessageReferenceElements(), errorReporter)) {
                isValid = false;
            }
            if (this.validateInterfaceFaultReferences(descElement, interfaceOperation.getInterfaceFaultReferenceElements(), errorReporter)) continue;
            isValid = false;
        }
        return isValid;
    }

    protected boolean validateInterfaceMessageReferences(DescriptionElement descElement, InterfaceMessageReferenceElement[] messageReferences, ErrorReporter errorReporter) throws WSDLException {
        boolean isValid = true;
        return isValid;
    }

    protected boolean validateInterfaceFaultReferences(DescriptionElement descElement, InterfaceFaultReferenceElement[] faultReferences, ErrorReporter errorReporter) throws WSDLException {
        boolean isValid = true;
        for (InterfaceFaultReferenceElement faultReference : faultReferences) {
            if (this.testAssertionQNameResolution1064ForInterfaceFaultReference(faultReference, errorReporter)) continue;
            isValid = false;
        }
        return isValid;
    }

    protected boolean testAssertionDescription1006(DescriptionElement descElement, ErrorReporter errorReporter) throws WSDLException {
        URI targetNS = descElement.getTargetNamespace();
        if (!targetNS.isAbsolute()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Description-1006", new Object[]{targetNS}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionSchema1069(ImportedSchema schema, ErrorReporter errorReporter) throws WSDLException {
        XmlSchema schemaDef = schema.getSchemaDefinition();
        if (schemaDef == null) {
            return true;
        }
        String targetNS = schemaDef.getTargetNamespace();
        if (targetNS == null || targetNS.equals("")) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-1069", new Object[]{schema.getSchemaLocation()}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionSchema1070(ImportedSchema schema, ErrorReporter errorReporter) throws WSDLException {
        XmlSchema schemaDef = schema.getSchemaDefinition();
        if (schemaDef == null) {
            return true;
        }
        String importedSchemaTargetNS = schemaDef.getTargetNamespace();
        String specifiedTargetNS = schema.getNamespace().toString();
        if (specifiedTargetNS != null && !specifiedTargetNS.equals(importedSchemaTargetNS)) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-1070", new Object[]{specifiedTargetNS}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionSchema1073(InlinedSchema[] schema, ErrorReporter errorReporter) throws WSDLException {
        boolean isValid = true;
        int numInlineSchemas = schema.length;
        Hashtable<String, List<InlinedSchema>> schemas = new Hashtable<String, List<InlinedSchema>>();
        for (int i = 0; i < numInlineSchemas; ++i) {
            List<InlinedSchema> schemaList;
            InlinedSchema iSchema = schema[i];
            URI iSchemaNs = iSchema.getNamespace();
            if (iSchemaNs == null) continue;
            String ns = iSchemaNs.toString();
            if (schemas.containsKey(ns)) {
                schemaList = (List)schemas.get(ns);
                XmlSchemaObjectTable elements = iSchema.getSchemaDefinition().getElements();
                Iterator elementNames = elements.getNames();
                while (elementNames.hasNext()) {
                    QName elementName = (QName)elementNames.next();
                    Iterator otherInlineSchemas = schemaList.iterator();
                    while (otherInlineSchemas.hasNext()) {
                        if (((InlinedSchema)otherInlineSchemas.next()).getSchemaDefinition().getElementByName(elementName) == null) continue;
                        errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-1073", new Object[]{elementName, ns}, (short)2);
                        isValid = false;
                    }
                }
                XmlSchemaObjectTable types = iSchema.getSchemaDefinition().getSchemaTypes();
                Iterator typeNames = types.getNames();
                while (typeNames.hasNext()) {
                    QName typeName = (QName)typeNames.next();
                    Iterator otherInlineSchemas = schemaList.iterator();
                    while (otherInlineSchemas.hasNext()) {
                        if (((InlinedSchema)otherInlineSchemas.next()).getSchemaDefinition().getTypeByName(typeName) == null) continue;
                        errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-1073b", new Object[]{typeName, ns}, (short)2);
                        isValid = false;
                    }
                }
                schemaList.add(iSchema);
                continue;
            }
            schemaList = new ArrayList();
            schemaList.add(iSchema);
            schemas.put(ns, schemaList);
        }
        return isValid;
    }

    protected boolean testAssertionInterface1012(InterfaceElement interfaceElem, ErrorReporter errorReporter) throws WSDLException {
        boolean isValid = true;
        URI[] styleDefaults = interfaceElem.getStyleDefault();
        int numStyleDefaults = styleDefaults.length;
        for (int i = 0; i < numStyleDefaults; ++i) {
            if (styleDefaults[i].isAbsolute()) continue;
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Interface-1012", new Object[]{styleDefaults[i].toString()}, (short)2);
            isValid = false;
        }
        return isValid;
    }

    protected boolean testAssertionSchema1066(DescriptionElement descElement, QName qualifiedName, ErrorReporter errorReporter) throws WSDLException {
        if (qualifiedName != null && !qualifiedName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            String namespace = qualifiedName.getNamespaceURI();
            String localname = qualifiedName.getLocalPart();
            TypesElement types = descElement.getTypesElement();
            if (types == null) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-1066", new Object[]{localname, namespace}, (short)2);
                return false;
            }
            Schema[] schemas = types.getSchemas();
            int numSchemas = schemas.length;
            boolean schemaNotFound = true;
            for (int i = 0; i < numSchemas; ++i) {
                URI schemaNs = schemas[i].getNamespace();
                if (schemaNs == null || !schemaNs.toString().equals(namespace)) continue;
                schemaNotFound = false;
                break;
            }
            if (schemaNotFound) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-1066", new Object[]{localname, namespace}, (short)2);
                return false;
            }
        }
        return true;
    }

    protected boolean testAssertionQNameResolution1064ForInterfaceFaultReference(InterfaceFaultReferenceElement faultReference, ErrorReporter errorReporter) throws WSDLException {
        InterfaceFaultElement fault;
        QName ref = faultReference.getRef();
        if (ref != null && (fault = faultReference.getInterfaceFaultElement()) == null) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "QName-resolution-1064", new Object[]{ref.toString(), "interface fault reference", "interface fault"}, (short)2);
            return false;
        }
        return true;
    }
}

