/*
 * Decompiled with CFR 0.152.
 */
package com.ddtek.portal.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class DateFormatCache {
    private static final char MSEC_PATTERN = '#';
    private final String format;
    private int cacheSize = 0;
    private Cache cache;

    private String tidyFormat(String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl || c != 'S') {
                stringBuilder.append(c);
            } else {
                stringBuilder.append('#');
            }
            if (c != '\'') continue;
            bl = !bl;
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DateFormatCache(int n, String string, DateFormatCache dateFormatCache) {
        this.cacheSize = n;
        this.format = this.tidyFormat(string);
        Cache cache = null;
        if (dateFormatCache != null) {
            DateFormatCache dateFormatCache2 = dateFormatCache;
            synchronized (dateFormatCache2) {
                cache = dateFormatCache.cache;
            }
        }
        this.cache = new Cache(cache);
    }

    String getFormat(long l) {
        return this.cache.getFormat(l);
    }

    private class Cache {
        private long previousSeconds = 0L;
        private String previousFormat = "";
        private long first = 0L;
        private long last = 0L;
        private int offset = 0;
        private final Date currentDate = new Date();
        private String[] formatCache;
        private SimpleDateFormat formatter;
        private Cache parent = null;

        private Cache(Cache cache) {
            this.formatCache = new String[DateFormatCache.this.cacheSize];
            this.formatter = new SimpleDateFormat(DateFormatCache.this.format, Locale.US);
            this.formatter.setTimeZone(TimeZone.getDefault());
            this.parent = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getFormat(long l) {
            int n;
            long l2 = l / 1000L;
            if (l2 == this.previousSeconds) {
                return this.previousFormat;
            }
            this.previousSeconds = l2;
            int n2 = (this.offset + (int)(l2 - this.first)) % DateFormatCache.this.cacheSize;
            if (n2 < 0) {
                n2 += DateFormatCache.this.cacheSize;
            }
            if (l2 >= this.first && l2 <= this.last) {
                if (this.formatCache[n2] != null) {
                    this.previousFormat = this.formatCache[n2];
                    return this.previousFormat;
                }
            } else if (l2 >= this.last + (long)DateFormatCache.this.cacheSize || l2 <= this.first - (long)DateFormatCache.this.cacheSize) {
                this.first = l2;
                this.last = this.first + (long)DateFormatCache.this.cacheSize - 1L;
                n2 = 0;
                this.offset = 0;
                for (n = 1; n < DateFormatCache.this.cacheSize; ++n) {
                    this.formatCache[n] = null;
                }
            } else if (l2 > this.last) {
                n = 1;
                while ((long)n < l2 - this.last) {
                    this.formatCache[(n2 + ((DateFormatCache)DateFormatCache.this).cacheSize - n) % ((DateFormatCache)DateFormatCache.this).cacheSize] = null;
                    ++n;
                }
                this.first = l2 - (long)DateFormatCache.this.cacheSize;
                this.last = l2;
            } else {
                n = 1;
                while ((long)n < this.first - l2) {
                    this.formatCache[(n2 + n) % ((DateFormatCache)DateFormatCache.this).cacheSize] = null;
                    ++n;
                }
                this.first = l2;
                this.last = l2 + (long)DateFormatCache.this.cacheSize;
            }
            if (this.parent != null) {
                Cache cache = this.parent;
                synchronized (cache) {
                    this.previousFormat = this.parent.getFormat(l);
                }
            } else {
                this.currentDate.setTime(l);
                this.previousFormat = this.formatter.format(this.currentDate);
            }
            this.formatCache[n2] = this.previousFormat;
            return this.previousFormat;
        }
    }
}

