/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.NamedValue;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.CommonsTransportHeaders;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.transport.http.util.HTTPProxyConfigurationUtil;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHTTPSender {
    protected static final String ANONYMOUS = "anonymous";
    protected static final String PROXY_HOST_NAME = "proxy_host";
    protected static final String PROXY_PORT = "proxy_port";
    protected boolean chunked = false;
    protected String httpVersion = "HTTP/1.1";
    private static final Log log = LogFactory.getLog(AbstractHTTPSender.class);
    protected static final String PROTOCOL_HTTP = "http";
    protected static final String PROTOCOL_HTTPS = "https";
    protected TransportOutDescription proxyOutSetting = null;
    protected OMOutputFormat format = new OMOutputFormat();
    protected boolean isAllowedRetry = false;

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public void setHttpVersion(String version) throws AxisFault {
        if (version != null) {
            if ("HTTP/1.1".equals(version)) {
                this.httpVersion = "HTTP/1.1";
            } else if ("HTTP/1.0".equals(version)) {
                this.httpVersion = "HTTP/1.0";
                this.chunked = false;
            } else {
                throw new AxisFault("Parameter PROTOCOL Can have values only HTTP/1.0 or HTTP/1.1");
            }
        }
    }

    protected void obtainHTTPHeaderInformation(HttpMethodBase method, MessageContext msgContext) throws AxisFault {
        HeaderElement element;
        int i;
        CommonsTransportHeaders transportHeaders = new CommonsTransportHeaders(method.getResponseHeaders());
        msgContext.setProperty("TRANSPORT_HEADERS", (Object)transportHeaders);
        msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, (Object)new Integer(method.getStatusCode()));
        Header header = method.getResponseHeader("Content-Type");
        if (header != null) {
            HeaderElement[] headers = header.getElements();
            MessageContext inMessageContext = msgContext.getOperationContext().getMessageContext("In");
            String contentType = header.getValue();
            String charSetEnc = null;
            for (int i2 = 0; i2 < headers.length; ++i2) {
                NameValuePair charsetEnc = headers[i2].getParameterByName(HTTPConstants.CHAR_SET_ENCODING);
                if (charsetEnc == null) continue;
                charSetEnc = charsetEnc.getValue();
            }
            if (inMessageContext != null) {
                inMessageContext.setProperty("ContentType", (Object)contentType);
                inMessageContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            } else {
                HashMap<String, String> transportInfoMap = new HashMap<String, String>();
                transportInfoMap.put("ContentType", contentType);
                transportInfoMap.put("CHARACTER_SET_ENCODING", charSetEnc);
                msgContext.setProperty("TransportInfoMap", transportInfoMap);
            }
        }
        String sessionCookie = null;
        Header[] cookieHeaders = method.getResponseHeaders("Set-Cookie");
        String customCoookiId = (String)msgContext.getProperty("customCookieID");
        for (i = 0; i < cookieHeaders.length; ++i) {
            HeaderElement[] elements = cookieHeaders[i].getElements();
            for (int e = 0; e < elements.length; ++e) {
                element = elements[e];
                if ("axis_session".equalsIgnoreCase(element.getName()) || "JSESSIONID".equalsIgnoreCase(element.getName())) {
                    sessionCookie = this.processCookieHeader(element);
                }
                if (customCoookiId == null || !customCoookiId.equalsIgnoreCase(element.getName())) continue;
                sessionCookie = this.processCookieHeader(element);
            }
        }
        cookieHeaders = method.getResponseHeaders("Set-Cookie2");
        for (i = 0; i < cookieHeaders.length; ++i) {
            HeaderElement[] elements = cookieHeaders[i].getElements();
            for (int e = 0; e < elements.length; ++e) {
                element = elements[e];
                if ("axis_session".equalsIgnoreCase(element.getName()) || "JSESSIONID".equalsIgnoreCase(element.getName())) {
                    sessionCookie = this.processCookieHeader(element);
                }
                if (customCoookiId == null || !customCoookiId.equalsIgnoreCase(element.getName())) continue;
                sessionCookie = this.processCookieHeader(element);
            }
        }
        if (sessionCookie != null) {
            msgContext.getServiceContext().setProperty("Cookie", sessionCookie);
        }
    }

    private String processCookieHeader(HeaderElement element) {
        String cookie = element.getName() + "=" + element.getValue();
        NameValuePair[] parameters = element.getParameters();
        for (int j = 0; parameters != null && j < parameters.length; ++j) {
            NameValuePair parameter = parameters[j];
            cookie = cookie + "; " + parameter.getName() + "=" + parameter.getValue();
        }
        return cookie;
    }

    protected void processResponse(HttpMethodBase httpMethod, MessageContext msgContext) throws IOException {
        OperationContext opContext;
        this.obtainHTTPHeaderInformation(httpMethod, msgContext);
        InputStream in = httpMethod.getResponseBodyAsStream();
        if (in == null) {
            throw new AxisFault(Messages.getMessage((String)"canNotBeNull", (String)"InputStream"));
        }
        Header contentEncoding = httpMethod.getResponseHeader("Content-Encoding");
        if (contentEncoding != null) {
            if (contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                in = new GZIPInputStream(in);
            } else if (!"identity".equalsIgnoreCase(contentEncoding.getValue())) {
                throw new AxisFault("HTTP :unsupported content-encoding of '" + contentEncoding.getValue() + "' found");
            }
        }
        if ((opContext = msgContext.getOperationContext()) != null) {
            opContext.setProperty("TRANSPORT_IN", (Object)in);
        }
    }

    public abstract void send(MessageContext var1, URL var2, String var3) throws IOException;

    protected HostConfiguration getHostConfiguration(HttpClient client, MessageContext msgCtx, URL targetURL) throws AxisFault {
        boolean isAuthenticationEnabled = this.isAuthenticationEnabled(msgCtx);
        int port = targetURL.getPort();
        String protocol = targetURL.getProtocol();
        if (port == -1) {
            if (PROTOCOL_HTTP.equals(protocol)) {
                port = 80;
            } else if (PROTOCOL_HTTPS.equals(protocol)) {
                port = 443;
            }
        }
        HostConfiguration config = new HostConfiguration();
        Protocol protocolHandler = (Protocol)msgCtx.getOptions().getProperty("CUSTOM_PROTOCOL_HANDLER");
        if (protocolHandler == null) {
            config.setHost(targetURL.getHost(), port, targetURL.getProtocol());
        } else {
            config.setHost(targetURL.getHost(), port, protocolHandler);
        }
        if (isAuthenticationEnabled) {
            this.setAuthenticationInfo(client, msgCtx, config);
        }
        if (HTTPProxyConfigurationUtil.isProxyEnabled(msgCtx, targetURL)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Configuring HTTP proxy.");
            }
            HTTPProxyConfigurationUtil.configure(msgCtx, client, config);
        }
        return config;
    }

    protected boolean isAuthenticationEnabled(MessageContext msgCtx) {
        return msgCtx.getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_") != null;
    }

    protected void setAuthenticationInfo(HttpClient agent, MessageContext msgCtx, HostConfiguration config) throws AxisFault {
        Object obj = msgCtx.getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_");
        if (obj != null) {
            if (obj instanceof HttpTransportProperties.Authenticator) {
                Object creds;
                HttpTransportProperties.Authenticator authenticator = (HttpTransportProperties.Authenticator)obj;
                String username = authenticator.getUsername();
                String password = authenticator.getPassword();
                String host = authenticator.getHost();
                String domain = authenticator.getDomain();
                int port = authenticator.getPort();
                String realm = authenticator.getRealm();
                this.isAllowedRetry = authenticator.isAllowedRetry();
                HttpState tmpHttpState = null;
                HttpState httpState = (HttpState)msgCtx.getProperty("CACHED_HTTP_STATE");
                tmpHttpState = httpState != null ? httpState : agent.getState();
                agent.getParams().setAuthenticationPreemptive(authenticator.getPreemptiveAuthentication());
                if (host != null) {
                    creds = domain != null ? new NTCredentials(username, password, host, domain) : new UsernamePasswordCredentials(username, password);
                    tmpHttpState.setCredentials(new AuthScope(host, port, realm), (Credentials)creds);
                } else if (domain != null) {
                    creds = new NTCredentials(username, password, AuthScope.ANY_HOST, domain);
                    tmpHttpState.setCredentials(new AuthScope(AuthScope.ANY_HOST, port, realm), (Credentials)creds);
                } else {
                    creds = new UsernamePasswordCredentials(username, password);
                    tmpHttpState.setCredentials(new AuthScope(AuthScope.ANY), (Credentials)creds);
                }
                List schemes = authenticator.getAuthSchemes();
                if (schemes != null && schemes.size() > 0) {
                    ArrayList authPrefs = new ArrayList(3);
                    for (int i = 0; i < schemes.size(); ++i) {
                        if (schemes.get(i) instanceof AuthPolicy) {
                            authPrefs.add(schemes.get(i));
                            continue;
                        }
                        String scheme = (String)schemes.get(i);
                        if ("Basic".equals(scheme)) {
                            authPrefs.add("Basic");
                            continue;
                        }
                        if ("NTLM".equals(scheme)) {
                            authPrefs.add("NTLM");
                            continue;
                        }
                        if (!"Digest".equals(scheme)) continue;
                        authPrefs.add("Digest");
                    }
                    agent.getParams().setParameter("http.auth.scheme-priority", authPrefs);
                }
            } else {
                throw new AxisFault("HttpTransportProperties.Authenticator class cast exception");
            }
        }
    }

    protected MessageFormatter populateCommonProperties(MessageContext msgContext, URL url, HttpMethodBase httpMethod, HttpClient httpClient, String soapActionString) throws AxisFault {
        Object cookieString;
        if (this.isAuthenticationEnabled(msgContext)) {
            httpMethod.setDoAuthentication(true);
        }
        MessageFormatter messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgContext);
        url = messageFormatter.getTargetAddress(msgContext, this.format, url);
        httpMethod.setPath(url.getPath());
        httpMethod.setQueryString(url.getQuery());
        httpMethod.setRequestHeader("Content-Type", messageFormatter.getContentType(msgContext, this.format, soapActionString));
        httpMethod.setRequestHeader("Host", url.getHost());
        if (msgContext.getOptions() != null && msgContext.getOptions().isManageSession() && (cookieString = msgContext.getProperty("Cookie")) != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(cookieString);
            httpMethod.setRequestHeader("Cookie", buffer.toString());
        }
        if (this.httpVersion.equals("HTTP/1.0")) {
            httpClient.getParams().setVersion(HttpVersion.HTTP_1_0);
        }
        return messageFormatter;
    }

    protected void initializeTimeouts(MessageContext msgContext, HttpClient httpClient) {
        Integer tempSoTimeoutProperty = (Integer)msgContext.getProperty("SO_TIMEOUT");
        Integer tempConnTimeoutProperty = (Integer)msgContext.getProperty("CONNECTION_TIMEOUT");
        long timeout = msgContext.getOptions().getTimeOutInMilliSeconds();
        if (tempConnTimeoutProperty != null) {
            int connectionTimeout = tempConnTimeoutProperty;
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(connectionTimeout);
        } else if (timeout > 0L) {
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout((int)timeout);
        }
        if (tempSoTimeoutProperty != null) {
            int soTimeout = tempSoTimeoutProperty;
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(soTimeout);
            httpClient.getParams().setSoTimeout(soTimeout);
        } else if (timeout > 0L) {
            httpClient.getHttpConnectionManager().getParams().setSoTimeout((int)timeout);
            httpClient.getParams().setSoTimeout((int)timeout);
        }
    }

    protected void setTimeouts(MessageContext msgContext, HttpMethod httpMethod) {
        Integer tempSoTimeoutProperty = (Integer)msgContext.getProperty("SO_TIMEOUT");
        Integer tempConnTimeoutProperty = (Integer)msgContext.getProperty("CONNECTION_TIMEOUT");
        long timeout = msgContext.getOptions().getTimeOutInMilliSeconds();
        if (tempConnTimeoutProperty != null) {
            httpMethod.getParams().setParameter("http.connection.timeout", (Object)tempConnTimeoutProperty);
        }
        if (tempSoTimeoutProperty != null) {
            httpMethod.getParams().setSoTimeout(tempSoTimeoutProperty.intValue());
        } else if (timeout > 0L) {
            httpMethod.getParams().setSoTimeout((int)timeout);
        }
    }

    public void setFormat(OMOutputFormat format) {
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpClient getHttpClient(MessageContext msgContext) {
        ConfigurationContext configContext = msgContext.getConfigurationContext();
        HttpClient httpClient = (HttpClient)msgContext.getProperty("CACHED_HTTP_CLIENT");
        if (httpClient == null) {
            httpClient = (HttpClient)configContext.getProperty("CACHED_HTTP_CLIENT");
        }
        if (httpClient != null) {
            return httpClient;
        }
        AbstractHTTPSender abstractHTTPSender = this;
        synchronized (abstractHTTPSender) {
            httpClient = (HttpClient)msgContext.getProperty("CACHED_HTTP_CLIENT");
            if (httpClient == null) {
                httpClient = (HttpClient)configContext.getProperty("CACHED_HTTP_CLIENT");
            }
            if (httpClient != null) {
                return httpClient;
            }
            HttpConnectionManager connManager = (HttpConnectionManager)msgContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
            if (connManager == null) {
                connManager = (HttpConnectionManager)msgContext.getProperty("MUTTITHREAD_HTTP_CONNECTION_MANAGER");
            }
            if (connManager == null) {
                ConfigurationContext configurationContext = configContext;
                synchronized (configurationContext) {
                    connManager = (HttpConnectionManager)configContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
                    if (connManager == null) {
                        log.trace((Object)"Making new ConnectionManager");
                        connManager = new MultiThreadedHttpConnectionManager();
                        configContext.setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", (Object)connManager);
                    }
                }
            }
            httpClient = new HttpClient(connManager);
            httpClient.getParams().setConnectionManagerTimeout(30000L);
            this.initializeTimeouts(msgContext, httpClient);
            return httpClient;
        }
    }

    protected void executeMethod(HttpClient httpClient, MessageContext msgContext, URL url, HttpMethod method) throws IOException {
        String cookiePolicy;
        HostConfiguration config = this.getHostConfiguration(httpClient, msgContext, url);
        this.addCustomHeaders(method, msgContext);
        if (msgContext.isPropertyTrue("transport.http.acceptGzip")) {
            method.addRequestHeader("Accept-Encoding", "gzip");
        }
        if (msgContext.isPropertyTrue("transport.http.gzipRequest")) {
            method.addRequestHeader("Content-Encoding", "gzip");
        }
        if (msgContext.getProperty("HTTP_METHOD_PARAMS") != null) {
            HttpMethodParams params = (HttpMethodParams)msgContext.getProperty("HTTP_METHOD_PARAMS");
            method.setParams(params);
        }
        if ((cookiePolicy = (String)msgContext.getProperty("COOKIE_POLICY")) != null) {
            method.getParams().setCookiePolicy(cookiePolicy);
        }
        HttpState httpState = (HttpState)msgContext.getProperty("CACHED_HTTP_STATE");
        this.setTimeouts(msgContext, method);
        httpClient.executeMethod(config, method, httpState);
    }

    public void addCustomHeaders(HttpMethod method, MessageContext msgContext) {
        Map transportHeaders;
        boolean isCustomUserAgentSet = false;
        Object httpHeadersObj = msgContext.getProperty("HTTP_HEADERS");
        if (httpHeadersObj != null) {
            Object httpHeaders;
            if (httpHeadersObj instanceof List) {
                httpHeaders = (List)httpHeadersObj;
                for (int i = 0; i < httpHeaders.size(); ++i) {
                    NamedValue nv = (NamedValue)httpHeaders.get(i);
                    if (nv == null) continue;
                    Header header = new Header(nv.getName(), nv.getValue());
                    if ("User-Agent".equals(header.getName())) {
                        isCustomUserAgentSet = true;
                    }
                    method.addRequestHeader(header);
                }
            }
            if (httpHeadersObj instanceof Map) {
                httpHeaders = (Map)httpHeadersObj;
                for (Map.Entry entry : httpHeaders.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if ("User-Agent".equals(key)) {
                        isCustomUserAgentSet = true;
                    }
                    method.addRequestHeader(key, value);
                }
            }
        }
        if ((transportHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS")) != null) {
            this.removeUnwantedHeaders(msgContext);
            Set headerEntries = transportHeaders.entrySet();
            for (Map.Entry headerEntry : headerEntries) {
                if (!(headerEntry instanceof Map.Entry)) continue;
                Header[] headers = method.getRequestHeaders();
                boolean headerAdded = false;
                for (Header header : headers) {
                    if (header.getName() == null || !header.getName().equals(headerEntry.getKey())) continue;
                    headerAdded = true;
                    break;
                }
                if (headerAdded) continue;
                method.addRequestHeader(headerEntry.getKey().toString(), headerEntry.getValue().toString());
            }
        }
        if (!isCustomUserAgentSet) {
            String userAgentString = this.getUserAgent(msgContext);
            method.setRequestHeader("User-Agent", userAgentString);
        }
    }

    private void removeUnwantedHeaders(MessageContext msgContext) {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headers == null || headers.isEmpty()) {
            return;
        }
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            if (!"Connection".equalsIgnoreCase(headerName) && !"Transfer-Encoding".equalsIgnoreCase(headerName) && !"Date".equalsIgnoreCase(headerName) && !"Content-Type".equalsIgnoreCase(headerName) && !"Content-Length".equalsIgnoreCase(headerName)) continue;
            iter.remove();
        }
    }

    private String getUserAgent(MessageContext messageContext) {
        String userAgentString = "Axis2";
        boolean locked = false;
        if (messageContext.getParameter("userAgent") != null) {
            OMElement userAgentElement = messageContext.getParameter("userAgent").getParameterElement();
            userAgentString = userAgentElement.getText().trim();
            OMAttribute lockedAttribute = userAgentElement.getAttribute(new QName("locked"));
            if (lockedAttribute != null && lockedAttribute.getAttributeValue().equalsIgnoreCase("true")) {
                locked = true;
            }
        }
        if (!locked && messageContext.getProperty("userAgent") != null) {
            userAgentString = (String)messageContext.getProperty("userAgent");
        }
        return userAgentString;
    }
}

