/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import net.sf.jasperreports.engine.print.JRPrinterAWT;

public class JRPrintServiceExporter
extends JRAbstractExporter
implements Printable {
    protected JRGraphics2DExporter exporter = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected PrintRequestAttributeSet printRequestAttributeSet = null;
    protected PrintServiceAttributeSet printServiceAttributeSet = null;
    protected boolean displayPageDialog = false;
    protected boolean displayPrintDialog = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block23: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                PrintService[] services;
                Boolean printDialog;
                Boolean pageDialog;
                this.setExportContext();
                this.setInput();
                this.setPageRange();
                this.exporter = new JRGraphics2DExporter();
                this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
                this.exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, this.progressMonitor);
                this.exporter.setParameter(JRExporterParameter.OFFSET_X, this.parameters.get(JRExporterParameter.OFFSET_X));
                this.exporter.setParameter(JRExporterParameter.OFFSET_Y, this.parameters.get(JRExporterParameter.OFFSET_Y));
                this.exporter.setParameter(JRExporterParameter.CLASS_LOADER, this.classLoader);
                this.exporter.setParameter(JRExporterParameter.URL_HANDLER_FACTORY, this.urlHandlerFactory);
                this.printRequestAttributeSet = (PrintRequestAttributeSet)this.parameters.get(JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET);
                if (this.printRequestAttributeSet == null) {
                    this.printRequestAttributeSet = new HashPrintRequestAttributeSet();
                }
                this.printServiceAttributeSet = (PrintServiceAttributeSet)this.parameters.get(JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET);
                if (this.printServiceAttributeSet == null) {
                    this.printServiceAttributeSet = new HashPrintServiceAttributeSet();
                }
                if ((pageDialog = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG)) != null) {
                    this.displayPageDialog = pageDialog;
                }
                if ((printDialog = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG)) != null) {
                    this.displayPrintDialog = printDialog;
                }
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                JRPrinterAWT.initPrinterJobFields(printerJob);
                printerJob.setPrintable(this);
                PrintService selectedService = (PrintService)this.parameters.get(JRPrintServiceExporterParameter.PRINT_SERVICE);
                if (selectedService == null && (services = PrintServiceLookup.lookupPrintServices(null, this.printServiceAttributeSet)).length > 0) {
                    selectedService = services[0];
                }
                if (selectedService != null) {
                    try {
                        printerJob.setPrintService(selectedService);
                        if (!this.printRequestAttributeSet.containsKey(MediaPrintableArea.class)) {
                            int printableHeight;
                            int printableWidth;
                            switch (this.jasperPrint.getOrientation()) {
                                case 2: {
                                    printableWidth = this.jasperPrint.getPageHeight();
                                    printableHeight = this.jasperPrint.getPageWidth();
                                    break;
                                }
                                default: {
                                    printableWidth = this.jasperPrint.getPageWidth();
                                    printableHeight = this.jasperPrint.getPageHeight();
                                }
                            }
                            this.printRequestAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, (float)printableWidth / 72.0f, (float)printableHeight / 72.0f, 25400));
                        }
                        if (!this.printRequestAttributeSet.containsKey(OrientationRequested.class)) {
                            OrientationRequested orientation;
                            switch (this.jasperPrint.getOrientation()) {
                                case 2: {
                                    orientation = OrientationRequested.LANDSCAPE;
                                    break;
                                }
                                default: {
                                    orientation = OrientationRequested.PORTRAIT;
                                }
                            }
                            this.printRequestAttributeSet.add(orientation);
                        }
                        if (this.displayPageDialog) {
                            printerJob.pageDialog(this.printRequestAttributeSet);
                        }
                        if (this.displayPrintDialog) {
                            if (printerJob.printDialog(this.printRequestAttributeSet)) {
                                printerJob.print(this.printRequestAttributeSet);
                            }
                        } else {
                            printerJob.print(this.printRequestAttributeSet);
                        }
                        break block23;
                    }
                    catch (PrinterException e) {
                        throw new JRException(e);
                    }
                }
                throw new JRException("No suitable print service found.");
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (Thread.currentThread().isInterrupted()) {
            throw new PrinterException("Current thread interrupted.");
        }
        if (pageIndex < 0 || pageIndex >= this.jasperPrint.getPages().size()) {
            return 1;
        }
        this.exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, graphics);
        this.exporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(pageIndex));
        try {
            this.exporter.exportReport();
        }
        catch (JRException e) {
            throw new PrinterException(e.getMessage());
        }
        return 0;
    }
}

