/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.presentation;

import coldfusion.document.PowerPointReaderException;
import coldfusion.runtime.ApplicationException;
import coldfusion.vfs.VFSFileFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;

public class PowerPointReader {
    private static String separator = File.separator;
    private static String pptfilename = null;
    private File outputdir = null;
    private List<HSLFSlide> slides = null;
    private String basename;
    Dimension pgsize;

    public PowerPointReader(String filename) {
        this.slides = this.getPPTSlides(filename);
        pptfilename = filename;
        this.basename = this.getBaseName(pptfilename);
    }

    public String exportSlideToImage(String filename, HSLFSlide slide, int height, int width) {
        File imgoutputdir;
        FileOutputStream out = null;
        try {
            BufferedImage img = new BufferedImage(width, height, 1);
            Graphics2D graphics = img.createGraphics();
            graphics.setPaint(Color.white);
            graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, width, height));
            try {
                slide.draw(graphics);
            }
            catch (Exception exception) {
                // empty catch block
            }
            imgoutputdir = this.outputdir != null ? VFSFileFactory.getFileObject((File)this.outputdir, (String)filename) : VFSFileFactory.getFileObject((String)filename);
            out = (FileOutputStream)VFSFileFactory.getOutputStream((File)imgoutputdir);
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            throw new PowerPointReaderException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        if (imgoutputdir != null) {
            return imgoutputdir.getAbsolutePath();
        }
        return "";
    }

    public String[] exportSlides() {
        String[] filenames = new String[this.slides.size()];
        for (int i = 0; i < this.slides.size(); ++i) {
            filenames[i] = this.exportSlides(i + 1);
        }
        return filenames;
    }

    public String[] exportSlides(int startindex, int endindex) {
        String[] filenames = new String[endindex - startindex + 1];
        int index = 0;
        for (int i = startindex; i <= endindex; ++i) {
            filenames[index++] = this.exportSlides(i);
        }
        return filenames;
    }

    public String exportSlides(int slideno) {
        if (slideno <= 0 || slideno > this.slides.size()) {
            throw new InvalidSlideNumberException(slideno);
        }
        String imgfilename = this.basename + "_slide_" + slideno + ".png";
        return this.exportSlideToImage(imgfilename, this.slides.get(slideno - 1), this.pgsize.height, this.pgsize.width);
    }

    public String[] exportSlides(ArrayList<Integer> range) {
        String[] filenames = null;
        filenames = new String[range.size()];
        for (int i = 0; i < range.size(); ++i) {
            int slideno = range.get(i);
            if (slideno > this.slides.size()) {
                throw new InvalidSlideNumberException(slideno);
            }
            filenames[i] = this.exportSlides(slideno);
        }
        return filenames;
    }

    public void setupOutputDir(File dir) {
        this.outputdir = dir;
    }

    private String getBaseName(String filename) {
        String name = new File(filename).getName();
        int dot = name.lastIndexOf(".");
        return name.substring(0, dot);
    }

    private List<HSLFSlide> getPPTSlides(String filename) {
        FileInputStream is = null;
        List slides = null;
        try {
            File file = VFSFileFactory.getFileObject((String)filename);
            is = (FileInputStream)VFSFileFactory.getInputStream((File)file);
            HSLFSlideShow ppt = new HSLFSlideShow((InputStream)is);
            slides = ppt.getSlides();
            this.pgsize = ppt.getPageSize();
        }
        catch (IOException e) {
            throw new PowerPointReaderException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return slides;
    }

    public class InvalidSlideNumberException
    extends ApplicationException {
        public int slidenumber;

        public InvalidSlideNumberException(int slidenumber) {
            this.slidenumber = slidenumber;
        }
    }
}

