/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography.algorithms;

import com.microsoft.azure.keyvault.cryptography.ICryptoTransform;
import com.microsoft.azure.keyvault.cryptography.algorithms.AesKw;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import javax.crypto.NoSuchPaddingException;

public final class AesKw256
extends AesKw {
    public static final String ALGORITHM_NAME = "A256KW";
    static final int KEY_SIZE_IN_BYTES = 32;

    public AesKw256() {
        super(ALGORITHM_NAME);
    }

    @Override
    public ICryptoTransform CreateEncryptor(byte[] key, byte[] iv, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (key.length < 32) {
            throw new IllegalArgumentException("key must be at least 256 bits long");
        }
        return super.CreateEncryptor(Arrays.copyOfRange(key, 0, 32), iv, provider);
    }

    @Override
    public ICryptoTransform CreateDecryptor(byte[] key, byte[] iv, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (key.length < 32) {
            throw new IllegalArgumentException("key must be at least 256 bits long");
        }
        return super.CreateDecryptor(Arrays.copyOfRange(key, 0, 32), iv, provider);
    }
}

