/*
 * Decompiled with CFR 0.152.
 */
package ice.setup.net;

import ice.net.Authentication;
import ice.net.AuthenticationEvent;
import ice.net.AuthenticationListener;
import ice.net.AuthenticationManager;
import ice.net.Cache;
import ice.net.CacheManager;
import ice.net.CookieManager;
import ice.net.HttpURLConnection;
import ice.net.MemoryCache;
import ice.net.proxy.ProxyManager;
import ice.setup.net.AuthDialog;
import ice.util.io.DataStorage;
import ice.util.net.URLStreamHandlerFactory;

public class SetupHTTP {
    public static void init(DataStorage storage) {
        URLStreamHandlerFactory.addStreamHandler((String)"http", (String)"ice.net.HttpURLStreamHandler");
        if (null == HttpURLConnection.getCacheManager()) {
            CacheManager cm = new CacheManager();
            HttpURLConnection.setCacheManager((CacheManager)cm);
            MemoryCache cA = new MemoryCache();
            cA.setMaxSize(500000L);
            cm.addCache((Cache)cA);
            cm.useCache(true);
        }
        if (null == HttpURLConnection.getGlobalCookieManager()) {
            CookieManager cookies = new CookieManager();
            HttpURLConnection.setGlobalCookieManager((CookieManager)cookies);
        }
        if (null == HttpURLConnection.getAuthenticationManager()) {
            AuthenticationManager a = new AuthenticationManager();
            a.addAuthenticationListener(new AuthenticationListener(){

                public void onAuthenticationEvent(AuthenticationEvent e) {
                    SetupHTTP.onAuthenticationEventImpl(e);
                }
            });
            HttpURLConnection.setAuthenticationManager((AuthenticationManager)a);
        }
        if (null == HttpURLConnection.getProxyManager()) {
            ProxyManager pManager = new ProxyManager();
            pManager.setProxyUse(true);
            HttpURLConnection.setProxyManager((ProxyManager)pManager);
        }
    }

    static void onAuthenticationEventImpl(AuthenticationEvent e) {
        Authentication auth = e.getAuthentication();
        AuthDialog dialog = new AuthDialog(auth);
        dialog.run();
    }
}

