/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.MultiLabel;
import ice.storm.StormBase;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MouseEvent;

public class Tooltip
extends Window
implements EventListener {
    private StormBase storm;
    private MultiLabel myLabel;
    private Node currentTooltipNode;

    public Tooltip(Frame f, StormBase storm) {
        super(f);
        this.storm = storm;
        this.setSize(200, 30);
        this.setBackground(new Color(255, 255, 225));
        this.enableEvents(0L);
        this.myLabel = new MultiLabel();
        this.myLabel.setFont(new Font("SansSerif", 0, 12));
        this.add(this.myLabel);
    }

    public void dispose() {
        this.currentTooltipNode = null;
        super.dispose();
    }

    public void handleEvent(Event e) {
        MouseEvent de = (MouseEvent)e;
        String eventType = de.getType();
        if (eventType.equals("mouseover") || eventType.equals("mouseout")) {
            Node n;
            String title = null;
            for (n = (Node)((Object)de.getTarget()); n != null; n = n.getParentNode()) {
                if (!(n instanceof Element)) continue;
                Element elm = (Element)n;
                title = elm.getAttribute("title");
                if (title == null) {
                    title = elm.getAttribute("alt");
                }
                if (title != null && (title = title.trim()).length() != 0) break;
            }
            if (this.currentTooltipNode != n) {
                this.currentTooltipNode = n;
                if (n != null) {
                    this.storm.runOnEventThreadLater((Runnable)new Shower(this, n, title, de.getScreenX(), de.getScreenY()), 500L);
                } else {
                    this.setVisible(false);
                }
            }
        }
    }

    static class Shower
    implements Runnable {
        Tooltip master;
        Node tooltipNode;
        String title;
        int eventX;
        int eventY;

        Shower(Tooltip master, Node tooltipNode, String title, int eventX, int eventY) {
            this.master = master;
            this.tooltipNode = tooltipNode;
            this.title = title;
            this.eventX = eventX;
            this.eventY = eventY;
        }

        public void run() {
            if (this.master.currentTooltipNode == this.tooltipNode) {
                this.master.myLabel.setText(this.title, true);
                this.master.myLabel.invalidate();
                this.master.invalidate();
                this.master.pack();
                this.master.setLocation(this.eventX + 5, this.eventY + 5);
                this.master.setVisible(true);
            }
        }
    }
}

