/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.storm.PilotInfo;
import ice.storm.ScripterInfo;
import ice.storm.StormBase;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class ListDialog
extends Dialog
implements WindowListener,
ItemListener,
ActionListener {
    private List names;
    private TextArea info;
    private Button done;
    private Hashtable pilotInfos = new Hashtable();
    private Hashtable scripterInfos = new Hashtable();

    public ListDialog(Frame frame, StormBase base) {
        super(frame, "Pilots and Scripters", true);
        Object p;
        this.addWindowListener(this);
        this.names = new List(10);
        this.names.addItemListener(this);
        this.names.setForeground(Color.white);
        this.names.setBackground(Color.black);
        this.info = new TextArea(12, 50);
        this.info.setEditable(false);
        this.info.setFont(new Font("Monospaced", 0, 12));
        Enumeration pi = base.getPilotFactory().getAllPilotInfos();
        Enumeration si = base.getScripterFactory().getAllScripterInfos();
        while (pi.hasMoreElements()) {
            p = (PilotInfo)pi.nextElement();
            if (!p.isLoaded()) continue;
            this.names.add(p.getName());
            this.pilotInfos.put(p.getName(), p);
        }
        while (si.hasMoreElements()) {
            p = (ScripterInfo)si.nextElement();
            if (!p.isLoaded()) continue;
            this.names.add(p.getName());
            this.scripterInfos.put(p.getName(), p);
        }
        this.done = new Button("Done");
        this.done.addActionListener(this);
        p = new Panel();
        ((Container)p).setLayout(new BorderLayout());
        ((Container)p).add((Component)this.names, "Center");
        ((Container)p).add((Component)this.done, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)p, "West");
        this.add((Component)this.info, "Center");
        this.pack();
        Point pp = frame.getLocation();
        this.setLocation(pp.x + 10, pp.y + 10);
    }

    public void itemStateChanged(ItemEvent e) {
        block4: {
            ScripterInfo s;
            block3: {
                String str = this.names.getSelectedItem();
                this.info.setText("");
                if (str == null) {
                    return;
                }
                PilotInfo p = (PilotInfo)this.pilotInfos.get(str);
                s = (ScripterInfo)this.scripterInfos.get(str);
                if (p == null) break block3;
                this.info.append("Pilot:       " + p.getName() + "\n");
                this.info.append("Version:     " + p.getVersion() + "\n");
                this.info.append("Author:      " + p.getAuthor() + "\n");
                this.info.append("Description: " + p.getDescription() + "\n");
                this.info.append("Supported content types: \n");
                String[] ss = p.getSupportedContentTypes();
                for (int i = 0; i < ss.length; ++i) {
                    this.info.append("          " + ss[i] + "\n");
                }
                break block4;
            }
            if (s == null) break block4;
            this.info.append("Scripter:    " + s.getName() + "\n");
            this.info.append("Version:     " + s.getVersion() + "\n");
            this.info.append("Author:      " + s.getAuthor() + "\n");
            this.info.append("Description: " + s.getDescription() + "\n");
            this.info.append("Supported aliases: \n");
            String[] ss = s.getAliases();
            for (int i = 0; i < ss.length; ++i) {
                this.info.append("          " + ss[i] + "\n");
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }
}

