/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.debug.Debug;
import ice.storm.ScripterCallback;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.ViewportCallback;
import ice.util.Defs;

public abstract class CallbackImplBase
implements ViewportCallback,
ScripterCallback {
    boolean reportScriptExceptions;
    StormBase base;

    public void init(StormBase base) {
        this.base = base;
    }

    public void processViewportMessage(Viewport view, String messageName, Object addArg, Object value) {
    }

    public boolean allowScriptClose(Viewport vp, boolean openedByScript) {
        if (!openedByScript) {
            return this.showConfirmation(vp, "Script Request Conformation", "Close the window as requested by script code?");
        }
        return true;
    }

    public long getMaxScriptRunningTime() {
        return Defs.sysPropertyInt((String)"ice.scripters.timelimit", (int)5000);
    }

    public boolean interruptLongRunningScript(Viewport vp, long scriptRunningTime) {
        return this.showConfirmation(vp, "Script Problem", "Long running script is detected (run time = " + scriptRunningTime + " ms). Terminate it?");
    }

    public void reportScriptError(Viewport vp, boolean justWarning, String errorMessage, String url, int lineNumber, String lineSource, int lineOffset) {
        String title = justWarning ? "SCRIPT WARNING" : "SCRIPT ERROR";
        StringBuffer sb = new StringBuffer();
        sb.append(url);
        sb.append(':');
        sb.append(lineNumber + 1);
        sb.append(':');
        sb.append(lineOffset);
        sb.append(": ");
        sb.append(errorMessage);
        if (lineSource != null) {
            sb.append('\n');
            sb.append(lineSource);
            sb.append('\n');
            for (int i = 0; i < lineOffset - 1; ++i) {
                sb.append('.');
            }
            sb.append('^');
        }
        String message = sb.toString();
        if (Debug.trace) {
            Debug.trace((String)(title + ": " + message));
        }
        if (this.reportScriptExceptions) {
            this.showMessage(vp, title, message);
        }
    }

    public void scriptAlert(Viewport vp, String msg) {
        this.showMessage(vp, "Script Alert", msg);
    }

    public boolean scriptConfirm(Viewport vp, String msg) {
        return this.showConfirmation(vp, "Script Confirm", msg);
    }

    public String scriptPrompt(Viewport vp, String msg, String defVal) {
        return this.showPrompt(vp, "Script Prompt", msg, defVal);
    }

    public void scriptPrint(Viewport view) {
        if (Debug.trace) {
            Debug.trace((String)"window.print is called from script");
        }
    }

    abstract void showMessage(Viewport var1, String var2, String var3);

    abstract boolean showConfirmation(Viewport var1, String var2, String var3);

    abstract String showPrompt(Viewport var1, String var2, String var3, String var4);
}

