/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.azure.servicebus;

import coldfusion.cloud.azure.servicebus.ServiceBusAPIException;
import coldfusion.cloud.azure.servicebus.ServiceBusClient;
import coldfusion.cloud.azure.servicebus.ServiceBusQueue;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Struct;
import com.microsoft.azure.servicebus.management.QueueDescription;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class ServiceBusQueueImpl
implements ServiceBusQueue,
NamedInvokable {
    QueueDescription queueDescription;
    String path;
    ServiceBusClient serviceBusClient;
    private static InvokeNamedMethodInvocationMap<ServiceBusQueueImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public ServiceBusQueueImpl(ServiceBusClient client, QueueDescription description) {
        this.queueDescription = description;
        this.serviceBusClient = client;
        this.path = description.getPath();
    }

    @Override
    public Struct sendMessage(Map message) {
        return this.serviceBusClient.sendMessage(this.path, message, "queue");
    }

    public String getPath() {
        return this.queueDescription.getPath();
    }

    @Override
    public Struct receiveMessage(Map receiveMessageOptions) {
        return this.serviceBusClient.receiveMessage(this.path, receiveMessageOptions);
    }

    @Override
    public ServiceBusQueue update(Map description) throws ServiceBusAPIException {
        return this.serviceBusClient.updateQueue(this.path, description);
    }

    @Override
    public Struct abandonMessage(Map message) throws ServiceBusAPIException {
        return this.serviceBusClient.abandonMessage(this.path, message);
    }

    @Override
    public Struct deferMessage(Map message) throws ServiceBusAPIException {
        return this.serviceBusClient.deferMessage(this.path, message);
    }

    @Override
    public Struct deadLetterMessage(Map message) throws ServiceBusAPIException {
        return this.serviceBusClient.deadLetterMessage(this.path, message);
    }

    @Override
    public Struct completeMessage(Map message) throws ServiceBusAPIException {
        return this.serviceBusClient.completeMessage(this.path, message);
    }

    @Override
    public Struct setPrefetchCount(int prefetchCount) throws ServiceBusAPIException {
        return this.serviceBusClient.setPrefetchCount(this.path, prefetchCount);
    }

    @Override
    public Struct getPrefetchCount() throws ServiceBusAPIException {
        return this.serviceBusClient.getPrefetchCount(this.path);
    }

    @Override
    public Struct scheduleMessage(Map message) throws ServiceBusAPIException {
        return this.serviceBusClient.scheduleMessage(this.path, message, "queue");
    }

    @Override
    public Struct sendMessageBatch(List<Map> messages) throws ServiceBusAPIException {
        return this.serviceBusClient.sendMessageBatch(this.path, messages, "queue");
    }

    @Override
    public Struct cancelScheduledMessage(long sequenceNumber) throws ServiceBusAPIException {
        return this.serviceBusClient.cancelScheduledMessage(this.path, sequenceNumber, "queue");
    }

    @Override
    public Struct receiveDeferredMessage(Map receiveDeferredMessageOptions) throws ServiceBusAPIException {
        return this.serviceBusClient.receiveDeferredMessage(this.path, receiveDeferredMessageOptions);
    }

    @Override
    public Struct renewLockToken(String lockToken) throws ServiceBusAPIException {
        return this.serviceBusClient.renewLockToken(this.path, lockToken);
    }

    @Override
    public Struct peekMessage(Map peekMessageOptions) throws ServiceBusAPIException {
        return this.serviceBusClient.peekMessage(this.path, peekMessageOptions, "queue");
    }

    @Override
    public Struct getRuntimeInfo() throws ServiceBusAPIException {
        return this.serviceBusClient.getQueueRuntimeInfo(this.path);
    }

    @Override
    public Struct getDescription() throws ServiceBusAPIException {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)this.queueDescription);
    }

    @Override
    public String generateSasToken(Map sasRule) throws ServiceBusAPIException {
        return this.serviceBusClient.generateSasToken(this.path, "queue", sasRule);
    }

    @Override
    public String getDeadletterQueuePath() {
        return this.serviceBusClient.getDeadletterQueuePath(this.path);
    }

    @Override
    public void registerMessageHandler(Map messageHandler) throws ServiceBusAPIException {
        this.serviceBusClient.registerMessageHandler(this.path, messageHandler);
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        return NamedMethodInvoker2.invoke((Object)this, args);
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.sendMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getPath", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getPath();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getPath", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"receiveMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"receiveMessageOptions"}, args);
                    return obj.receiveMessage(Cast._Map((Object)argColl.get((Object)"receiveMessageOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("receiveMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"update", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"description"}, args);
                    return obj.update(Cast._Map((Object)argColl.get((Object)"description")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("update", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"abandonMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.abandonMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("abandonMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deferMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.deferMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deferMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deadLetterMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.deadLetterMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deadLetterMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"completeMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.completeMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("completeMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setPrefetchCount", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"prefetchCount"}, args);
                    return obj.setPrefetchCount(Cast._int((Object)argColl.get((Object)"prefetchCount"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setPrefetchCount", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getPrefetchCount", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getPrefetchCount();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getPrefetchCount", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"scheduleMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.scheduleMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("scheduleMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessageBatch", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"messages"}, args);
                    return obj.sendMessageBatch(Cast._List((Object)argColl.get((Object)"messages")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessageBatch", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"cancelScheduledMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"sequenceNumber"}, args);
                    return obj.cancelScheduledMessage(Cast._long((Object)argColl.get((Object)"sequenceNumber"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("cancelScheduledMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"receiveDeferredMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"receiveDeferredMessageOptions"}, args);
                    return obj.receiveDeferredMessage(Cast._Map((Object)argColl.get((Object)"receiveDeferredMessageOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("receiveDeferredMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"renewLockToken", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"lockToken"}, args);
                    return obj.renewLockToken(Cast._String((Object)argColl.get((Object)"lockToken")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("renewLockToken", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"peekMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"peekMessageOptions"}, args);
                    return obj.peekMessage(Cast._Map((Object)argColl.get((Object)"peekMessageOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("peekMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getRuntimeInfo", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getRuntimeInfo();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getRuntimeInfo", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getDescription", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getDescription();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getDescription", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"generateSasToken", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"sasRule"}, args);
                    return obj.generateSasToken(Cast._Map((Object)argColl.get((Object)"sasRule")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("generateSasToken", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getDeadletterQueuePath", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getDeadletterQueuePath();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getDeadletterQueuePath", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"registerMessageHandler", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"messageHandler"}, args);
                    obj.registerMessageHandler(Cast._Map((Object)argColl.get((Object)"messageHandler")));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("registerMessageHandler", obj);
        });
    }
}

