/*
 * Decompiled with CFR 0.152.
 */
package macromedia.resource.jdbcdb2.spi;

import java.io.PrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;
import macromedia.jdbcspydb2.SpyConfig;

public class JCALogger {
    private static String footprint = "$Revision: #1 $";
    private static final String LOG_PREFIX = "JCA Log> ";
    private PrintWriter logWriter;
    private boolean logWriterOwner;
    String spyAttributes;

    public JCALogger() {
        this.logWriter = null;
    }

    public JCALogger(PrintWriter printWriter) {
        this.setLogWriter(printWriter);
    }

    public JCALogger(String string) {
        this.setLogWriter(string);
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.cleanup();
        this.logWriter = printWriter;
        this.logWriterOwner = false;
    }

    public void setLogWriter(String string) {
        if (this.logWriter == null && string != null && string.length() > 0) {
            SpyConfig spyConfig = new SpyConfig();
            spyConfig.a(this.makeProperties(string));
            this.logWriter = spyConfig.a();
            this.logWriterOwner = true;
        }
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setSpyAttributes(String string) {
        this.spyAttributes = string;
    }

    public void printEnter(String string) {
        this.logWriter.println();
        this.println(string);
        this.logWriter.flush();
    }

    public void printExit(String string) {
        this.println(string + " returned");
        this.logWriter.println();
        this.logWriter.flush();
    }

    public void printExit(String string, Object object) {
        this.println(string + " returned (" + object + ")");
        this.logWriter.println();
        this.logWriter.flush();
    }

    public void print(String string) {
        this.logWriter.print(LOG_PREFIX + string);
        this.logWriter.flush();
    }

    public void println(String string) {
        this.logWriter.println(LOG_PREFIX + string);
        this.logWriter.flush();
    }

    public void cleanup() {
        if (this.logWriter != null) {
            this.logWriter.flush();
            if (this.logWriterOwner) {
                this.logWriter.close();
            }
            this.logWriter = null;
        }
    }

    private final Properties makeProperties(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf(61);
            if (n2 == -1) continue;
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            properties.put(string3, string4);
        }
        return properties;
    }
}

