/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.x509;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Collection;
import macromedia.db2util.externals.org.bouncycastle.util.Selector;
import macromedia.db2util.externals.org.bouncycastle.util.Store;
import macromedia.db2util.externals.org.bouncycastle.x509.NoSuchStoreException;
import macromedia.db2util.externals.org.bouncycastle.x509.X509StoreSpi;
import macromedia.db2util.externals.org.bouncycastle.x509.X509Util;
import macromedia.db2util.externals.org.bouncycastle.x509.dda;

public class X509Store
implements Store {
    private Provider _provider;
    private X509StoreSpi _spi;

    public static X509Store getInstance(String string, dda dda10) throws NoSuchStoreException {
        try {
            X509Util.Implementation implementation = X509Util.getImplementation("X509Store", string);
            return X509Store.createStore(implementation, dda10);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchStoreException(noSuchAlgorithmException.getMessage());
        }
    }

    public static X509Store getInstance(String string, dda dda10, String string2) throws NoSuchStoreException, NoSuchProviderException {
        return X509Store.getInstance(string, dda10, X509Util.getProvider(string2));
    }

    public static X509Store getInstance(String string, dda dda10, Provider provider) throws NoSuchStoreException {
        try {
            X509Util.Implementation implementation = X509Util.getImplementation("X509Store", string, provider);
            return X509Store.createStore(implementation, dda10);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchStoreException(noSuchAlgorithmException.getMessage());
        }
    }

    private static X509Store createStore(X509Util.Implementation implementation, dda dda10) {
        X509StoreSpi x509StoreSpi = (X509StoreSpi)implementation.getEngine();
        x509StoreSpi.engineInit(dda10);
        return new X509Store(implementation.getProvider(), x509StoreSpi);
    }

    private X509Store(Provider provider, X509StoreSpi x509StoreSpi) {
        this._provider = provider;
        this._spi = x509StoreSpi;
    }

    public Provider getProvider() {
        return this._provider;
    }

    public Collection getMatches(Selector selector) {
        return this._spi.engineGetMatches(selector);
    }
}

