/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.math.raw;

public class Interleave {
    private static final long M32 = 0x55555555L;
    private static final long M64 = 0x5555555555555555L;
    private static final long M64R = -6148914691236517206L;

    public static int expand8to16(int n2) {
        int n3 = n2 &= 0xFF;
        int n4 = n2 = (n3 | n3 << 4) & 0xF0F;
        int n5 = n2 = (n4 | n4 << 2) & 0x3333;
        n2 = (n5 | n5 << 1) & 0x5555;
        return n2;
    }

    public static int expand16to32(int n2) {
        int n3 = n2 &= 0xFFFF;
        int n4 = n2 = (n3 | n3 << 8) & 0xFF00FF;
        int n5 = n2 = (n4 | n4 << 4) & 0xF0F0F0F;
        int n6 = n2 = (n5 | n5 << 2) & 0x33333333;
        n2 = (n6 | n6 << 1) & 0x55555555;
        return n2;
    }

    public static long expand32to64(int n2) {
        int n3;
        int n4 = n2;
        int n5 = n3 = (n4 ^ n4 >>> 8) & 0xFF00;
        int n6 = n2 ^= n5 ^ n5 << 8;
        int n7 = n3 = (n6 ^ n6 >>> 4) & 0xF000F0;
        int n8 = n2 ^= n7 ^ n7 << 4;
        int n9 = n3 = (n8 ^ n8 >>> 2) & 0xC0C0C0C;
        int n10 = n2 ^= n9 ^ n9 << 2;
        int n11 = n3 = (n10 ^ n10 >>> 1) & 0x22222222;
        return ((long)((n2 ^= n11 ^ n11 << 1) >>> 1) & 0x55555555L) << 32 | (long)n2 & 0x55555555L;
    }

    public static void expand64To128(long l2, long[] lArray, int n2) {
        long l3;
        long l4 = l2;
        long l5 = l3 = (l4 ^ l4 >>> 16) & 0xFFFF0000L;
        long l6 = l2 ^= l5 ^ l5 << 16;
        long l7 = l3 = (l6 ^ l6 >>> 8) & 0xFF000000FF00L;
        long l8 = l2 ^= l7 ^ l7 << 8;
        long l9 = l3 = (l8 ^ l8 >>> 4) & 0xF000F000F000F0L;
        long l10 = l2 ^= l9 ^ l9 << 4;
        long l11 = l3 = (l10 ^ l10 >>> 2) & 0xC0C0C0C0C0C0C0CL;
        long l12 = l2 ^= l11 ^ l11 << 2;
        long l13 = l3 = (l12 ^ l12 >>> 1) & 0x2222222222222222L;
        lArray[n2] = (l2 ^= l13 ^ l13 << 1) & 0x5555555555555555L;
        lArray[n2 + 1] = l2 >>> 1 & 0x5555555555555555L;
    }

    public static void expand64To128Rev(long l2, long[] lArray, int n2) {
        long l3;
        long l4 = l2;
        long l5 = l3 = (l4 ^ l4 >>> 16) & 0xFFFF0000L;
        long l6 = l2 ^= l5 ^ l5 << 16;
        long l7 = l3 = (l6 ^ l6 >>> 8) & 0xFF000000FF00L;
        long l8 = l2 ^= l7 ^ l7 << 8;
        long l9 = l3 = (l8 ^ l8 >>> 4) & 0xF000F000F000F0L;
        long l10 = l2 ^= l9 ^ l9 << 4;
        long l11 = l3 = (l10 ^ l10 >>> 2) & 0xC0C0C0C0C0C0C0CL;
        long l12 = l2 ^= l11 ^ l11 << 2;
        long l13 = l3 = (l12 ^ l12 >>> 1) & 0x2222222222222222L;
        lArray[n2] = (l2 ^= l13 ^ l13 << 1) & 0xAAAAAAAAAAAAAAAAL;
        lArray[n2 + 1] = l2 << 1 & 0xAAAAAAAAAAAAAAAAL;
    }

    public static int shuffle(int n2) {
        int n3;
        int n4 = n2;
        int n5 = n3 = (n4 ^ n4 >>> 8) & 0xFF00;
        int n6 = n2 ^= n5 ^ n5 << 8;
        int n7 = n3 = (n6 ^ n6 >>> 4) & 0xF000F0;
        int n8 = n2 ^= n7 ^ n7 << 4;
        int n9 = n3 = (n8 ^ n8 >>> 2) & 0xC0C0C0C;
        int n10 = n2 ^= n9 ^ n9 << 2;
        int n11 = n3 = (n10 ^ n10 >>> 1) & 0x22222222;
        return n2 ^= n11 ^ n11 << 1;
    }

    public static long shuffle(long l2) {
        long l3;
        long l4 = l2;
        long l5 = l3 = (l4 ^ l4 >>> 16) & 0xFFFF0000L;
        long l6 = l2 ^= l5 ^ l5 << 16;
        long l7 = l3 = (l6 ^ l6 >>> 8) & 0xFF000000FF00L;
        long l8 = l2 ^= l7 ^ l7 << 8;
        long l9 = l3 = (l8 ^ l8 >>> 4) & 0xF000F000F000F0L;
        long l10 = l2 ^= l9 ^ l9 << 4;
        long l11 = l3 = (l10 ^ l10 >>> 2) & 0xC0C0C0C0C0C0C0CL;
        long l12 = l2 ^= l11 ^ l11 << 2;
        long l13 = l3 = (l12 ^ l12 >>> 1) & 0x2222222222222222L;
        return l2 ^= l13 ^ l13 << 1;
    }

    public static int shuffle2(int n2) {
        int n3;
        int n4 = n2;
        int n5 = n3 = (n4 ^ n4 >>> 7) & 0xAA00AA;
        int n6 = n2 ^= n5 ^ n5 << 7;
        int n7 = n3 = (n6 ^ n6 >>> 14) & 0xCCCC;
        int n8 = n2 ^= n7 ^ n7 << 14;
        int n9 = n3 = (n8 ^ n8 >>> 4) & 0xF000F0;
        int n10 = n2 ^= n9 ^ n9 << 4;
        int n11 = n3 = (n10 ^ n10 >>> 8) & 0xFF00;
        return n2 ^= n11 ^ n11 << 8;
    }

    public static int unshuffle(int n2) {
        int n3;
        int n4 = n2;
        int n5 = n3 = (n4 ^ n4 >>> 1) & 0x22222222;
        int n6 = n2 ^= n5 ^ n5 << 1;
        int n7 = n3 = (n6 ^ n6 >>> 2) & 0xC0C0C0C;
        int n8 = n2 ^= n7 ^ n7 << 2;
        int n9 = n3 = (n8 ^ n8 >>> 4) & 0xF000F0;
        int n10 = n2 ^= n9 ^ n9 << 4;
        int n11 = n3 = (n10 ^ n10 >>> 8) & 0xFF00;
        return n2 ^= n11 ^ n11 << 8;
    }

    public static long unshuffle(long l2) {
        long l3;
        long l4 = l2;
        long l5 = l3 = (l4 ^ l4 >>> 1) & 0x2222222222222222L;
        long l6 = l2 ^= l5 ^ l5 << 1;
        long l7 = l3 = (l6 ^ l6 >>> 2) & 0xC0C0C0C0C0C0C0CL;
        long l8 = l2 ^= l7 ^ l7 << 2;
        long l9 = l3 = (l8 ^ l8 >>> 4) & 0xF000F000F000F0L;
        long l10 = l2 ^= l9 ^ l9 << 4;
        long l11 = l3 = (l10 ^ l10 >>> 8) & 0xFF000000FF00L;
        long l12 = l2 ^= l11 ^ l11 << 8;
        long l13 = l3 = (l12 ^ l12 >>> 16) & 0xFFFF0000L;
        return l2 ^= l13 ^ l13 << 16;
    }

    public static int unshuffle2(int n2) {
        int n3;
        int n4 = n2;
        int n5 = n3 = (n4 ^ n4 >>> 8) & 0xFF00;
        int n6 = n2 ^= n5 ^ n5 << 8;
        int n7 = n3 = (n6 ^ n6 >>> 4) & 0xF000F0;
        int n8 = n2 ^= n7 ^ n7 << 4;
        int n9 = n3 = (n8 ^ n8 >>> 14) & 0xCCCC;
        int n10 = n2 ^= n9 ^ n9 << 14;
        int n11 = n3 = (n10 ^ n10 >>> 7) & 0xAA00AA;
        return n2 ^= n11 ^ n11 << 7;
    }
}

