/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.math.ec;

import java.math.BigInteger;
import macromedia.db2util.externals.org.bouncycastle.math.ec.AbstractECMultiplier;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.db2util.externals.org.bouncycastle.math.ec.LongArray;
import macromedia.db2util.externals.org.bouncycastle.math.ec.WNafPreCompInfo;
import macromedia.db2util.externals.org.bouncycastle.math.ec.WNafUtil;

public class WNafL2RMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECPoint[] eCPointArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = Math.max(2, Math.min(16, this.getWindowSize(bigInteger.bitLength())));
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n6, true);
        ECPoint[] eCPointArray2 = wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray3 = wNafPreCompInfo.getPreCompNeg();
        int[] nArray = WNafUtil.generateCompactWindowNaf(n6, bigInteger);
        ECPoint eCPoint2 = eCPoint.getCurve().getInfinity();
        int n7 = nArray.length;
        if (n7 > 1) {
            n5 = nArray[--n7];
            n4 = n5 >> 16;
            n3 = n5 & 0xFFFF;
            n2 = Math.abs(n4);
            ECPoint[] eCPointArray4 = eCPointArray = n4 < 0 ? eCPointArray3 : eCPointArray2;
            if (n2 << 2 < 1 << n6) {
                byte by = LongArray.bitLengths[n2];
                int n8 = n6 - by;
                int n9 = n2 ^ 1 << by - 1;
                int n10 = (1 << n6 - 1) - 1;
                int n11 = (n9 << n8) + 1;
                eCPoint2 = eCPointArray[n10 >>> 1].add(eCPointArray[n11 >>> 1]);
                n3 -= n8;
            } else {
                eCPoint2 = eCPointArray[n2 >>> 1];
            }
            eCPoint2 = eCPoint2.timesPow2(n3);
        }
        while (n7 > 0) {
            n5 = nArray[--n7];
            n4 = n5 >> 16;
            n3 = n5 & 0xFFFF;
            n2 = Math.abs(n4);
            eCPointArray = n4 < 0 ? eCPointArray3 : eCPointArray2;
            ECPoint eCPoint3 = eCPointArray[n2 >>> 1];
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
            eCPoint2 = eCPoint2.timesPow2(n3);
        }
        return eCPoint2;
    }

    protected int getWindowSize(int n2) {
        return WNafUtil.getWindowSize(n2);
    }
}

