/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.jcajce.provider.digest;

import macromedia.db2util.externals.org.bouncycastle.asn1.iso.ISOIECObjectIdentifiers;
import macromedia.db2util.externals.org.bouncycastle.crypto.CipherKeyGenerator;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.WhirlpoolDigest;
import macromedia.db2util.externals.org.bouncycastle.crypto.macs.HMac;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class Whirlpool {
    private Whirlpool() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new WhirlpoolDigest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new WhirlpoolDigest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACWHIRLPOOL", 512, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.WHIRLPOOL", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("MessageDigest", ISOIECObjectIdentifiers.whirlpool, PREFIX + "$Digest");
            this.addHMACAlgorithm(configurableProvider, "WHIRLPOOL", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }
}

