/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1InputStream;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.db2util.externals.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.Extensions;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.KeyUsage;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import macromedia.db2util.externals.org.bouncycastle.crypto.Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.MD5Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.SHA1Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.SHA224Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.SHA256Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.SHA384Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.SHA512Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.macs.HMac;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.RSAKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.Certificate;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.CombinedHash;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.HashAlgorithm;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.ProtocolVersion;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.SecurityParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.SessionParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsContext;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsDSSSigner;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsECDSASigner;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsFatalAlert;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsHandshakeHash;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsProtocol;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsRSASigner;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsSession;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsSessionImpl;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsSigner;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import macromedia.db2util.externals.org.bouncycastle.crypto.util.PublicKeyFactory;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;
import macromedia.db2util.externals.org.bouncycastle.util.Integers;
import macromedia.db2util.externals.org.bouncycastle.util.Shorts;
import macromedia.db2util.externals.org.bouncycastle.util.Strings;
import macromedia.db2util.externals.org.bouncycastle.util.io.Streams;

public class TlsUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final short[] EMPTY_SHORTS = new short[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final long[] EMPTY_LONGS = new long[0];
    public static final Integer EXT_signature_algorithms = Integers.valueOf(13);
    static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
    static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
    static final byte[][] SSL3_CONST = TlsUtils.genSSL3Const();

    public static void checkUint8(short s2) throws IOException {
        if (!TlsUtils.isValidUint8(s2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(int n2) throws IOException {
        if (!TlsUtils.isValidUint8(n2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(long l2) throws IOException {
        if (!TlsUtils.isValidUint8(l2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(int n2) throws IOException {
        if (!TlsUtils.isValidUint16(n2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(long l2) throws IOException {
        if (!TlsUtils.isValidUint16(l2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(int n2) throws IOException {
        if (!TlsUtils.isValidUint24(n2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(long l2) throws IOException {
        if (!TlsUtils.isValidUint24(l2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint32(long l2) throws IOException {
        if (!TlsUtils.isValidUint32(l2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint48(long l2) throws IOException {
        if (!TlsUtils.isValidUint48(l2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint64(long l2) throws IOException {
        if (!TlsUtils.isValidUint64(l2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static boolean isValidUint8(short s2) {
        return (s2 & 0xFF) == s2;
    }

    public static boolean isValidUint8(int n2) {
        return (n2 & 0xFF) == n2;
    }

    public static boolean isValidUint8(long l2) {
        return (l2 & 0xFFL) == l2;
    }

    public static boolean isValidUint16(int n2) {
        return (n2 & 0xFFFF) == n2;
    }

    public static boolean isValidUint16(long l2) {
        return (l2 & 0xFFFFL) == l2;
    }

    public static boolean isValidUint24(int n2) {
        return (n2 & 0xFFFFFF) == n2;
    }

    public static boolean isValidUint24(long l2) {
        return (l2 & 0xFFFFFFL) == l2;
    }

    public static boolean isValidUint32(long l2) {
        return (l2 & 0xFFFFFFFFL) == l2;
    }

    public static boolean isValidUint48(long l2) {
        return (l2 & 0xFFFFFFFFFFFFL) == l2;
    }

    public static boolean isValidUint64(long l2) {
        return true;
    }

    public static boolean isSSL(TlsContext tlsContext) {
        return tlsContext.getServerVersion().isSSL();
    }

    public static boolean isTLSv11(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv11(TlsContext tlsContext) {
        return TlsUtils.isTLSv11(tlsContext.getServerVersion());
    }

    public static boolean isTLSv12(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsContext tlsContext) {
        return TlsUtils.isTLSv12(tlsContext.getServerVersion());
    }

    public static void writeUint8(short s2, OutputStream outputStream) throws IOException {
        outputStream.write(s2);
    }

    public static void writeUint8(int n2, OutputStream outputStream) throws IOException {
        outputStream.write(n2);
    }

    public static void writeUint8(short s2, byte[] byArray, int n2) {
        byArray[n2] = (byte)s2;
    }

    public static void writeUint8(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
    }

    public static void writeUint16(int n2, OutputStream outputStream) throws IOException {
        outputStream.write(n2 >>> 8);
        outputStream.write(n2);
    }

    public static void writeUint16(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 8);
        byArray[n3 + 1] = (byte)n2;
    }

    public static void writeUint24(int n2, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n2 >>> 16));
        outputStream.write((byte)(n2 >>> 8));
        outputStream.write((byte)n2);
    }

    public static void writeUint24(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 16);
        byArray[n3 + 1] = (byte)(n2 >>> 8);
        byArray[n3 + 2] = (byte)n2;
    }

    public static void writeUint32(long l2, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l2 >>> 24));
        outputStream.write((byte)(l2 >>> 16));
        outputStream.write((byte)(l2 >>> 8));
        outputStream.write((byte)l2);
    }

    public static void writeUint32(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >>> 24);
        byArray[n2 + 1] = (byte)(l2 >>> 16);
        byArray[n2 + 2] = (byte)(l2 >>> 8);
        byArray[n2 + 3] = (byte)l2;
    }

    public static void writeUint48(long l2, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l2 >>> 40));
        outputStream.write((byte)(l2 >>> 32));
        outputStream.write((byte)(l2 >>> 24));
        outputStream.write((byte)(l2 >>> 16));
        outputStream.write((byte)(l2 >>> 8));
        outputStream.write((byte)l2);
    }

    public static void writeUint48(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >>> 40);
        byArray[n2 + 1] = (byte)(l2 >>> 32);
        byArray[n2 + 2] = (byte)(l2 >>> 24);
        byArray[n2 + 3] = (byte)(l2 >>> 16);
        byArray[n2 + 4] = (byte)(l2 >>> 8);
        byArray[n2 + 5] = (byte)l2;
    }

    public static void writeUint64(long l2, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l2 >>> 56));
        outputStream.write((byte)(l2 >>> 48));
        outputStream.write((byte)(l2 >>> 40));
        outputStream.write((byte)(l2 >>> 32));
        outputStream.write((byte)(l2 >>> 24));
        outputStream.write((byte)(l2 >>> 16));
        outputStream.write((byte)(l2 >>> 8));
        outputStream.write((byte)l2);
    }

    public static void writeUint64(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >>> 56);
        byArray[n2 + 1] = (byte)(l2 >>> 48);
        byArray[n2 + 2] = (byte)(l2 >>> 40);
        byArray[n2 + 3] = (byte)(l2 >>> 32);
        byArray[n2 + 4] = (byte)(l2 >>> 24);
        byArray[n2 + 5] = (byte)(l2 >>> 16);
        byArray[n2 + 6] = (byte)(l2 >>> 8);
        byArray[n2 + 7] = (byte)l2;
    }

    public static void writeOpaque8(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.checkUint8(byArray.length);
        TlsUtils.writeUint8(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void writeOpaque16(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.checkUint16(byArray.length);
        TlsUtils.writeUint16(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void writeOpaque24(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.checkUint24(byArray.length);
        TlsUtils.writeUint24(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void writeUint8Array(short[] sArray, OutputStream outputStream) throws IOException {
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            TlsUtils.writeUint8(sArray[i2], outputStream);
        }
    }

    public static void writeUint8Array(short[] sArray, byte[] byArray, int n2) throws IOException {
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            TlsUtils.writeUint8(sArray[i2], byArray, n2);
            ++n2;
        }
    }

    public static void writeUint8ArrayWithUint8Length(short[] sArray, OutputStream outputStream) throws IOException {
        TlsUtils.checkUint8(sArray.length);
        TlsUtils.writeUint8(sArray.length, outputStream);
        TlsUtils.writeUint8Array(sArray, outputStream);
    }

    public static void writeUint8ArrayWithUint8Length(short[] sArray, byte[] byArray, int n2) throws IOException {
        TlsUtils.checkUint8(sArray.length);
        TlsUtils.writeUint8(sArray.length, byArray, n2);
        TlsUtils.writeUint8Array(sArray, byArray, n2 + 1);
    }

    public static void writeUint16Array(int[] nArray, OutputStream outputStream) throws IOException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            TlsUtils.writeUint16(nArray[i2], outputStream);
        }
    }

    public static void writeUint16Array(int[] nArray, byte[] byArray, int n2) throws IOException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            TlsUtils.writeUint16(nArray[i2], byArray, n2);
            n2 += 2;
        }
    }

    public static void writeUint16ArrayWithUint16Length(int[] nArray, OutputStream outputStream) throws IOException {
        int n2 = 2 * nArray.length;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, outputStream);
        TlsUtils.writeUint16Array(nArray, outputStream);
    }

    public static void writeUint16ArrayWithUint16Length(int[] nArray, byte[] byArray, int n2) throws IOException {
        int n3 = 2 * nArray.length;
        TlsUtils.checkUint16(n3);
        TlsUtils.writeUint16(n3, byArray, n2);
        TlsUtils.writeUint16Array(nArray, byArray, n2 + 2);
    }

    public static byte[] encodeOpaque8(byte[] byArray) throws IOException {
        TlsUtils.checkUint8(byArray.length);
        return Arrays.prepend(byArray, (byte)byArray.length);
    }

    public static byte[] encodeUint8ArrayWithUint8Length(short[] sArray) throws IOException {
        byte[] byArray = new byte[1 + sArray.length];
        TlsUtils.writeUint8ArrayWithUint8Length(sArray, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint16ArrayWithUint16Length(int[] nArray) throws IOException {
        int n2 = 2 * nArray.length;
        byte[] byArray = new byte[2 + n2];
        TlsUtils.writeUint16ArrayWithUint16Length(nArray, byArray, 0);
        return byArray;
    }

    public static short readUint8(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (short)n2;
    }

    public static short readUint8(byte[] byArray, int n2) {
        return (short)(byArray[n2] & 0xFF);
    }

    public static int readUint16(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n3;
    }

    public static int readUint16(byte[] byArray, int n2) {
        int n3 = (byArray[n2] & 0xFF) << 8;
        return n3 |= byArray[++n2] & 0xFF;
    }

    public static int readUint24(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        return n2 << 16 | n3 << 8 | n4;
    }

    public static int readUint24(byte[] byArray, int n2) {
        int n3 = (byArray[n2] & 0xFF) << 16;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        return n3 |= byArray[++n2] & 0xFF;
    }

    public static long readUint32(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        int n5 = inputStream.read();
        if (n5 < 0) {
            throw new EOFException();
        }
        return (long)(n2 << 24 | n3 << 16 | n4 << 8 | n5) & 0xFFFFFFFFL;
    }

    public static long readUint32(byte[] byArray, int n2) {
        int n3 = (byArray[n2] & 0xFF) << 24;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        return (long)(n3 |= byArray[++n2] & 0xFF) & 0xFFFFFFFFL;
    }

    public static long readUint48(InputStream inputStream) throws IOException {
        int n2 = TlsUtils.readUint24(inputStream);
        int n3 = TlsUtils.readUint24(inputStream);
        return ((long)n2 & 0xFFFFFFFFL) << 24 | (long)n3 & 0xFFFFFFFFL;
    }

    public static long readUint48(byte[] byArray, int n2) {
        int n3 = TlsUtils.readUint24(byArray, n2);
        int n4 = TlsUtils.readUint24(byArray, n2 + 3);
        return ((long)n3 & 0xFFFFFFFFL) << 24 | (long)n4 & 0xFFFFFFFFL;
    }

    public static byte[] readAllOrNothing(int n2, InputStream inputStream) throws IOException {
        if (n2 < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[n2];
        int n3 = Streams.readFully(inputStream, byArray);
        if (n3 == 0) {
            return null;
        }
        if (n3 != n2) {
            throw new EOFException();
        }
        return byArray;
    }

    public static byte[] readFully(int n2, InputStream inputStream) throws IOException {
        if (n2 < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[n2];
        if (n2 != Streams.readFully(inputStream, byArray)) {
            throw new EOFException();
        }
        return byArray;
    }

    public static void readFully(byte[] byArray, InputStream inputStream) throws IOException {
        int n2 = byArray.length;
        if (n2 > 0 && n2 != Streams.readFully(inputStream, byArray)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8(inputStream);
        return TlsUtils.readFully(s2, inputStream);
    }

    public static byte[] readOpaque16(InputStream inputStream) throws IOException {
        int n2 = TlsUtils.readUint16(inputStream);
        return TlsUtils.readFully(n2, inputStream);
    }

    public static byte[] readOpaque24(InputStream inputStream) throws IOException {
        int n2 = TlsUtils.readUint24(inputStream);
        return TlsUtils.readFully(n2, inputStream);
    }

    public static short[] readUint8Array(int n2, InputStream inputStream) throws IOException {
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = TlsUtils.readUint8(inputStream);
        }
        return sArray;
    }

    public static int[] readUint16Array(int n2, InputStream inputStream) throws IOException {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = TlsUtils.readUint16(inputStream);
        }
        return nArray;
    }

    public static ProtocolVersion readVersion(byte[] byArray, int n2) throws IOException {
        return ProtocolVersion.get(byArray[n2] & 0xFF, byArray[n2 + 1] & 0xFF);
    }

    public static ProtocolVersion readVersion(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return ProtocolVersion.get(n2, n3);
    }

    public static int readVersionRaw(byte[] byArray, int n2) throws IOException {
        return byArray[n2] << 8 | byArray[n2 + 1];
    }

    public static int readVersionRaw(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n3;
    }

    public static ASN1Primitive readASN1Object(byte[] byArray) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        if (null == aSN1Primitive) {
            throw new TlsFatalAlert(50);
        }
        if (null != aSN1InputStream.readObject()) {
            throw new TlsFatalAlert(50);
        }
        return aSN1Primitive;
    }

    public static ASN1Primitive readDERObject(byte[] byArray) throws IOException {
        ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray);
        byte[] byArray2 = aSN1Primitive.getEncoded("DER");
        if (!Arrays.areEqual(byArray2, byArray)) {
            throw new TlsFatalAlert(50);
        }
        return aSN1Primitive;
    }

    public static void writeGMTUnixTime(byte[] byArray, int n2) {
        int n3 = (int)(System.currentTimeMillis() / 1000L);
        byArray[n2] = (byte)(n3 >>> 24);
        byArray[n2 + 1] = (byte)(n3 >>> 16);
        byArray[n2 + 2] = (byte)(n3 >>> 8);
        byArray[n2 + 3] = (byte)n3;
    }

    public static void writeVersion(ProtocolVersion protocolVersion, OutputStream outputStream) throws IOException {
        outputStream.write(protocolVersion.getMajorVersion());
        outputStream.write(protocolVersion.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion protocolVersion, byte[] byArray, int n2) {
        byArray[n2] = (byte)protocolVersion.getMajorVersion();
        byArray[n2 + 1] = (byte)protocolVersion.getMinorVersion();
    }

    public static Vector getAllSignatureAlgorithms() {
        Vector<Short> vector = new Vector<Short>(4);
        vector.addElement(Shorts.valueOf((short)0));
        vector.addElement(Shorts.valueOf((short)1));
        vector.addElement(Shorts.valueOf((short)2));
        vector.addElement(Shorts.valueOf((short)3));
        return vector;
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 2));
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 3));
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 1));
    }

    public static Vector getDefaultSupportedSignatureAlgorithms() {
        short[] sArray = new short[]{2, 3, 4, 5, 6};
        short[] sArray2 = new short[]{1, 2, 3};
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>();
        for (int i2 = 0; i2 < sArray2.length; ++i2) {
            for (int i3 = 0; i3 < sArray.length; ++i3) {
                vector.addElement(new SignatureAndHashAlgorithm(sArray[i3], sArray2[i2]));
            }
        }
        return vector;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(TlsContext tlsContext, TlsSignerCredentials tlsSignerCredentials) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsUtils.isTLSv12(tlsContext) && (signatureAndHashAlgorithm = tlsSignerCredentials.getSignatureAndHashAlgorithm()) == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static byte[] getExtensionData(Hashtable hashtable, Integer n2) {
        return hashtable == null ? null : (byte[])hashtable.get(n2);
    }

    public static boolean hasExpectedEmptyExtensionData(Hashtable hashtable, Integer n2, short s2) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, n2);
        if (byArray == null) {
            return false;
        }
        if (byArray.length != 0) {
            throw new TlsFatalAlert(s2);
        }
        return true;
    }

    public static TlsSession importSession(byte[] byArray, SessionParameters sessionParameters) {
        return new TlsSessionImpl(byArray, sessionParameters);
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static void addSignatureAlgorithmsExtension(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_signature_algorithms, TlsUtils.createSignatureAlgorithmsExtension(vector));
    }

    public static Vector getSignatureAlgorithmsExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_signature_algorithms);
        return byArray == null ? null : TlsUtils.readSignatureAlgorithmsExtension(byArray);
    }

    public static byte[] createSignatureAlgorithmsExtension(Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.encodeSupportedSignatureAlgorithms(vector, false, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Vector readSignatureAlgorithmsExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsUtils.parseSupportedSignatureAlgorithms(false, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return vector;
    }

    public static void encodeSupportedSignatureAlgorithms(Vector vector, boolean bl, OutputStream outputStream) throws IOException {
        if (vector == null || vector.size() < 1 || vector.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        int n2 = 2 * vector.size();
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, outputStream);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i2);
            if (!bl && signatureAndHashAlgorithm.getSignature() == 0) {
                throw new IllegalArgumentException("SignatureAlgorithm.anonymous MUST NOT appear in the signature_algorithms extension");
            }
            signatureAndHashAlgorithm.encode(outputStream);
        }
    }

    public static Vector parseSupportedSignatureAlgorithms(boolean bl, InputStream inputStream) throws IOException {
        int n2 = TlsUtils.readUint16(inputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int n3 = n2 / 2;
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.parse(inputStream);
            if (!bl && signatureAndHashAlgorithm.getSignature() == 0) {
                throw new TlsFatalAlert(47);
            }
            vector.addElement(signatureAndHashAlgorithm);
        }
        return vector;
    }

    public static void verifySupportedSignatureAlgorithm(Vector vector, SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        if (vector == null || vector.size() < 1 || vector.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        if (signatureAndHashAlgorithm == null) {
            throw new IllegalArgumentException("'signatureAlgorithm' cannot be null");
        }
        if (signatureAndHashAlgorithm.getSignature() != 0) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm2 = (SignatureAndHashAlgorithm)vector.elementAt(i2);
                if (signatureAndHashAlgorithm2.getHash() != signatureAndHashAlgorithm.getHash() || signatureAndHashAlgorithm2.getSignature() != signatureAndHashAlgorithm.getSignature()) continue;
                return;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static byte[] PRF(TlsContext tlsContext, byte[] byArray, String string, byte[] byArray2, int n2) {
        ProtocolVersion protocolVersion = tlsContext.getServerVersion();
        if (protocolVersion.isSSL()) {
            throw new IllegalStateException("No PRF available for SSLv3 session");
        }
        byte[] byArray3 = Strings.toByteArray(string);
        byte[] byArray4 = TlsUtils.concat(byArray3, byArray2);
        int n3 = tlsContext.getSecurityParameters().getPrfAlgorithm();
        if (n3 == 0) {
            return TlsUtils.PRF_legacy(byArray, byArray3, byArray4, n2);
        }
        Digest digest = TlsUtils.createPRFHash(n3);
        byte[] byArray5 = new byte[n2];
        TlsUtils.hmac_hash(digest, byArray, byArray4, byArray5);
        return byArray5;
    }

    public static byte[] PRF_legacy(byte[] byArray, String string, byte[] byArray2, int n2) {
        byte[] byArray3 = Strings.toByteArray(string);
        byte[] byArray4 = TlsUtils.concat(byArray3, byArray2);
        return TlsUtils.PRF_legacy(byArray, byArray3, byArray4, n2);
    }

    static byte[] PRF_legacy(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        int n3 = (byArray.length + 1) / 2;
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n3];
        System.arraycopy(byArray, 0, byArray4, 0, n3);
        System.arraycopy(byArray, byArray.length - n3, byArray5, 0, n3);
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = new byte[n2];
        TlsUtils.hmac_hash(TlsUtils.createHash((short)1), byArray4, byArray3, byArray6);
        TlsUtils.hmac_hash(TlsUtils.createHash((short)2), byArray5, byArray3, byArray7);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = i2;
            byArray6[n4] = (byte)(byArray6[n4] ^ byArray7[i2]);
        }
        return byArray6;
    }

    static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static void hmac_hash(Digest digest, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        HMac hMac = new HMac(digest);
        hMac.init(new KeyParameter(byArray));
        byte[] byArray4 = byArray2;
        int n2 = digest.getDigestSize();
        int n3 = (byArray3.length + n2 - 1) / n2;
        byte[] byArray5 = new byte[hMac.getMacSize()];
        byte[] byArray6 = new byte[hMac.getMacSize()];
        for (int i2 = 0; i2 < n3; ++i2) {
            hMac.update(byArray4, 0, byArray4.length);
            hMac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            hMac.update(byArray4, 0, byArray4.length);
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n2 * i2, Math.min(n2, byArray3.length - n2 * i2));
        }
    }

    static void validateKeyUsage(macromedia.db2util.externals.org.bouncycastle.asn1.x509.Certificate certificate, int n2) throws IOException {
        int n3;
        KeyUsage keyUsage;
        Extensions extensions = certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (keyUsage = KeyUsage.fromExtensions(extensions)) != null && ((n3 = keyUsage.getBytes()[0] & 0xFF) & n2) != n2) {
            throw new TlsFatalAlert(46);
        }
    }

    static byte[] calculateKeyBlock(TlsContext tlsContext, int n2) {
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        byte[] byArray = securityParameters.getMasterSecret();
        byte[] byArray2 = TlsUtils.concat(securityParameters.getServerRandom(), securityParameters.getClientRandom());
        if (TlsUtils.isSSL(tlsContext)) {
            return TlsUtils.calculateKeyBlock_SSL(byArray, byArray2, n2);
        }
        return TlsUtils.PRF(tlsContext, byArray, "key expansion", byArray2, n2);
    }

    static byte[] calculateKeyBlock_SSL(byte[] byArray, byte[] byArray2, int n2) {
        Digest digest = TlsUtils.createHash((short)1);
        Digest digest2 = TlsUtils.createHash((short)2);
        int n3 = digest.getDigestSize();
        byte[] byArray3 = new byte[digest2.getDigestSize()];
        byte[] byArray4 = new byte[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            byte[] byArray5 = SSL3_CONST[n4];
            digest2.update(byArray5, 0, byArray5.length);
            digest2.update(byArray, 0, byArray.length);
            digest2.update(byArray2, 0, byArray2.length);
            digest2.doFinal(byArray3, 0);
            digest.update(byArray, 0, byArray.length);
            digest.update(byArray3, 0, byArray3.length);
            digest.doFinal(byArray4, n5);
            n5 += n3;
            ++n4;
        }
        return Arrays.copyOfRange(byArray4, 0, n2);
    }

    static byte[] calculateMasterSecret(TlsContext tlsContext, byte[] byArray) {
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        byte[] byArray2 = securityParameters.extendedMasterSecret ? securityParameters.getSessionHash() : TlsUtils.concat(securityParameters.getClientRandom(), securityParameters.getServerRandom());
        if (TlsUtils.isSSL(tlsContext)) {
            return TlsUtils.calculateMasterSecret_SSL(byArray, byArray2);
        }
        String string = securityParameters.extendedMasterSecret ? "extended master secret" : "master secret";
        return TlsUtils.PRF(tlsContext, byArray, string, byArray2, 48);
    }

    static byte[] calculateMasterSecret_SSL(byte[] byArray, byte[] byArray2) {
        Digest digest = TlsUtils.createHash((short)1);
        Digest digest2 = TlsUtils.createHash((short)2);
        int n2 = digest.getDigestSize();
        byte[] byArray3 = new byte[digest2.getDigestSize()];
        byte[] byArray4 = new byte[n2 * 3];
        int n3 = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            byte[] byArray5 = SSL3_CONST[i2];
            digest2.update(byArray5, 0, byArray5.length);
            digest2.update(byArray, 0, byArray.length);
            digest2.update(byArray2, 0, byArray2.length);
            digest2.doFinal(byArray3, 0);
            digest.update(byArray, 0, byArray.length);
            digest.update(byArray3, 0, byArray3.length);
            digest.doFinal(byArray4, n3);
            n3 += n2;
        }
        return byArray4;
    }

    static byte[] calculateVerifyData(TlsContext tlsContext, String string, byte[] byArray) {
        if (TlsUtils.isSSL(tlsContext)) {
            return byArray;
        }
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        byte[] byArray2 = securityParameters.getMasterSecret();
        int n2 = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(tlsContext, byArray2, string, byArray, n2);
    }

    public static Digest createHash(short s2) {
        switch (s2) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public static Digest createHash(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        return signatureAndHashAlgorithm == null ? new CombinedHash() : TlsUtils.createHash(signatureAndHashAlgorithm.getHash());
    }

    public static Digest cloneHash(short s2, Digest digest) {
        switch (s2) {
            case 1: {
                return new MD5Digest((MD5Digest)digest);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)digest);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)digest);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)digest);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)digest);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)digest);
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public static Digest createPRFHash(int n2) {
        switch (n2) {
            case 0: {
                return new CombinedHash();
            }
        }
        return TlsUtils.createHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(n2));
    }

    public static Digest clonePRFHash(int n2, Digest digest) {
        switch (n2) {
            case 0: {
                return new CombinedHash((CombinedHash)digest);
            }
        }
        return TlsUtils.cloneHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(n2), digest);
    }

    public static short getHashAlgorithmForPRFAlgorithm(int n2) {
        switch (n2) {
            case 0: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm");
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(short s2) {
        switch (s2) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    static short getClientCertificateType(Certificate certificate, Certificate certificate2) throws IOException {
        if (certificate.isEmpty()) {
            return -1;
        }
        macromedia.db2util.externals.org.bouncycastle.asn1.x509.Certificate certificate3 = certificate.getCertificateAt(0);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificate3.getSubjectPublicKeyInfo();
        try {
            AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey(subjectPublicKeyInfo);
            if (asymmetricKeyParameter.isPrivate()) {
                throw new TlsFatalAlert(80);
            }
            if (asymmetricKeyParameter instanceof RSAKeyParameters) {
                TlsUtils.validateKeyUsage(certificate3, 128);
                return 1;
            }
            if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
                TlsUtils.validateKeyUsage(certificate3, 128);
                return 2;
            }
            if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
                TlsUtils.validateKeyUsage(certificate3, 128);
                return 64;
            }
            throw new TlsFatalAlert(43);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(43, (Throwable)exception);
        }
    }

    static void trackHashAlgorithms(TlsHandshakeHash tlsHandshakeHash, Vector vector) {
        if (vector != null) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i2);
                short s2 = signatureAndHashAlgorithm.getHash();
                if (HashAlgorithm.isPrivate(s2)) continue;
                tlsHandshakeHash.trackHashAlgorithm(s2);
            }
        }
    }

    public static boolean hasSigningCapability(short s2) {
        switch (s2) {
            case 1: 
            case 2: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    public static TlsSigner createTlsSigner(short s2) {
        switch (s2) {
            case 2: {
                return new TlsDSSSigner();
            }
            case 64: {
                return new TlsECDSASigner();
            }
            case 1: {
                return new TlsRSASigner();
            }
        }
        throw new IllegalArgumentException("'clientCertificateType' is not a type with signing capability");
    }

    private static byte[][] genSSL3Const() {
        int n2 = 10;
        byte[][] byArrayArray = new byte[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray = new byte[i2 + 1];
            Arrays.fill(byArray, (byte)(65 + i2));
            byArrayArray[i2] = byArray;
        }
        return byArrayArray;
    }

    private static Vector vectorOfOne(Object object) {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return vector;
    }

    public static int getCipherType(int n2) throws IOException {
        switch (TlsUtils.getEncryptionAlgorithm(n2)) {
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 103: 
            case 104: {
                return 2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static int getEncryptionAlgorithm(int n2) throws IOException {
        switch (n2) {
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 139: 
            case 143: 
            case 147: 
            case 49155: 
            case 49160: 
            case 49165: 
            case 49170: 
            case 49175: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49204: {
                return 7;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 108: 
            case 140: 
            case 144: 
            case 148: 
            case 174: 
            case 178: 
            case 182: 
            case 49156: 
            case 49161: 
            case 49166: 
            case 49171: 
            case 49176: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49205: 
            case 49207: {
                return 8;
            }
            case 49308: 
            case 49310: 
            case 49316: 
            case 49318: 
            case 49324: {
                return 15;
            }
            case 49312: 
            case 49314: 
            case 49320: 
            case 49322: 
            case 49326: {
                return 16;
            }
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: {
                return 10;
            }
            case 65280: 
            case 65282: 
            case 65284: 
            case 65296: 
            case 65298: 
            case 65300: {
                return 103;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 141: 
            case 145: 
            case 149: 
            case 175: 
            case 179: 
            case 183: 
            case 49157: 
            case 49162: 
            case 49167: 
            case 49172: 
            case 49177: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49206: 
            case 49208: {
                return 9;
            }
            case 49309: 
            case 49311: 
            case 49317: 
            case 49319: 
            case 49325: {
                return 17;
            }
            case 49313: 
            case 49315: 
            case 49321: 
            case 49323: 
            case 49327: {
                return 18;
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: {
                return 11;
            }
            case 65281: 
            case 65283: 
            case 65285: 
            case 65297: 
            case 65299: 
            case 65301: {
                return 104;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 12;
            }
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: {
                return 19;
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 13;
            }
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: {
                return 20;
            }
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: {
                return 21;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 44: 
            case 45: 
            case 46: 
            case 49153: 
            case 49158: 
            case 49163: 
            case 49168: 
            case 49173: 
            case 49209: {
                return 0;
            }
            case 59: 
            case 176: 
            case 180: 
            case 184: 
            case 49210: {
                return 0;
            }
            case 177: 
            case 181: 
            case 185: 
            case 49211: {
                return 0;
            }
            case 4: 
            case 24: {
                return 2;
            }
            case 5: 
            case 138: 
            case 142: 
            case 146: 
            case 49154: 
            case 49159: 
            case 49164: 
            case 49169: 
            case 49174: 
            case 49203: {
                return 2;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                return 14;
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static int getKeyExchangeAlgorithm(int n2) throws IOException {
        switch (n2) {
            case 24: 
            case 27: 
            case 52: 
            case 58: 
            case 70: 
            case 108: 
            case 109: 
            case 137: 
            case 155: 
            case 166: 
            case 167: 
            case 191: 
            case 197: 
            case 49284: 
            case 49285: {
                return 11;
            }
            case 13: 
            case 48: 
            case 54: 
            case 62: 
            case 66: 
            case 104: 
            case 133: 
            case 151: 
            case 164: 
            case 165: 
            case 187: 
            case 193: 
            case 49282: 
            case 49283: {
                return 7;
            }
            case 16: 
            case 49: 
            case 55: 
            case 63: 
            case 67: 
            case 105: 
            case 134: 
            case 152: 
            case 160: 
            case 161: 
            case 188: 
            case 194: 
            case 49278: 
            case 49279: {
                return 9;
            }
            case 19: 
            case 50: 
            case 56: 
            case 64: 
            case 68: 
            case 106: 
            case 135: 
            case 153: 
            case 162: 
            case 163: 
            case 189: 
            case 195: 
            case 49280: 
            case 49281: {
                return 3;
            }
            case 45: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 170: 
            case 171: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 49296: 
            case 49297: 
            case 49302: 
            case 49303: 
            case 49318: 
            case 49319: 
            case 49322: 
            case 49323: 
            case 52397: 
            case 65298: 
            case 65299: {
                return 14;
            }
            case 22: 
            case 51: 
            case 57: 
            case 69: 
            case 103: 
            case 107: 
            case 136: 
            case 154: 
            case 158: 
            case 159: 
            case 190: 
            case 196: 
            case 49276: 
            case 49277: 
            case 49310: 
            case 49311: 
            case 49314: 
            case 49315: 
            case 52394: 
            case 65280: 
            case 65281: {
                return 5;
            }
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: {
                return 20;
            }
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49189: 
            case 49190: 
            case 49197: 
            case 49198: 
            case 49268: 
            case 49269: 
            case 49288: 
            case 49289: {
                return 16;
            }
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49193: 
            case 49194: 
            case 49201: 
            case 49202: 
            case 49272: 
            case 49273: 
            case 49292: 
            case 49293: {
                return 18;
            }
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49187: 
            case 49188: 
            case 49195: 
            case 49196: 
            case 49266: 
            case 49267: 
            case 49286: 
            case 49287: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52393: 
            case 65284: 
            case 65285: {
                return 17;
            }
            case 49203: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49207: 
            case 49208: 
            case 49209: 
            case 49210: 
            case 49211: 
            case 49306: 
            case 49307: 
            case 52396: 
            case 65300: 
            case 65301: {
                return 24;
            }
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49191: 
            case 49192: 
            case 49199: 
            case 49200: 
            case 49270: 
            case 49271: 
            case 49290: 
            case 49291: 
            case 52392: 
            case 65282: 
            case 65283: {
                return 19;
            }
            case 44: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 168: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 49294: 
            case 49295: 
            case 49300: 
            case 49301: 
            case 49316: 
            case 49317: 
            case 49320: 
            case 49321: 
            case 52395: 
            case 65296: 
            case 65297: {
                return 13;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 47: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 132: 
            case 150: 
            case 156: 
            case 157: 
            case 186: 
            case 192: 
            case 49274: 
            case 49275: 
            case 49308: 
            case 49309: 
            case 49312: 
            case 49313: {
                return 1;
            }
            case 46: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 172: 
            case 173: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 49298: 
            case 49299: 
            case 49304: 
            case 49305: 
            case 52398: {
                return 15;
            }
            case 49178: 
            case 49181: 
            case 49184: {
                return 21;
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return 22;
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return 23;
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static int getMACAlgorithm(int n2) throws IOException {
        switch (n2) {
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                return 0;
            }
            case 1: 
            case 4: 
            case 24: {
                return 1;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49203: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49209: {
                return 2;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 174: 
            case 176: 
            case 178: 
            case 180: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49207: 
            case 49210: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 3;
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49208: 
            case 49211: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 4;
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static ProtocolVersion getMinimumVersion(int n2) {
        switch (n2) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49188: 
            case 49189: 
            case 49190: 
            case 49191: 
            case 49192: 
            case 49193: 
            case 49194: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49266: 
            case 49267: 
            case 49268: 
            case 49269: 
            case 49270: 
            case 49271: 
            case 49272: 
            case 49273: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                return ProtocolVersion.TLSv12;
            }
        }
        return ProtocolVersion.SSLv3;
    }

    public static boolean isAEADCipherSuite(int n2) throws IOException {
        return 2 == TlsUtils.getCipherType(n2);
    }

    public static boolean isBlockCipherSuite(int n2) throws IOException {
        return 1 == TlsUtils.getCipherType(n2);
    }

    public static boolean isStreamCipherSuite(int n2) throws IOException {
        return 0 == TlsUtils.getCipherType(n2);
    }

    public static boolean isValidCipherSuiteForSignatureAlgorithms(int n2, Vector vector) {
        int n3;
        try {
            n3 = TlsUtils.getKeyExchangeAlgorithm(n2);
        }
        catch (IOException iOException) {
            return true;
        }
        switch (n3) {
            case 11: 
            case 12: 
            case 20: {
                return vector.contains(Shorts.valueOf((short)0));
            }
            case 5: 
            case 6: 
            case 19: 
            case 23: {
                return vector.contains(Shorts.valueOf((short)1));
            }
            case 3: 
            case 4: 
            case 22: {
                return vector.contains(Shorts.valueOf((short)2));
            }
            case 17: {
                return vector.contains(Shorts.valueOf((short)3));
            }
        }
        return true;
    }

    public static boolean isValidCipherSuiteForVersion(int n2, ProtocolVersion protocolVersion) {
        return TlsUtils.getMinimumVersion(n2).isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static Vector getUsableSignatureAlgorithms(Vector vector) {
        if (vector == null) {
            return TlsUtils.getAllSignatureAlgorithms();
        }
        Vector<Short> vector2 = new Vector<Short>(4);
        vector2.addElement(Shorts.valueOf((short)0));
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i2);
            Short s2 = Shorts.valueOf(signatureAndHashAlgorithm.getSignature());
            if (vector2.contains(s2)) continue;
            vector2.addElement(s2);
        }
        return vector2;
    }
}

