/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.tls;

import java.io.IOException;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.AbstractTlsClient;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsAuthentication;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsCipherFactory;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsFatalAlert;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsKeyExchange;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsPSKIdentity;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsPSKKeyExchange;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsUtils;

public class PSKTlsClient
extends AbstractTlsClient {
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity tlsPSKIdentity) {
        this(new DefaultTlsCipherFactory(), tlsPSKIdentity);
    }

    public PSKTlsClient(TlsCipherFactory tlsCipherFactory, TlsPSKIdentity tlsPSKIdentity) {
        super(tlsCipherFactory);
        this.pskIdentity = tlsPSKIdentity;
    }

    public int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int n2) {
        return new TlsPSKKeyExchange(n2, this.supportedSignatureAlgorithms, this.pskIdentity, null, null, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

