/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.db2util.externals.org.bouncycastle.crypto.DSA;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ECDomainParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ECKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.signers.DSAKCalculator;
import macromedia.db2util.externals.org.bouncycastle.crypto.signers.RandomDSAKCalculator;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECAlgorithms;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECConstants;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECFieldElement;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECMultiplier;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.db2util.externals.org.bouncycastle.math.ec.FixedPointCombMultiplier;

public class ECDSASigner
implements ECConstants,
DSA {
    private final DSAKCalculator kCalculator;
    private ECKeyParameters key;
    private SecureRandom random;

    public ECDSASigner() {
        this.kCalculator = new RandomDSAKCalculator();
    }

    public ECDSASigner(DSAKCalculator dSAKCalculator) {
        this.kCalculator = dSAKCalculator;
    }

    public void init(boolean bl, dda dda10) {
        SecureRandom secureRandom = null;
        if (bl) {
            if (dda10 instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)dda10;
                this.key = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
                secureRandom = parametersWithRandom.getRandom();
            } else {
                this.key = (ECPrivateKeyParameters)dda10;
            }
        } else {
            this.key = (ECPublicKeyParameters)dda10;
        }
        this.random = this.initSecureRandom(bl && !this.kCalculator.isDeterministic(), secureRandom);
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        ECPoint eCPoint;
        BigInteger bigInteger3;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger4 = eCDomainParameters.getN();
        BigInteger bigInteger5 = this.calculateE(bigInteger4, byArray);
        BigInteger bigInteger6 = ((ECPrivateKeyParameters)this.key).getD();
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(bigInteger4, bigInteger6, byArray);
        } else {
            this.kCalculator.init(bigInteger4, this.random);
        }
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        do {
            bigInteger2 = this.kCalculator.nextK();
        } while ((bigInteger3 = (eCPoint = eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger2).normalize()).getAffineXCoord().toBigInteger().mod(bigInteger4)).equals(ECConstants.ZERO) || (bigInteger = bigInteger2.modInverse(bigInteger4).multiply(bigInteger5.add(bigInteger6.multiply(bigInteger3))).mod(bigInteger4)).equals(ECConstants.ZERO));
        return new BigInteger[]{bigInteger3, bigInteger};
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECFieldElement eCFieldElement;
        BigInteger bigInteger3;
        ECPoint eCPoint;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger4 = eCDomainParameters.getN();
        BigInteger bigInteger5 = this.calculateE(bigInteger4, byArray);
        if (bigInteger.compareTo(ECConstants.ONE) < 0 || bigInteger.compareTo(bigInteger4) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ECConstants.ONE) < 0 || bigInteger2.compareTo(bigInteger4) >= 0) {
            return false;
        }
        BigInteger bigInteger6 = bigInteger2.modInverse(bigInteger4);
        BigInteger bigInteger7 = bigInteger5.multiply(bigInteger6).mod(bigInteger4);
        BigInteger bigInteger8 = bigInteger.multiply(bigInteger6).mod(bigInteger4);
        ECPoint eCPoint2 = eCDomainParameters.getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger7, eCPoint = ((ECPublicKeyParameters)this.key).getQ(), bigInteger8);
        if (eCPoint3.isInfinity()) {
            return false;
        }
        ECCurve eCCurve = eCPoint3.getCurve();
        if (eCCurve != null && (bigInteger3 = eCCurve.getCofactor()) != null && bigInteger3.compareTo(ECConstants.EIGHT) <= 0 && (eCFieldElement = this.getDenominator(eCCurve.getCoordinateSystem(), eCPoint3)) != null && !eCFieldElement.isZero()) {
            ECFieldElement eCFieldElement2 = eCPoint3.getXCoord();
            while (eCCurve.isValidFieldElement(bigInteger)) {
                ECFieldElement eCFieldElement3 = eCCurve.fromBigInteger(bigInteger).multiply(eCFieldElement);
                if (eCFieldElement3.equals(eCFieldElement2)) {
                    return true;
                }
                bigInteger = bigInteger.add(bigInteger4);
            }
            return false;
        }
        bigInteger3 = eCPoint3.normalize().getAffineXCoord().toBigInteger().mod(bigInteger4);
        return bigInteger3.equals(bigInteger);
    }

    protected BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        int n2 = bigInteger.bitLength();
        int n3 = byArray.length * 8;
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        if (n2 < n3) {
            bigInteger2 = bigInteger2.shiftRight(n3 - n2);
        }
        return bigInteger2;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected ECFieldElement getDenominator(int n2, ECPoint eCPoint) {
        switch (n2) {
            case 1: 
            case 6: 
            case 7: {
                return eCPoint.getZCoord(0);
            }
            case 2: 
            case 3: 
            case 4: {
                return eCPoint.getZCoord(0).square();
            }
        }
        return null;
    }

    protected SecureRandom initSecureRandom(boolean bl, SecureRandom secureRandom) {
        return !bl ? null : (secureRandom != null ? secureRandom : CryptoServicesRegistrar.getSecureRandom());
    }
}

