/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.modes;

import macromedia.db2util.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.StreamBlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.modes.GOST3413CipherUtil;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;

public class G3413OFBBlockCipher
extends StreamBlockCipher {
    private int m;
    private int blockSize;
    private byte[] R;
    private byte[] R_init;
    private byte[] Y;
    private BlockCipher cipher;
    private int byteCount;
    private boolean initialized = false;

    public G3413OFBBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.blockSize = blockCipher.getBlockSize();
        this.cipher = blockCipher;
        this.Y = new byte[this.blockSize];
    }

    public void init(boolean bl, dda dda10) throws IllegalArgumentException {
        if (dda10 instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)dda10;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.blockSize) {
                throw new IllegalArgumentException("Parameter m must blockSize <= m");
            }
            this.m = byArray.length;
            this.initArrays();
            this.R_init = Arrays.clone(byArray);
            System.arraycopy(this.R_init, 0, this.R, 0, this.R_init.length);
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.setupDefaultParams();
            this.initArrays();
            System.arraycopy(this.R_init, 0, this.R, 0, this.R_init.length);
            if (dda10 != null) {
                this.cipher.init(true, dda10);
            }
        }
        this.initialized = true;
    }

    private final void initArrays() {
        this.R = new byte[this.m];
        this.R_init = new byte[this.m];
    }

    private final void setupDefaultParams() {
        this.m = 2 * this.blockSize;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/OFB";
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.blockSize, byArray2, n3);
        return this.blockSize;
    }

    protected byte calculateByte(byte by) {
        if (this.byteCount == 0) {
            this.generateY();
        }
        byte by2 = (byte)(this.Y[this.byteCount] ^ by);
        ++this.byteCount;
        if (this.byteCount == this.getBlockSize()) {
            this.byteCount = 0;
            this.generateR();
        }
        return by2;
    }

    private final void generateY() {
        byte[] byArray = GOST3413CipherUtil.MSB(this.R, this.blockSize);
        this.cipher.processBlock(byArray, 0, this.Y, 0);
    }

    private final void generateR() {
        byte[] byArray = GOST3413CipherUtil.LSB(this.R, this.m - this.blockSize);
        System.arraycopy(byArray, 0, this.R, 0, byArray.length);
        System.arraycopy(this.Y, 0, this.R, byArray.length, this.m - byArray.length);
    }

    public void reset() {
        if (this.initialized) {
            System.arraycopy(this.R_init, 0, this.R, 0, this.R_init.length);
            Arrays.clear(this.Y);
            this.byteCount = 0;
            this.cipher.reset();
        }
    }
}

