/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.modes;

import macromedia.db2util.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.modes.GOST3413CipherUtil;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;

public class G3413CBCBlockCipher
implements BlockCipher {
    private int m;
    private int blockSize;
    private byte[] R;
    private byte[] R_init;
    private BlockCipher cipher;
    private boolean initialized = false;
    private boolean forEncryption;

    public G3413CBCBlockCipher(BlockCipher blockCipher) {
        this.blockSize = blockCipher.getBlockSize();
        this.cipher = blockCipher;
    }

    public void init(boolean bl, dda dda10) throws IllegalArgumentException {
        this.forEncryption = bl;
        if (dda10 instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)dda10;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.blockSize) {
                throw new IllegalArgumentException("Parameter m must blockSize <= m");
            }
            this.m = byArray.length;
            this.initArrays();
            this.R_init = Arrays.clone(byArray);
            System.arraycopy(this.R_init, 0, this.R, 0, this.R_init.length);
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(bl, parametersWithIV.getParameters());
            }
        } else {
            this.setupDefaultParams();
            this.initArrays();
            System.arraycopy(this.R_init, 0, this.R, 0, this.R_init.length);
            if (dda10 != null) {
                this.cipher.init(bl, dda10);
            }
        }
        this.initialized = true;
    }

    private final void initArrays() {
        this.R = new byte[this.m];
        this.R_init = new byte[this.m];
    }

    private final void setupDefaultParams() {
        this.m = this.blockSize;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CBC";
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        return this.forEncryption ? this.encrypt(byArray, n2, byArray2, n3) : this.decrypt(byArray, n2, byArray2, n3);
    }

    private final int encrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = GOST3413CipherUtil.MSB(this.R, this.blockSize);
        byte[] byArray4 = GOST3413CipherUtil.copyFromInput(byArray, this.blockSize, n2);
        byte[] byArray5 = GOST3413CipherUtil.sum(byArray4, byArray3);
        byte[] byArray6 = new byte[byArray5.length];
        this.cipher.processBlock(byArray5, 0, byArray6, 0);
        System.arraycopy(byArray6, 0, byArray2, n3, byArray6.length);
        if (byArray2.length > n3 + byArray5.length) {
            this.generateR(byArray6);
        }
        return byArray6.length;
    }

    private final int decrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = GOST3413CipherUtil.MSB(this.R, this.blockSize);
        byte[] byArray4 = GOST3413CipherUtil.copyFromInput(byArray, this.blockSize, n2);
        byte[] byArray5 = new byte[byArray4.length];
        this.cipher.processBlock(byArray4, 0, byArray5, 0);
        byte[] byArray6 = GOST3413CipherUtil.sum(byArray5, byArray3);
        System.arraycopy(byArray6, 0, byArray2, n3, byArray6.length);
        if (byArray2.length > n3 + byArray6.length) {
            this.generateR(byArray4);
        }
        return byArray6.length;
    }

    private final void generateR(byte[] byArray) {
        byte[] byArray2 = GOST3413CipherUtil.LSB(this.R, this.m - this.blockSize);
        System.arraycopy(byArray2, 0, this.R, 0, byArray2.length);
        System.arraycopy(byArray, 0, this.R, byArray2.length, this.m - byArray2.length);
    }

    public void reset() {
        if (this.initialized) {
            System.arraycopy(this.R_init, 0, this.R, 0, this.R_init.length);
            this.cipher.reset();
        }
    }
}

