/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import macromedia.db2util.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.Mac;
import macromedia.db2util.externals.org.bouncycastle.crypto.MacDerivationFunction;
import macromedia.db2util.externals.org.bouncycastle.crypto.ddb;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KDFCounterParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;

public class KDFCounterBytesGenerator
implements MacDerivationFunction {
    private static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final Mac prf;
    private final int h;
    private byte[] fixedInputDataCtrPrefix;
    private byte[] fixedInputData_afterCtr;
    private int maxSizeExcl;
    private byte[] ios;
    private int generatedBytes;
    private byte[] k;

    public KDFCounterBytesGenerator(Mac mac) {
        this.prf = mac;
        this.h = mac.getMacSize();
        this.k = new byte[this.h];
    }

    public void init(ddb ddb10) {
        if (!(ddb10 instanceof KDFCounterParameters)) {
            throw new IllegalArgumentException("Wrong type of arguments given");
        }
        KDFCounterParameters kDFCounterParameters = (KDFCounterParameters)ddb10;
        this.prf.init(new KeyParameter(kDFCounterParameters.getKI()));
        this.fixedInputDataCtrPrefix = kDFCounterParameters.getFixedInputDataCounterPrefix();
        this.fixedInputData_afterCtr = kDFCounterParameters.getFixedInputDataCounterSuffix();
        int n2 = kDFCounterParameters.getR();
        this.ios = new byte[n2 / 8];
        BigInteger bigInteger = TWO.pow(n2).multiply(BigInteger.valueOf(this.h));
        this.maxSizeExcl = bigInteger.compareTo(INTEGER_MAX) == 1 ? Integer.MAX_VALUE : bigInteger.intValue();
        this.generatedBytes = 0;
    }

    public Mac getMac() {
        return this.prf;
    }

    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        int n4 = this.generatedBytes + n3;
        if (n4 < 0 || n4 >= this.maxSizeExcl) {
            throw new DataLengthException("Current KDFCTR may only be used for " + this.maxSizeExcl + " bytes");
        }
        if (this.generatedBytes % this.h == 0) {
            this.generateNext();
        }
        int n5 = n3;
        int n6 = this.generatedBytes % this.h;
        int n7 = this.h - this.generatedBytes % this.h;
        int n8 = Math.min(n7, n5);
        System.arraycopy(this.k, n6, byArray, n2, n8);
        this.generatedBytes += n8;
        n5 -= n8;
        n2 += n8;
        while (n5 > 0) {
            this.generateNext();
            n8 = Math.min(this.h, n5);
            System.arraycopy(this.k, 0, byArray, n2, n8);
            this.generatedBytes += n8;
            n5 -= n8;
            n2 += n8;
        }
        return n3;
    }

    private final void generateNext() {
        int n2 = this.generatedBytes / this.h + 1;
        switch (this.ios.length) {
            case 4: {
                this.ios[0] = (byte)(n2 >>> 24);
            }
            case 3: {
                this.ios[this.ios.length - 3] = (byte)(n2 >>> 16);
            }
            case 2: {
                this.ios[this.ios.length - 2] = (byte)(n2 >>> 8);
            }
            case 1: {
                this.ios[this.ios.length - 1] = (byte)n2;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported size of counter i");
            }
        }
        this.prf.update(this.fixedInputDataCtrPrefix, 0, this.fixedInputDataCtrPrefix.length);
        this.prf.update(this.ios, 0, this.ios.length);
        this.prf.update(this.fixedInputData_afterCtr, 0, this.fixedInputData_afterCtr.length);
        this.prf.doFinal(this.k, 0);
    }
}

