/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.engines;

import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.engines.GOST28147Engine;
import macromedia.db2util.externals.org.bouncycastle.crypto.engines.GOST28147WrapEngine;
import macromedia.db2util.externals.org.bouncycastle.crypto.modes.GCFBBlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithSBox;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithUKM;
import macromedia.db2util.externals.org.bouncycastle.util.Pack;

public class CryptoProWrapEngine
extends GOST28147WrapEngine {
    public void init(boolean bl, dda dda10) {
        KeyParameter keyParameter;
        dda dda11;
        if (dda10 instanceof ParametersWithRandom) {
            dda11 = (ParametersWithRandom)dda10;
            dda10 = ((ParametersWithRandom)dda11).getParameters();
        }
        dda11 = (ParametersWithUKM)dda10;
        byte[] byArray = null;
        if (((ParametersWithUKM)dda11).getParameters() instanceof ParametersWithSBox) {
            keyParameter = (KeyParameter)((ParametersWithSBox)((ParametersWithUKM)dda11).getParameters()).getParameters();
            byArray = ((ParametersWithSBox)((ParametersWithUKM)dda11).getParameters()).getSBox();
        } else {
            keyParameter = (KeyParameter)((ParametersWithUKM)dda11).getParameters();
        }
        keyParameter = new KeyParameter(CryptoProWrapEngine.cryptoProDiversify(keyParameter.getKey(), ((ParametersWithUKM)dda11).getUKM(), byArray));
        if (byArray != null) {
            super.init(bl, new ParametersWithUKM(new ParametersWithSBox(keyParameter, byArray), ((ParametersWithUKM)dda11).getUKM()));
        } else {
            super.init(bl, new ParametersWithUKM(keyParameter, ((ParametersWithUKM)dda11).getUKM()));
        }
    }

    private static byte[] cryptoProDiversify(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 != 8; ++i2) {
            int n2 = 0;
            int n3 = 0;
            for (int i3 = 0; i3 != 8; ++i3) {
                int n4 = Pack.littleEndianToInt(byArray, i3 * 4);
                if (CryptoProWrapEngine.bitSet(byArray2[i2], i3)) {
                    n2 += n4;
                    continue;
                }
                n3 += n4;
            }
            byte[] byArray4 = new byte[8];
            Pack.intToLittleEndian(n2, byArray4, 0);
            Pack.intToLittleEndian(n3, byArray4, 4);
            GCFBBlockCipher gCFBBlockCipher = new GCFBBlockCipher(new GOST28147Engine());
            gCFBBlockCipher.init(true, new ParametersWithIV(new ParametersWithSBox(new KeyParameter(byArray), byArray3), byArray4));
            gCFBBlockCipher.processBlock(byArray, 0, byArray, 0);
            gCFBBlockCipher.processBlock(byArray, 8, byArray, 8);
            gCFBBlockCipher.processBlock(byArray, 16, byArray, 16);
            gCFBBlockCipher.processBlock(byArray, 24, byArray, 24);
        }
        return byArray;
    }

    private static boolean bitSet(byte by, int n2) {
        return (by & 1 << n2) != 0;
    }
}

