/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.asn1.tsp;

import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1EncodableVector;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Object;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1OctetString;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.db2util.externals.org.bouncycastle.asn1.DEROctetString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERSequence;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;

public class MessageImprint
extends ASN1Object {
    AlgorithmIdentifier hashAlgorithm;
    byte[] hashedMessage;

    public static MessageImprint getInstance(Object object) {
        if (object instanceof MessageImprint) {
            return (MessageImprint)object;
        }
        if (object != null) {
            return new MessageImprint(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private MessageImprint(ASN1Sequence aSN1Sequence) {
        this.hashAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.hashedMessage = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets();
    }

    public MessageImprint(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.hashAlgorithm = algorithmIdentifier;
        this.hashedMessage = Arrays.clone(byArray);
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getHashedMessage() {
        return Arrays.clone(this.hashedMessage);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.hashAlgorithm);
        aSN1EncodableVector.add(new DEROctetString(this.hashedMessage));
        return new DERSequence(aSN1EncodableVector);
    }
}

