/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util;

import java.io.IOException;
import java.security.AlgorithmParameters;
import sun.security.pkcs.ParsingException;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class MacData {
    private String digestAlgorithmName;
    private AlgorithmParameters digestAlgorithmParams;
    private byte[] digest;
    private byte[] macSalt;
    private int iterations;
    private byte[] encoded = null;

    MacData(DerInputStream derInputStream) throws IOException, ParsingException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerInputStream derInputStream2 = new DerInputStream(derValueArray[0].toByteArray());
        DerValue[] derValueArray2 = derInputStream2.getSequence(2);
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray2[0]);
        this.digestAlgorithmName = algorithmId.getName();
        this.digestAlgorithmParams = algorithmId.getParameters();
        this.digest = derValueArray2[1].getOctetString();
        this.macSalt = derValueArray[1].getOctetString();
        this.iterations = derValueArray.length > 2 ? derValueArray[2].getInteger() : 1;
    }

    final String getDigestAlgName() {
        return this.digestAlgorithmName;
    }

    final byte[] getSalt() {
        return this.macSalt;
    }

    final int getIterations() {
        return this.iterations;
    }

    final byte[] getDigest() {
        return this.digest;
    }
}

