/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import macromedia.db2util.MacDataIBM;
import sun.security.pkcs.ContentInfo;

public class DDPKCS12KeyStoreProviderIBM
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final int[] keyBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 2};
    private static final int[] certBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 3};
    private static final int[] unshroudedKeyBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 1};
    private static final int[] pkcs9Name = new int[]{1, 2, 840, 113549, 1, 9, 20};
    private static final int[] pkcs9KeyId = new int[]{1, 2, 840, 113549, 1, 9, 21};
    private static final int[] pkcs9certType = new int[]{1, 2, 840, 113549, 1, 9, 22, 1};
    private static final int[] pbeWithSHAAnd40BitRC2CBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 6};
    private static final int[] pbeWithSHAAnd3KeyTripleDESCBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 3};
    private static int[] pkcs7 = new int[]{1, 2, 840, 113549, 1, 7};
    private static int[] data = new int[]{1, 2, 840, 113549, 1, 7, 1};
    private static int[] sdata = new int[]{1, 2, 840, 113549, 1, 7, 2};
    private static int[] edata = new int[]{1, 2, 840, 113549, 1, 7, 3};
    private static int[] sedata = new int[]{1, 2, 840, 113549, 1, 7, 4};
    private static int[] ddata = new int[]{1, 2, 840, 113549, 1, 7, 5};
    private static int[] crdata = new int[]{1, 2, 840, 113549, 1, 7, 6};
    private static int[] nsdata = new int[]{2, 16, 840, 1, 113730, 2, 5};
    private static int[] tstInfo = new int[]{1, 2, 840, 113549, 1, 9, 16, 1, 4};
    private static final int[] OLD_SDATA = new int[]{1, 2, 840, 1113549, 1, 7, 2};
    private static final int[] OLD_DATA = new int[]{1, 2, 840, 1113549, 1, 7, 1};
    public static ObjectIdentifier PKCS7_OID;
    public static ObjectIdentifier DATA_OID;
    public static ObjectIdentifier SIGNED_DATA_OID;
    public static ObjectIdentifier ENVELOPED_DATA_OID;
    public static ObjectIdentifier SIGNED_AND_ENVELOPED_DATA_OID;
    public static ObjectIdentifier DIGESTED_DATA_OID;
    public static ObjectIdentifier ENCRYPTED_DATA_OID;
    public static ObjectIdentifier OLD_SIGNED_DATA_OID;
    public static ObjectIdentifier OLD_DATA_OID;
    public static ObjectIdentifier NETSCAPE_CERT_SEQUENCE_OID;
    public static ObjectIdentifier TIMESTAMP_TOKEN_INFO_OID;
    private static ObjectIdentifier PKCS8ShroudedKeyBag_OID;
    private static ObjectIdentifier CertBag_OID;
    private static ObjectIdentifier KeyBag_OID;
    private static ObjectIdentifier PKCS9FriendlyName_OID;
    private static ObjectIdentifier PKCS9LocalKeyId_OID;
    private static ObjectIdentifier PKCS9CertType_OID;
    private static ObjectIdentifier pbeWithSHAAnd40BitRC2CBC_OID;
    private static ObjectIdentifier pbeWithSHAAnd3KeyTripleDESCBC_OID;
    private static volatile int counter;
    private static int privateKeyCount;
    private static Hashtable entries;
    private static ArrayList keyList;
    private static LinkedHashMap certs;
    private static Hashtable keyAliasMap;

    public DDPKCS12KeyStoreProviderIBM() {
        privateKeyCount = 0;
        entries = new Hashtable();
        keyList = new ArrayList();
        certs = new LinkedHashMap();
    }

    @Override
    public synchronized void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            if (inputStream == null) {
                return;
            }
            DerValue derValue = new DerValue(inputStream);
            DerInputStream derInputStream = derValue.toDerInputStream();
            BigInteger bigInteger = derInputStream.getInteger();
            if (bigInteger.intValue() != 3) {
                throw new IOException("PKCS12 keystore not in version 3 format");
            }
            entries.clear();
            ContentInfo contentInfo = new ContentInfo(derInputStream);
            ObjectIdentifier objectIdentifier = contentInfo.getContentType();
            if (!objectIdentifier.equals((ObjectIdentifier)ContentInfo.DATA_OID)) {
                throw new IOException("public key protected PKCS12 not supported");
            }
            byte[] byArray = contentInfo.getData();
            DerInputStream derInputStream2 = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream2.getSequence(2);
            int n2 = derValueArray.length;
            privateKeyCount = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                object6 = new DerInputStream(derValueArray[i2].toByteArray());
                object5 = new ContentInfo((DerInputStream)object6);
                object4 = object5.getContentType();
                object3 = null;
                if (object4.equals((ObjectIdentifier)ContentInfo.DATA_OID)) {
                    object3 = ((ContentInfo)object5).getData();
                } else if (object4.equals((ObjectIdentifier)ContentInfo.ENCRYPTED_DATA_OID)) {
                    Object object7;
                    if (cArray == null) continue;
                    object2 = object5.getContent().toDerInputStream();
                    object2.getInteger();
                    object = object2.getSequence(2);
                    if (!object[2].isContextSpecific((byte)0)) {
                        throw new IOException("encrypted content not present!");
                    }
                    byte by = 4;
                    if (object[2].isConstructed()) {
                        by = (byte)(by | 0x20);
                    }
                    object[2].resetTag(by);
                    object3 = object[2].getOctetString();
                    DerInputStream derInputStream3 = object[1].toDerInputStream();
                    ObjectIdentifier objectIdentifier2 = derInputStream3.getOID();
                    AlgorithmId algorithmId = new AlgorithmId(objectIdentifier2);
                    AlgorithmParameters algorithmParameters = this.parseAlgParameters(derInputStream3, algorithmId.getName());
                    try {
                        SecretKey secretKey = this.getPBEKey(cArray);
                        object7 = Cipher.getInstance(objectIdentifier2.toString());
                        ((Cipher)object7).init(2, (Key)secretKey, algorithmParameters);
                        object3 = ((Cipher)object7).doFinal((byte[])object3);
                    }
                    catch (Exception exception) {
                        object7 = new IOException("failed to decrypt safe contents entry: " + exception);
                        ((Throwable)object7).initCause(exception);
                        throw object7;
                    }
                } else {
                    throw new IOException("public key protected PKCS12 not supported");
                }
                object2 = new DerInputStream(object3);
                this.loadSafeContents((DerInputStream)object2, cArray);
            }
            if (cArray != null && derInputStream.available() > 0) {
                MacDataIBM macDataIBM = new MacDataIBM(derInputStream);
                try {
                    object6 = macDataIBM.getDigestAlgName().toUpperCase();
                    if (((String)object6).equals("SHA") || ((String)object6).equals("SHA1") || ((String)object6).equals("SHA-1")) {
                        object6 = "SHA1";
                    }
                    object5 = Mac.getInstance("HmacPBE" + (String)object6);
                    object4 = new PBEParameterSpec(macDataIBM.getSalt(), macDataIBM.getIterations());
                    object3 = this.getPBEKey(cArray);
                    ((Mac)object5).init((Key)object3, (AlgorithmParameterSpec)object4);
                    ((Mac)object5).update(byArray);
                    object2 = ((Mac)object5).doFinal();
                    if (!Arrays.equals(macDataIBM.getDigest(), (byte[])object2)) {
                        throw new SecurityException("Failed PKCS12 integrity checking");
                    }
                }
                catch (Exception exception) {
                    object5 = new IOException("Integrity check failed: " + exception);
                    ((Throwable)object5).initCause(exception);
                    throw object5;
                }
            }
            Object[] objectArray = keyList.toArray();
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                object5 = (KeyEntry)objectArray[i3];
                if (((KeyEntry)object5).keyId == null) continue;
                object4 = new ArrayList();
                object3 = new KeyId(((KeyEntry)object5).keyId);
                object2 = (X509Certificate)certs.get(object3);
                certs.remove(object3);
                if (object2 != null) {
                    certs.remove(((X509Certificate)object2).getSubjectX500Principal());
                }
                certs.remove(keyAliasMap.get(object3));
                while (object2 != null) {
                    ((ArrayList)object4).add(object2);
                    object = ((X509Certificate)object2).getIssuerX500Principal();
                    X500Principal x500Principal = ((X509Certificate)object2).getSubjectX500Principal();
                    if (((X500Principal)object).equals(((X509Certificate)object2).getSubjectX500Principal())) break;
                    object2 = (X509Certificate)certs.get(object);
                }
                if (((ArrayList)object4).size() <= 0) continue;
                ((KeyEntry)object5).chain = ((ArrayList)object4).toArray(new Certificate[((ArrayList)object4).size()]);
            }
            Set set = certs.entrySet();
            object5 = new HashSet();
            object4 = set.iterator();
            while (object4.hasNext()) {
                object3 = (Map.Entry)object4.next();
                object2 = null;
                object = object3.getValue();
                if (object5.contains(object)) continue;
                object5.add(object);
                object2 = object3.getKey() instanceof String ? (String)object3.getKey() : this.getUnfriendlyName();
                entries.put(object2, object);
            }
            certs.clear();
            keyList.clear();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Exception exception) {
            throw new IOException("Internal Error Parsing PKCS12 file.File is Bad or File is tampered or password is wrong");
        }
    }

    private void loadSafeContents(DerInputStream derInputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n2 = derValueArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DerInputStream derInputStream2;
            Object object5 = null;
            DerInputStream derInputStream3 = derValueArray[i2].toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream3.getOID();
            DerValue derValue = derInputStream3.getDerValue();
            if (!derValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + derValue.getTag());
            }
            derValue = derValue.getData().getDerValue();
            if (objectIdentifier.equals(PKCS8ShroudedKeyBag_OID)) {
                derInputStream2 = new KeyEntry();
                derInputStream2.protectedPrivKey = derValue.toByteArray();
                object5 = derInputStream2;
                ++privateKeyCount;
            } else if (objectIdentifier.equals(CertBag_OID)) {
                derInputStream2 = new DerInputStream(derValue.toByteArray());
                object4 = derInputStream2.getSequence(2);
                if (!object4[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + object4[1].getTag());
                }
                object3 = object4[1].getData().getDerValue();
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                object2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(object3.getOctetString()));
                object5 = object2;
            } else {
                if (!objectIdentifier.equals(KeyBag_OID)) continue;
                derInputStream2 = new KeyEntry();
                derInputStream2.protectedPrivKey = derValue.toByteArray();
                derInputStream2.isEncrypted = false;
                object5 = derInputStream2;
                ++privateKeyCount;
            }
            try {
                derInputStream2 = derInputStream3.getSet(2);
            }
            catch (IOException iOException) {
                derInputStream2 = null;
            }
            object4 = null;
            object3 = null;
            if (derInputStream2 != null) {
                for (int i3 = 0; i3 < ((DerValue[])derInputStream2).length; ++i3) {
                    DerValue[] derValueArray2;
                    object2 = new DerInputStream(derInputStream2[i3].toByteArray());
                    object = object2.getSequence(2);
                    ObjectIdentifier objectIdentifier2 = object[0].getOID();
                    DerInputStream derInputStream4 = new DerInputStream(object[1].toByteArray());
                    try {
                        derValueArray2 = derInputStream4.getSet(1);
                    }
                    catch (IOException iOException) {
                        throw new IOException("Attribute " + objectIdentifier2 + " should have a value " + iOException.getMessage());
                    }
                    if (objectIdentifier2.equals(PKCS9FriendlyName_OID)) {
                        object4 = derValueArray2[0].getBMPString().toString();
                        continue;
                    }
                    if (!objectIdentifier2.equals(PKCS9LocalKeyId_OID)) continue;
                    object3 = derValueArray2[0].getOctetString();
                }
            }
            if (object5 instanceof KeyEntry) {
                KeyEntry keyEntry = (KeyEntry)object5;
                if (object3 == null) {
                    if (privateKeyCount != 1) continue;
                    object3 = "01".getBytes("UTF8");
                }
                keyEntry.keyId = (byte[])object3;
                object2 = new String((byte[])object3, "UTF8");
                object = null;
                if (((String)object2).startsWith("Time ")) {
                    try {
                        object = new Date(Long.parseLong(((String)object2).substring(5)));
                    }
                    catch (Exception exception) {
                        object = null;
                    }
                }
                if (object == null) {
                    object = new Date();
                }
                keyEntry.date = object;
                keyList.add(keyEntry);
                if (object4 == null) {
                    object4 = this.getUnfriendlyName();
                }
                keyEntry.alias = object4;
                entries.put(((String)object4).toLowerCase(), keyEntry);
                continue;
            }
            if (!(object5 instanceof X509Certificate)) continue;
            X509Certificate x509Certificate = (X509Certificate)object5;
            if (object3 == null && privateKeyCount == 1 && i2 == 0) {
                object3 = "01".getBytes("UTF8");
            }
            object2 = null;
            if (object3 != null && !certs.containsKey(object2 = new KeyId((byte[])object3))) {
                certs.put(object2, object5);
            }
            if (object4 != null && !certs.containsKey(object4)) {
                certs.put(object4, object5);
                if (object2 != null) {
                    keyAliasMap.put(object2, object4);
                }
            }
            if ((object = x509Certificate.getSubjectX500Principal()) == null || certs.containsKey(object)) continue;
            certs.put(object, object5);
        }
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DerValue derValue;
        DerValue[] derValueArray;
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        byte[] byArray;
        Object v2 = entries.get(string.toLowerCase());
        PrivateKey privateKey = null;
        if (v2 == null || !(v2 instanceof KeyEntry)) {
            return null;
        }
        byte[] byArray2 = ((KeyEntry)v2).protectedPrivKey;
        if (!((KeyEntry)v2).isEncrypted) {
            byArray = byArray2;
        } else {
            try {
                encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray2);
                byte[] byArray3 = encryptedPrivateKeyInfo.getEncryptedData();
                derValueArray = encryptedPrivateKeyInfo.getAlgName();
                derValue = new DerValue(AlgorithmId.get((String)derValueArray).encode());
                object4 = derValue.toDerInputStream();
                object3 = object4.getOID();
                object2 = encryptedPrivateKeyInfo.getAlgParameters();
                object = this.getPBEKey(cArray);
                Cipher cipher = Cipher.getInstance(object3.toString());
                cipher.init(2, (Key)object, (AlgorithmParameters)object2);
                byArray = cipher.doFinal(byArray3);
            }
            catch (IOException iOException) {
                UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo: " + iOException);
                unrecoverableKeyException.initCause(iOException);
                throw unrecoverableKeyException;
            }
            catch (Exception exception) {
                UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Get Key failed: " + exception.getMessage());
                unrecoverableKeyException.initCause(exception);
                throw unrecoverableKeyException;
            }
        }
        try {
            object2 = new PKCS8EncodedKeySpec(byArray);
            object3 = new DerValue(byArray);
            encryptedPrivateKeyInfo = object3.toDerInputStream();
            encryptedPrivateKeyInfo.getInteger();
            derValueArray = encryptedPrivateKeyInfo.getSequence(2);
            derValue = new AlgorithmId(derValueArray[0].getOID());
            object4 = derValue.getName();
            object = KeyFactory.getInstance((String)object4);
            privateKey = ((KeyFactory)object).generatePrivate((KeySpec)object2);
        }
        catch (Exception exception) {
            object3 = new UnrecoverableKeyException("Get Key failed: " + exception.getMessage());
            ((Throwable)object3).initCause(exception);
            throw object3;
        }
        return privateKey;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        Object v2 = entries.get(string.toLowerCase());
        if (v2 != null && v2 instanceof KeyEntry) {
            if (((KeyEntry)v2).chain == null) {
                return null;
            }
            return (Certificate[])((KeyEntry)v2).chain.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        Object v2 = entries.get(string.toLowerCase());
        if (v2 != null && v2 instanceof KeyEntry) {
            if (((KeyEntry)v2).chain == null) {
                return null;
            }
            return ((KeyEntry)v2).chain[0];
        }
        if (v2 != null && v2 instanceof X509Certificate) {
            return (X509Certificate)v2;
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        Object v2 = entries.get(string.toLowerCase());
        if (v2 != null && v2 instanceof KeyEntry) {
            return new Date(((KeyEntry)v2).date.getTime());
        }
        return null;
    }

    @Override
    public synchronized void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Method is not supported");
    }

    private AlgorithmParameters parseAlgParameters(DerInputStream derInputStream, String string) throws IOException {
        AlgorithmParameters algorithmParameters = null;
        try {
            DerValue derValue;
            if (derInputStream.available() == 0) {
                derValue = null;
            } else {
                derValue = derInputStream.getDerValue();
                if (derValue.getTag() == 5) {
                    derValue = null;
                }
            }
            if (derValue != null) {
                algorithmParameters = AlgorithmParameters.getInstance(string);
                algorithmParameters.init(derValue.toByteArray());
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("parseAlgParameters failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return algorithmParameters;
    }

    private SecretKey getPBEKey(char[] cArray) throws IOException {
        SecretKey secretKey = null;
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("getSecretKey failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return secretKey;
    }

    @Override
    public synchronized void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        throw new KeyStoreException("Method is not supported");
    }

    @Override
    public synchronized void engineDeleteEntry(String string) throws KeyStoreException {
        entries.remove(string.toLowerCase());
    }

    public Enumeration engineAliases() {
        return entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return entries.containsKey(string.toLowerCase());
    }

    @Override
    public int engineSize() {
        return entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        Object v2 = entries.get(string.toLowerCase());
        return v2 != null && v2 instanceof KeyEntry;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        Object v2 = entries.get(string.toLowerCase());
        return v2 != null && v2 instanceof X509Certificate;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        Certificate certificate2 = null;
        Enumeration enumeration = entries.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v2 = entries.get(string);
            if (!(v2 instanceof KeyEntry)) continue;
            if (((KeyEntry)v2).chain != null) {
                certificate2 = ((KeyEntry)v2).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    @Override
    public synchronized void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    private String getUnfriendlyName() {
        return String.valueOf(++counter);
    }

    @Override
    public synchronized void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Method is not supported");
    }

    static {
        OLD_SIGNED_DATA_OID = ObjectIdentifier.newInternal((int[])OLD_SDATA);
        OLD_DATA_OID = ObjectIdentifier.newInternal((int[])OLD_DATA);
        counter = 0;
        privateKeyCount = 0;
        entries = new Hashtable();
        keyList = new ArrayList();
        certs = new LinkedHashMap();
        keyAliasMap = new Hashtable();
        try {
            PKCS8ShroudedKeyBag_OID = new ObjectIdentifier(keyBag);
            CertBag_OID = new ObjectIdentifier(certBag);
            KeyBag_OID = new ObjectIdentifier(unshroudedKeyBag);
            PKCS9FriendlyName_OID = new ObjectIdentifier(pkcs9Name);
            PKCS9LocalKeyId_OID = new ObjectIdentifier(pkcs9KeyId);
            PKCS9CertType_OID = new ObjectIdentifier(pkcs9certType);
            pbeWithSHAAnd40BitRC2CBC_OID = new ObjectIdentifier(pbeWithSHAAnd40BitRC2CBC);
            pbeWithSHAAnd3KeyTripleDESCBC_OID = new ObjectIdentifier(pbeWithSHAAnd3KeyTripleDESCBC);
            PKCS7_OID = ObjectIdentifier.newInternal((int[])pkcs7);
            DATA_OID = ObjectIdentifier.newInternal((int[])data);
            SIGNED_DATA_OID = ObjectIdentifier.newInternal((int[])sdata);
            ENVELOPED_DATA_OID = ObjectIdentifier.newInternal((int[])edata);
            SIGNED_AND_ENVELOPED_DATA_OID = ObjectIdentifier.newInternal((int[])sedata);
            DIGESTED_DATA_OID = ObjectIdentifier.newInternal((int[])ddata);
            ENCRYPTED_DATA_OID = ObjectIdentifier.newInternal((int[])crdata);
            NETSCAPE_CERT_SEQUENCE_OID = ObjectIdentifier.newInternal((int[])nsdata);
            TIMESTAMP_TOKEN_INFO_OID = ObjectIdentifier.newInternal((int[])tstInfo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class KeyId {
        byte[] keyId;

        public int hashCode() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.keyId.length; ++i2) {
                n2 += this.keyId[i2];
            }
            return n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyId)) {
                return false;
            }
            KeyId keyId = (KeyId)object;
            return Arrays.equals(this.keyId, keyId.keyId);
        }

        KeyId(byte[] byArray) {
            this.keyId = byArray;
        }
    }

    private static class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        boolean isEncrypted = true;
        Certificate[] chain;
        byte[] keyId;
        String alias;

        private KeyEntry() {
        }
    }
}

