/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.presentation;

import coldfusion.document.DocumentMargin;
import coldfusion.document.DocumentPageLayout;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.DocumentWriter;
import coldfusion.presentation.PowerPointWriter;
import com.lowagie.text.DocumentException;
import ice.storm.print.StormPageFormat;
import ice.util.unit.PointUnit;
import ice.util.unit.Unit;
import java.awt.Color;
import java.io.OutputStream;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;

public class PPTDocumentProperties
extends DocumentProperties {
    private PowerPointWriter writer;
    private HSLFGroupShape group;
    private HSLFSlideShow ppt;
    private String title;
    private Color color;

    public PPTDocumentProperties(DocumentPageLayout pageLayout, OutputStream out, boolean collectText) {
        super(pageLayout);
    }

    public PPTDocumentProperties(DocumentPageLayout pageLayout, HSLFSlideShow ppt, String title, Color color) {
        super(pageLayout);
        this.ppt = ppt;
        this.title = title;
        this.color = color;
    }

    protected void setupPageFormat() {
        this.pageFormat = new StormPageFormat();
        this.pageFormat.setPageSize((Unit)new PointUnit(this.pageLayout.getPagewidth()), (Unit)new PointUnit(this.pageLayout.getPageheight()));
        DocumentMargin margin = this.pageLayout.getMargin();
        this.pageFormat.setMargin((Unit)new PointUnit(margin.getTop()), 1);
        this.pageFormat.setMargin((Unit)new PointUnit(margin.getBottom()), 3);
        this.pageFormat.setMargin((Unit)new PointUnit(margin.getLeft()), 2);
        this.pageFormat.setMargin((Unit)new PointUnit(margin.getRight()), 4);
    }

    public String getFormat() {
        return "ppt";
    }

    public synchronized DocumentWriter getWriter() throws DocumentException {
        if (this.writer == null) {
            this.writer = new PowerPointWriter(this.ppt, this.title, this.color);
        }
        return this.writer;
    }
}

