/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.webkit;

import coldfusion.document.webkit.core.DocumentSettingsWebkit;
import coldfusion.document.webkit.core.HtmlToPdfMargin;
import coldfusion.document.webkit.core.HtmlToPdfPageLayout;
import coldfusion.log.CFLogs;
import coldfusion.pdfg.jetty.PDFGServer;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.net.ResolvePage;
import coldfusion.tools.IPUtils;
import coldfusion.vfs.VFSFileFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;

public final class PDFgRequestUtil {
    public static final int PIXEL_CONVERT_VALUE = 72;
    private static final String _CF_PDF = "_cf_pdf";
    public static final String SLASH = "/";
    private static final String COLON_SLASH_SLASH = "://";
    private static final String COLON = ":";
    public static final String FILE_URL = "file:///";
    public static final String SERVLETPATH = "CFPDFServiceFileServlet";
    public static final String TEMP_WEBKIT_FOLDER = "CFPDFServiceFileServlet/_cf_pdf";
    public static final String PDFFILE = "PDFFILE_";
    public static final String HTML = ".html";
    private static final int PDFG_DEFAULT_MARGIN_TOP = 0;
    private static final int PDFG_DEFAULT_MARGIN_BOTTOM = 0;
    private static final int PDFG_DEFAULT_MARGIN_LEFT = 0;
    private static final int PDFG_DEFAULT_MARGIN_RIGHT = 0;
    private static final String JETTY_URL;
    private static final String JETTY_PROCOL_PREFIX;
    private static final String JETTY_TEMPFOLDER_URL;
    private static final String LOCAL_FILE_URL_PREFIX;
    private static String jettyProtocol;
    private static int jettyPort;
    private static String jettyIPAddress;
    private static boolean useAnyNetworkAddress;
    private static Random r;

    public static void writeToZipFile(String content, String zipFilePath) throws FileNotFoundException, IOException {
        File f = new File(zipFilePath);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
        ZipEntry e = new ZipEntry("index.html");
        out.putNextEntry(e);
        byte[] data = content.getBytes();
        out.write(data, 0, data.length);
        out.closeEntry();
        out.close();
    }

    public static String writeContentToTempFile(final Object content, final String encoding) {
        if (System.getSecurityManager() == null) {
            return PDFgRequestUtil._writeContentToTempFile(content, encoding);
        }
        try {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return PDFgRequestUtil._writeContentToTempFile(content, encoding);
                }
            });
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _writeContentToTempFile(Object content, String encoding) {
        File htmlFile;
        String htmlFileName = null;
        File tempDir = new File(ServiceFactory.getRuntimeService().getTempCacheDirectory(), TEMP_WEBKIT_FOLDER);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        if ((htmlFile = new File(tempDir, htmlFileName = PDFFILE + r.nextInt() + HTML)).exists()) {
            htmlFileName = PDFFILE + r.nextInt() + "1" + HTML;
            htmlFile = new File(tempDir, htmlFileName);
        }
        BufferedWriter htmlout = null;
        OutputStream fos = null;
        try {
            htmlFile.createNewFile();
            if (content instanceof byte[]) {
                byte[] bytes = (byte[])content;
                fos = VFSFileFactory.getOutputStream((File)htmlFile);
                fos.write(bytes, 0, bytes.length);
            } else if (content instanceof String) {
                htmlout = encoding != null && !encoding.equals("") ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), encoding)) : new BufferedWriter(new FileWriter(htmlFile));
                htmlout.write((String)content);
            }
        }
        catch (IOException e) {
            htmlFileName = null;
        }
        finally {
            try {
                if (htmlout != null) {
                    htmlout.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        return htmlFileName;
    }

    public static void deleteTempHtmlFile(final String htmlFileName) {
        if (System.getSecurityManager() == null) {
            PDFgRequestUtil._deleteTempHtmlFile(htmlFileName);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PDFgRequestUtil._deleteTempHtmlFile(htmlFileName);
                    return null;
                }
            });
        }
    }

    private static void _deleteTempHtmlFile(String htmlFileName) {
        String dir = ServiceFactory.getRuntimeService().getTempCacheDirectory() + File.separator + TEMP_WEBKIT_FOLDER;
        File f = new File(dir, htmlFileName);
        if (f != null && f.exists()) {
            f.delete();
        }
    }

    public static void setTempHtmlNBaseURL(HttpServletRequest request, DocumentSettingsWebkit pdfSettings, String htmlFileName) {
        PDFgRequestUtil.setTempHtmlNBaseURL(request, pdfSettings, htmlFileName, false);
    }

    public static void setTempHtmlNBaseURL(HttpServletRequest request, DocumentSettingsWebkit pdfSettings, String htmlFileName, boolean isLocal) {
        String baseurl = request.getRequestURL().toString();
        ResolvePage rp = new ResolvePage();
        if ((baseurl = rp.prepareUrl(baseurl)) != null && !baseurl.endsWith(SLASH)) {
            baseurl = baseurl + SLASH;
        }
        pdfSettings.setBaseURL(baseurl);
        PDFgRequestUtil.setPageURL(pdfSettings, htmlFileName, isLocal);
    }

    private static void setPageURL(DocumentSettingsWebkit pdfSettings, String htmlFileName, boolean isLocal) {
        if (isLocal) {
            pdfSettings.setPageURL(LOCAL_FILE_URL_PREFIX + htmlFileName);
        } else if (jettyIPAddress != null) {
            pdfSettings.setPageURL(JETTY_URL + htmlFileName);
        } else {
            if (!useAnyNetworkAddress && jettyIPAddress == null) {
                throw new PdfgRunningonLocalhostException();
            }
            String ipAddress = null;
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if ((ipAddress == null || IPUtils.isLocalHost((String)ipAddress)) && (ipAddress = IPUtils.getValidLocalAddress()) == null) {
                throw new PdfgUndeterminedIPAddressException();
            }
            pdfSettings.setPageURL(JETTY_PROCOL_PREFIX + ipAddress + JETTY_TEMPFOLDER_URL + htmlFileName);
        }
    }

    public static void validateMargins(HtmlToPdfPageLayout pageLayout, HtmlToPdfMargin pageMargin) {
        double dRight;
        double pheight = pageLayout.getPageheight();
        double pwidth = pageLayout.getPagewidth();
        double dTop = pageMargin.getTop() == -1.0 ? 0.0 : pageMargin.getTop();
        double dBottom = pageMargin.getBottom() == -1.0 ? 0.0 : pageMargin.getBottom();
        double dLeft = pageMargin.getLeft() == -1.0 ? 0.0 : pageMargin.getLeft();
        double d = dRight = pageMargin.getRight() == -1.0 ? 0.0 : pageMargin.getRight();
        if (dTop + dBottom > pheight) {
            throw new HtmlToPdfMargin.InvalidMarginException("margintop=" + dTop + ", marginbottom=" + dBottom, "pageheight=" + pheight);
        }
        if (dLeft + dRight > pwidth) {
            throw new HtmlToPdfMargin.InvalidMarginException("marginleft=" + dLeft + ", marginright=" + dRight, "pagewidth=" + pwidth);
        }
    }

    static {
        jettyProtocol = null;
        jettyPort = 0;
        useAnyNetworkAddress = false;
        r = new Random();
        PDFGServer instance = null;
        try {
            instance = System.getSecurityManager() == null ? PDFGServer.getInstance() : AccessController.doPrivileged(new PrivilegedAction<PDFGServer>(){

                @Override
                public PDFGServer run() {
                    return PDFGServer.getInstance();
                }
            });
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Object)"Unable to get an instance of Monitoring server", (Throwable)e);
        }
        jettyProtocol = instance.getProtocol();
        jettyPort = instance.getPort();
        String ipAddress = instance.getHost();
        if (ipAddress != null && ipAddress.trim().length() > 0) {
            if (IPUtils.isUnboundedAddress((String)(ipAddress = ipAddress.trim()))) {
                useAnyNetworkAddress = true;
            } else if (!IPUtils.isLocalHost((String)ipAddress)) {
                jettyIPAddress = ipAddress;
            }
        } else {
            useAnyNetworkAddress = true;
        }
        if (jettyIPAddress != null) {
            JETTY_URL = jettyProtocol + COLON_SLASH_SLASH + jettyIPAddress + COLON + jettyPort + SLASH + TEMP_WEBKIT_FOLDER + SLASH;
            JETTY_PROCOL_PREFIX = null;
            JETTY_TEMPFOLDER_URL = null;
        } else {
            JETTY_PROCOL_PREFIX = jettyProtocol + COLON_SLASH_SLASH;
            JETTY_TEMPFOLDER_URL = COLON + jettyPort + SLASH + TEMP_WEBKIT_FOLDER + SLASH;
            JETTY_URL = null;
        }
        LOCAL_FILE_URL_PREFIX = FILE_URL + ServiceFactory.getRuntimeService().getTempCacheDirectory() + File.separator + TEMP_WEBKIT_FOLDER + File.separator;
    }

    public static class PdfgRunningonLocalhostException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class PdfgUndeterminedIPAddressException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }
}

