/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.session.external;

import coldfusion.log.CFLogs;
import coldfusion.monitor.memory.SessionMemoryMonitor;
import coldfusion.runtime.SessionKeyObject;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.session.AbstractSessionStorage;
import coldfusion.runtime.session.SessionEndEventInvoker;
import coldfusion.runtime.session.external.SessionMetadata;
import coldfusion.runtime.session.external.SessionSerializer;
import coldfusion.session.NodeDiscoveryManager;
import coldfusion.session.external.RedisConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisSessionStorage
extends AbstractSessionStorage {
    private static final String SESSION_METADATA_BASE_KEY = "cf:sessions:metadata";
    private static final String SESSION_KEY_LIST = "cf:sessions:keylist";
    private static final String NODE_SESSION_LIST = "cf:sessions:nodes:";
    private static final String NODE_TIMEOUT_LIST = "cf:timeout:nodes:";
    private static final String SESSION_TIMEOUT_BASE_KEY = "cf:sessions:timeout";
    private JedisPool connectionPool = null;
    NodeDiscoveryManager nodeDiscoveryManager;
    private String node_seession_set_key;
    private String node_timeout_set_key;
    private RedisConfig redisConfig = null;
    private ConcurrentHashMap<String, Object> sessionTimeouts = new ConcurrentHashMap();
    private int expiredSessionCount;
    private boolean scriptExist = false;
    private static final String getSessionCountScript = "local count=0 local s={} local r={} r=redis.call('smembers','cf:sessions:keylist') for k,v in pairs(r) do s=redis.call('hgetall',v) for _ in pairs(s) do count=count+1 end end return count";
    private static final String getActiveSessionCountScript = "local count=0 local s=nil local r={} r=redis.call('smembers','cf:sessions:keylist') for k,v in pairs(r) do s=redis.pcall('hget',v,ARGV[1]) if type(s)=='string' then count=count+1 end end return count";
    private String getSessionCountScriptSha1Digest = "4f60d91b08e6c2cdd22ad79959f9c345b028f3fa";
    private String getActiveSessionCountScriptSha1Digest = "5a30de33eba6943cef53b052a925711b7054ddbb";

    public RedisSessionStorage(RedisConfig config, NodeDiscoveryManager dm) {
        this.connectionPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), config.getHost(), config.getPort(), config.getTimeout(), config.getPassword(), config.getDatabase());
        this.redisConfig = config;
        this.expiredSessionCount = 0;
        config.setPassword(null);
        this.nodeDiscoveryManager = dm;
        this.node_seession_set_key = this.getNodeSessionListKey(this.nodeDiscoveryManager.getNode().getName());
        this.node_timeout_set_key = this.getNodeTimeoutListKey(this.nodeDiscoveryManager.getNode().getName());
        Jedis jedis = this.connectionPool.getResource();
        Map redisSessionTimeouts = jedis.hgetAll(this.node_timeout_set_key);
        for (Map.Entry entry : redisSessionTimeouts.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                this.sessionTimeouts.put(key, Long.parseLong(value));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public RedisConfig getRedisConfig() {
        return this.redisConfig;
    }

    public void test(String host, int port, String password, String ... args) {
        RedisSessionStorage.testConnection(host, port, password, false, args);
    }

    public void test(String host, int port, String password, boolean isCluster, String ... args) {
        RedisSessionStorage.testConnection(host, port, password, isCluster, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testConnection(String host, int port, String password, boolean isCluster, String ... args) {
        if (!isCluster) {
            try (Jedis connection = null;){
                connection = new Jedis(host, port);
                if (password != null && !password.trim().equalsIgnoreCase("")) {
                    connection.auth(password);
                }
                connection.ping();
                connection.set("test", "test");
                connection.del("test");
            }
        }
        JedisCluster con = null;
        try {
            HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
            jedisClusterNode.add(new HostAndPort(host, port));
            con = new JedisCluster(jedisClusterNode, (GenericObjectPoolConfig)new JedisPoolConfig());
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (IOException e) {
                    CFLogs.SERVER_LOG.error((Throwable)e);
                }
            }
        }
    }

    public SessionScope getSession(String appName, String key) throws IOException {
        try (Jedis jedis = this.connectionPool.getResource();){
            SessionScope sessionScope = this.getSession(appName, key, jedis);
            return sessionScope;
        }
    }

    private SessionScope getSession(String appName, String key, Jedis jedis) throws IOException {
        byte[] serializedSession = jedis.hget(key.getBytes(), appName.getBytes());
        if (serializedSession != null) {
            return (SessionScope)SessionSerializer.deSerialize((byte[])serializedSession);
        }
        return null;
    }

    public void setSession(String appName, String key, SessionScope s) throws IOException {
        try (Jedis jedis = this.connectionPool.getResource();){
            jedis.hset(key.getBytes(), appName.getBytes(), SessionSerializer.serialize((Object)s));
            SessionMetadata metadata = new SessionMetadata(System.currentTimeMillis(), s.getMaxInactiveInterval() * 1000L);
            jedis.hset(this.getSessionMetadataKey(key), appName.getBytes(), SessionSerializer.serialize((Object)metadata));
            long ttl = System.currentTimeMillis() / 1000L + s.getMaxInactiveInterval();
            String sessionKey = this.getSessionTimeoutKey(key).substring(20) + "_" + appName;
            this.sessionTimeouts.put(sessionKey, ttl);
            jedis.hset(this.node_timeout_set_key, sessionKey, String.valueOf(ttl));
            jedis.sadd(SESSION_KEY_LIST, new String[]{key});
            jedis.sadd(this.node_seession_set_key, new String[]{key});
        }
    }

    private String getNodeSessionListKey(String key) {
        return NODE_SESSION_LIST + key;
    }

    private String getNodeTimeoutListKey(String key) {
        return NODE_TIMEOUT_LIST + key;
    }

    private byte[] getSessionMetadataKey(String key) {
        return ("cf:sessions:metadata:" + key).getBytes();
    }

    private String getSessionTimeoutKey(String key) {
        return "cf:sessions:timeout:" + key;
    }

    public void remove(String key, String appName) {
        try (Jedis jedis = this.connectionPool.getResource();){
            this.remove(key, appName, jedis);
        }
    }

    private void remove(String key, String appName, Jedis jedis) {
        jedis.hdel(this.getSessionMetadataKey(key), (byte[][])new byte[][]{appName.getBytes()});
        jedis.hdel(key.getBytes(), (byte[][])new byte[][]{appName.getBytes()});
        if (jedis.hlen(key.getBytes()) <= 0L) {
            jedis.srem(SESSION_KEY_LIST, new String[]{key});
            jedis.srem(this.node_seession_set_key, new String[]{key});
            jedis.hdel(this.node_timeout_set_key, new String[]{key + "_" + appName});
            this.sessionTimeouts.remove(key + "_" + appName);
        }
    }

    private SessionScope getAndRemove(String key, String appName, Jedis jedis) {
        SessionScope sessionScope = null;
        try {
            sessionScope = this.getSession(appName, key, jedis);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.remove(key, appName, jedis);
        return sessionScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SessionEndEventInvoker> cleanUp() {
        Iterator<String> nodes;
        boolean redisDebug = false;
        String redisPerfCheck = System.getProperty("redisperfcheck");
        if (redisPerfCheck != null && Boolean.valueOf(redisPerfCheck).booleanValue()) {
            redisDebug = true;
        }
        if ((nodes = this.nodeDiscoveryManager.getNodesForSessionCleanup()) != null && nodes.hasNext()) {
            Jedis jedis = this.connectionPool.getResource();
            try {
                while (nodes.hasNext()) {
                    String node = nodes.next();
                    Map<String, Object> nodeSessionTimeouts = null;
                    nodeSessionTimeouts = !node.equalsIgnoreCase(this.nodeDiscoveryManager.getNode().getName()) ? jedis.hgetAll(this.node_timeout_set_key) : this.sessionTimeouts;
                    long currentTimeMillis = System.currentTimeMillis();
                    long currentTimeSeconds = currentTimeMillis / 1000L;
                    for (Map.Entry<String, Object> sessionEntry : nodeSessionTimeouts.entrySet()) {
                        int firstUnderScoreIndex;
                        String sessionKeyWithApp = sessionEntry.getKey();
                        Object timeoutObj = sessionEntry.getValue();
                        long timeout = timeoutObj instanceof String ? Long.parseLong((String)timeoutObj) : (Long)timeoutObj;
                        if (timeout >= currentTimeSeconds || (firstUnderScoreIndex = sessionKeyWithApp.indexOf(95)) < 0 || sessionKeyWithApp.length() < firstUnderScoreIndex + 1) continue;
                        int appSplitIndex = sessionKeyWithApp.indexOf("_", firstUnderScoreIndex + 1);
                        if (appSplitIndex == -1) {
                            appSplitIndex = firstUnderScoreIndex;
                        }
                        String sessionKey = sessionKeyWithApp.substring(0, appSplitIndex);
                        String appName = appSplitIndex < 0 || sessionKeyWithApp.length() < appSplitIndex + 1 ? "" : sessionKeyWithApp.substring(appSplitIndex + 1);
                        SessionScope sessionScope = this.getAndRemove(sessionKey, appName, jedis);
                        ++this.expiredSessionCount;
                        this.invokeSessionEnd(sessionScope, appName);
                    }
                    if (!redisDebug) continue;
                    CFLogs.SERVER_LOG.info((Object)("Local Timedout sessions dealt with in :" + (System.currentTimeMillis() - currentTimeMillis) + " milliseconds"));
                }
            }
            finally {
                this.connectionPool.returnResourceObject((Object)jedis);
            }
        }
        return null;
    }

    public int getActiveSessionCount(String appName) throws IOException {
        if (appName == null) {
            return this.getSessionCount();
        }
        return this._getSessionCount(this.getActiveSessionCountScriptSha1Digest, getActiveSessionCountScript, Collections.emptyList(), Collections.singletonList(appName));
    }

    private int _getSessionCount(String sha1Digest, String script, List<String> keys, List<String> args) {
        try (Jedis jedis = null;){
            jedis = this.connectionPool.getResource();
            if (!this.scriptExist) {
                this.loadScripts(jedis);
            }
            int n = ((Long)jedis.evalsha(sha1Digest, keys, args)).intValue();
            return n;
        }
    }

    private void loadScripts(Jedis jedis) {
        jedis.scriptLoad(getSessionCountScript);
        jedis.scriptLoad(getActiveSessionCountScript);
        this.scriptExist = true;
    }

    public ConcurrentMap<String, Object> getApplicationSessionMap(String key) throws IOException {
        try (Jedis jedis = this.connectionPool.getResource();){
            Map sessionsAppsKeys = jedis.hgetAll(key.getBytes());
            if (sessionsAppsKeys != null) {
                Set appNameKeys = sessionsAppsKeys.keySet();
                ConcurrentHashMap<String, Object> appSessionMap = new ConcurrentHashMap<String, Object>();
                for (byte[] app : appNameKeys) {
                    appSessionMap.put(new String(app), SessionSerializer.deSerialize((byte[])((byte[])sessionsAppsKeys.get(app))));
                }
                ConcurrentHashMap<String, Object> concurrentHashMap = appSessionMap;
                return concurrentHashMap;
            }
        }
        return null;
    }

    public ConcurrentMap<String, Object> getAppSessions(String appName) throws IOException {
        ConcurrentHashMap<String, Object> appSessions = new ConcurrentHashMap<String, Object>();
        try (Jedis jedis = this.connectionPool.getResource();){
            Set sessionKeys = jedis.smembers(SESSION_KEY_LIST);
            if (sessionKeys != null) {
                SessionScope session = null;
                for (String sessionKey : sessionKeys) {
                    byte[] obj = jedis.hget(sessionKey.getBytes(), appName.getBytes());
                    if (obj == null) continue;
                    session = (SessionScope)SessionSerializer.deSerialize((byte[])obj);
                    appSessions.put(session.getTrackerSessionId(), session);
                }
            }
        }
        return appSessions;
    }

    public void setAppSession(String key, ConcurrentMap<String, Object> sessions) throws IOException {
        if (sessions != null && sessions.size() > 0) {
            for (Map.Entry sessionEntry : sessions.entrySet()) {
                this.setSession((String)sessionEntry.getKey(), key, (SessionScope)sessionEntry.getValue());
            }
        }
    }

    public int getSessionCount() throws IOException {
        return this._getSessionCount(this.getSessionCountScriptSha1Digest, getSessionCountScript, Collections.emptyList(), Collections.emptyList()) / 2;
    }

    public Set<SessionKeyObject> getSessionKeyObjects() {
        return null;
    }

    public Set<String> getSessionKeys() {
        try (Jedis jedis = this.connectionPool.getResource();){
            Set set = jedis.hkeys(SESSION_METADATA_BASE_KEY);
            return set;
        }
    }

    public boolean sessionExists(String m_cfid, String m_cftoken) {
        try (Jedis jedis = this.connectionPool.getResource();){
            boolean bl = jedis.sismember(SESSION_KEY_LIST, this.getKey(m_cfid, m_cftoken));
            return bl;
        }
    }

    private String getKey(SessionScope scope) {
        return this.getKey((String)scope.get((Object)"cfid"), (String)scope.get((Object)"cftoken"));
    }

    private String getKey(String m_cfid, String m_cftoken) {
        StringBuilder builder = new StringBuilder();
        builder.append(m_cfid).append('_').append(m_cftoken);
        return builder.toString();
    }

    public boolean isMomoryTrackingSupported() {
        return false;
    }

    public SessionMemoryMonitor getSessionMemoryMonitor() {
        return null;
    }

    public void updateLastAccess(SessionScope session) throws IOException {
        try (Jedis jedis = this.connectionPool.getResource();){
            jedis.hset(this.getKey(session).getBytes(), session.getAppName().getBytes(), SessionSerializer.serialize((Object)session));
            SessionMetadata metadata = new SessionMetadata(System.currentTimeMillis(), session.getMaxInactiveInterval() * 1000L);
            jedis.hset(this.getSessionMetadataKey(this.getKey(session)), session.getAppName().getBytes(), SessionSerializer.serialize((Object)metadata));
            long ttl = System.currentTimeMillis() / 1000L + session.getMaxInactiveInterval();
            String sessionKey = this.getSessionTimeoutKey(this.getKey(session)).substring(20) + "_" + session.getAppName();
            this.sessionTimeouts.put(sessionKey, ttl);
            jedis.hset(this.node_timeout_set_key, sessionKey, String.valueOf(ttl));
        }
        catch (Exception e) {
            CFLogs.SECURITY_LOG.error((Object)"Unable to save session to redis", (Throwable)e);
        }
    }

    public int getExpiredSessionCount() throws IOException {
        return this.expiredSessionCount;
    }

    public void clearExpiredSessionCount() {
        this.expiredSessionCount = 0;
    }
}

