/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.CFDebuggerExceptions;
import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.CFDebuggerUtils;
import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.debugger.DebugEventHandler;
import coldfusion.debugger.ExceptionBreakpointHandler;
import coldfusion.debugger.FailedBPCheckerTask;
import coldfusion.debugger.FailedBPInfo;
import coldfusion.debugger.JVMDebugThread;
import coldfusion.debugger.JVMDebugThreadManager;
import coldfusion.debugger.LocatableEventWrapper;
import coldfusion.debugger.events.CFBreakpointEvent;
import coldfusion.debugger.events.CFBreakpointSetEvent;
import coldfusion.debugger.events.CFDebugEvent;
import coldfusion.debugger.events.CFDisconnectEvent;
import coldfusion.debugger.events.CFExceptionBreakpointEvent;
import coldfusion.debugger.events.CFExceptionEvent;
import coldfusion.debugger.events.CFStepEvent;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.BreakpointRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;

public class ClientDebugSession {
    private String sessionId = null;
    private HashMap breakpoints = new HashMap();
    private HashMap pendingBPs = new HashMap();
    private ArrayList debugEventQueue = new ArrayList();
    private ArrayList syncStepEventQueue = new ArrayList();
    boolean syncronousStepRequest = false;
    String syncStepWaitingThreadName = null;
    private boolean isClosed = false;
    private String scopeFilter = null;
    private boolean returnVMThreads = true;
    HashMap skipBpMap = new HashMap();
    String[] watchVariables = null;
    boolean currentCfPageComplete = false;
    private Location lastLocation = null;
    private String lastExecutingThread = "";
    private Map lastFetchFlagMap = null;
    static final int timeToWaitForCheckingFailedBP = 4000;
    private ArrayList failedBPInfoList = new ArrayList();
    private Timer bpCheckTimer = null;
    private FailedBPCheckerTask bpCheckTask = null;
    private CFJVMDebugManager debugMgr = null;
    private boolean remoteSession = false;
    private final String lastLocationMutex = "";
    private boolean breakOnException = false;

    public ClientDebugSession(String sessionId, CFJVMDebugManager dbgMgr) {
        this.sessionId = sessionId;
        this.debugMgr = dbgMgr;
        this.startFailedBPCheckerTimer();
    }

    public void addBreakpoint(String cfmlPath, int lineNum) {
        this.addToBPHashMap(cfmlPath, lineNum, this.breakpoints);
        this.removePendingBreakpoint(cfmlPath, lineNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkipBreakpoint(String cfmlPath, String threadName, int lineNum) throws Throwable {
        HashMap hashMap = this.skipBpMap;
        synchronized (hashMap) {
            Object obj = this.skipBpMap.get(cfmlPath);
            Integer lineObj = new Integer(lineNum);
            if (obj == null) {
                HashMap map = new HashMap();
                this.skipBpMap.put(cfmlPath, map);
                ArrayList<Integer> bps = new ArrayList<Integer>();
                bps.add(lineObj);
                obj = bps;
                map.put(threadName, obj);
                return;
            }
            HashMap threadMap = (HashMap)obj;
            if ((obj = threadMap.get(threadName)) == null) {
                ArrayList<Integer> bps = new ArrayList<Integer>();
                bps.add(lineObj);
                obj = bps;
                threadMap.put(threadName, bps);
                return;
            }
            ArrayList bps = (ArrayList)obj;
            if (bps.indexOf(lineObj) == -1) {
                bps.add(lineObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSkipBreakpoint(String cfmlPath, String threadName, int lineNum, boolean removeSkip) throws Throwable {
        HashMap hashMap = this.skipBpMap;
        synchronized (hashMap) {
            Object obj = this.skipBpMap.get(cfmlPath);
            if (obj == null) {
                return false;
            }
            HashMap threadMap = (HashMap)obj;
            if ((obj = threadMap.get(threadName)) == null) {
                return false;
            }
            Integer lineObj = new Integer(lineNum);
            ArrayList bps = (ArrayList)obj;
            int index = -1;
            index = bps.indexOf(lineObj);
            if (index != -1) {
                if (removeSkip) {
                    bps.remove(index);
                }
                return true;
            }
            return false;
        }
    }

    public boolean isBreakpointSet(String cfmlPath, int lineNum) {
        return this.isBreakpointSet(cfmlPath, lineNum, false);
    }

    public boolean isBreakpointSet(String cfmlPath, int lineNum, boolean searchPendingBps) {
        boolean ret = this.searchBreakpointMap(cfmlPath, lineNum, this.breakpoints);
        if (ret || !searchPendingBps) {
            return ret;
        }
        return this.searchBreakpointMap(cfmlPath, lineNum, this.pendingBPs);
    }

    public void removeBreakpoint(String cfmlPath, int lineNum, VirtualMachine vm) throws Throwable {
        if (!this.removeFromBreakpointMap(cfmlPath, lineNum, vm, this.breakpoints)) {
            this.removeFromBreakpointMap(cfmlPath, lineNum, null, this.pendingBPs);
        }
    }

    public void removeAllBreakpoints(VirtualMachine vm) throws Throwable {
        if (this.breakpoints == null || this.breakpoints.size() == 0) {
            return;
        }
        for (String cfmlPath : this.breakpoints.keySet()) {
            ArrayList l = (ArrayList)this.breakpoints.get(cfmlPath);
            for (int i = l.size() - 1; i >= 0; --i) {
                Integer lineNumber = (Integer)l.get(i);
                this.removeBreakpoint(cfmlPath, lineNumber, vm);
            }
        }
        this.breakpoints.clear();
        this.breakpoints = new HashMap();
        this.pendingBPs = new HashMap();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDebuggerEvents(Map fetchFlags, long timeOut) {
        if (this.isClosed) {
            return null;
        }
        this.lastFetchFlagMap = fetchFlags;
        ArrayList arrayList = this.debugEventQueue;
        synchronized (arrayList) {
            if (this.debugEventQueue.size() > 0) {
                return this.processDebugEventQueue(fetchFlags, timeOut);
            }
            try {
                this.debugEventQueue.wait(timeOut);
            }
            catch (InterruptedException ex) {
                CFDebuggerLogger.log(ex);
            }
        }
        if (this.isClosed) {
            return null;
        }
        return this.processDebugEventQueue(fetchFlags, timeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList processDebugEventQueue(Map fetchFlags, long timeOut) {
        if (this.debugEventQueue.size() == 0) {
            return this.getDebuggerEvents(fetchFlags, timeOut);
        }
        ArrayList tmpEvtQueue = new ArrayList();
        ArrayList arrayList = this.debugEventQueue;
        synchronized (arrayList) {
            while (this.debugEventQueue.size() > 0) {
                tmpEvtQueue.add(this.debugEventQueue.remove(0));
            }
        }
        ArrayList<CFDebugEvent> evts = new ArrayList<CFDebugEvent>();
        while (tmpEvtQueue.size() > 0) {
            Object evtObj = tmpEvtQueue.remove(0);
            if (evtObj instanceof Event) {
                CFDebugEvent de = this.wrapEvent((Event)evtObj, fetchFlags);
                if (de == null) continue;
                evts.add(de);
                continue;
            }
            if (!(evtObj instanceof CFDebugEvent)) continue;
            evts.add((CFDebugEvent)evtObj);
        }
        return evts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExceptionEvent(Exception e) {
        CFExceptionEvent expEvt = new CFExceptionEvent(e);
        ArrayList arrayList = this.debugEventQueue;
        synchronized (arrayList) {
            this.debugEventQueue.add(expEvt);
            this.debugEventQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSyncStepEvents(long timeOut, String threadName) {
        if (this.isClosed) {
            return null;
        }
        ArrayList arrayList = this.syncStepEventQueue;
        synchronized (arrayList) {
            if (this.syncStepEventQueue.size() > 0) {
                return this.processSyncStepEventQueue(timeOut, threadName);
            }
            this.syncStepWaitingThreadName = threadName;
            try {
                this.syncStepEventQueue.wait(timeOut);
            }
            catch (InterruptedException ex) {
                CFDebuggerLogger.log(ex);
            }
            this.syncStepWaitingThreadName = null;
        }
        if (this.isClosed) {
            return null;
        }
        if (this.currentCfPageComplete) {
            this.currentCfPageComplete = false;
            return null;
        }
        return this.processSyncStepEventQueue(timeOut, threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList processSyncStepEventQueue(long timeOut, String threadName) {
        if (this.syncStepEventQueue.size() == 0) {
            return this.getSyncStepEvents(timeOut, threadName);
        }
        ArrayList tmpEvtQueue = new ArrayList();
        ArrayList arrayList = this.syncStepEventQueue;
        synchronized (arrayList) {
            while (this.syncStepEventQueue.size() > 0) {
                tmpEvtQueue.add(this.syncStepEventQueue.remove(0));
            }
        }
        ArrayList<CFDebugEvent> evts = new ArrayList<CFDebugEvent>();
        while (tmpEvtQueue.size() > 0) {
            Object evtObj = tmpEvtQueue.remove(0);
            if (evtObj instanceof StepEvent) {
                CFDebugEvent de = this.wrapEvent((Event)evtObj, this.lastFetchFlagMap);
                if (de == null) continue;
                evts.add(de);
                continue;
            }
            if (!(evtObj instanceof CFStepEvent)) continue;
            evts.add((CFDebugEvent)evtObj);
        }
        return evts;
    }

    public void setScopeFilter(String scopeNames) {
        this.scopeFilter = scopeNames;
    }

    public String getScopeFilter() {
        return this.scopeFilter;
    }

    private ArrayList formatCFStackTrace(ArrayList cfTrace) {
        if (cfTrace == null || !this.debugMgr.isCtxRootDiffer()) {
            return cfTrace;
        }
        for (int i = 0; i < cfTrace.size(); ++i) {
            String pathAndLineNum = (String)cfTrace.get(i);
            int i1 = pathAndLineNum.lastIndexOf(":");
            String path = pathAndLineNum.substring(0, i1);
            String newPath = this.canonicalCfmlPathToNonCanonicalPath(path);
            cfTrace.set(i, newPath + pathAndLineNum.substring(i1));
        }
        return cfTrace;
    }

    private void setEventInformation(CFDebugEvent evt, ThreadReference thr, Map fetchFlags) {
        boolean getScopes = true;
        boolean getCFTrace = true;
        boolean getWatch = false;
        boolean getJavaTrace = false;
        boolean getThreads = false;
        if (fetchFlags != null) {
            Object obj = fetchFlags.get("SCOPES");
            if (obj != null) {
                getScopes = (Boolean)obj;
            }
            if ((obj = fetchFlags.get("CF_TRACE")) != null) {
                getCFTrace = (Boolean)obj;
            }
            if ((obj = fetchFlags.get("WATCH")) != null) {
                getWatch = (Boolean)obj;
            }
            if ((obj = fetchFlags.get("JAVA_TRACE")) != null) {
                getJavaTrace = (Boolean)obj;
            }
            if ((obj = fetchFlags.get("THREADS")) != null) {
                getThreads = (Boolean)obj;
            }
        }
        if (getJavaTrace || getCFTrace) {
            try {
                Object[] traces = JVMDebugThread.getJavaStackTrace(thr);
                if (traces != null && traces.length > 1) {
                    traces[1] = this.formatCFStackTrace((ArrayList)traces[1]);
                    if (!getJavaTrace) {
                        traces[0] = null;
                    }
                    if (!getCFTrace) {
                        traces[1] = null;
                    }
                    evt.setJavaStackTrace(traces);
                }
            }
            catch (Throwable e) {
                CFDebuggerLogger.log(e);
            }
        }
        if (getThreads) {
            try {
                if (this.isReturnVMThreads()) {
                    evt.setVmThreads(JVMDebugThreadManager.getVMThreads(thr.virtualMachine()));
                }
            }
            catch (Throwable e) {
                CFDebuggerLogger.log(e);
            }
        }
        if (getScopes) {
            try {
                evt.setScopes(this.getScopes(thr, this.scopeFilter));
            }
            catch (Throwable e) {
                CFDebuggerLogger.log(e);
            }
        }
        if (getWatch) {
            try {
                if (this.watchVariables != null && this.watchVariables.length > 0) {
                    evt.setWatchVariables(this.getVariableValues(this.watchVariables, thr));
                }
            }
            catch (Throwable e) {
                CFDebuggerLogger.log(e);
            }
        }
    }

    private String canonicalCfmlPathToNonCanonicalPath(String cfmlPath) {
        if (!this.debugMgr.isCtxRootDiffer()) {
            return cfmlPath;
        }
        String mappedPath = cfmlPath;
        String canonicalCtxRoot = this.debugMgr.getCanonicalCtxRoot();
        String ctxRoot = this.debugMgr.getCtxRoot();
        int index = cfmlPath.indexOf(ctxRoot);
        if (index == 0) {
            String relativePath = cfmlPath.substring(ctxRoot.length());
            mappedPath = canonicalCtxRoot + relativePath;
        }
        return mappedPath;
    }

    private CFDebugEvent wrapEvent(Event evt, Map fetchFlags) {
        try {
            boolean isBPEvent = false;
            boolean isStepEvent = false;
            boolean isExceptionEvent = false;
            String cfmlPath = null;
            if (evt instanceof LocatableEvent) {
                if (evt instanceof BreakpointEvent) {
                    isBPEvent = true;
                } else if (evt instanceof StepEvent) {
                    isStepEvent = true;
                } else if (evt instanceof ExceptionEvent) {
                    isExceptionEvent = true;
                } else if (evt instanceof LocatableEventWrapper) {
                    LocatableEventWrapper locWrapper = (LocatableEventWrapper)evt;
                    if (locWrapper.isBreakpointEvent()) {
                        isBPEvent = true;
                    } else if (locWrapper.isStepEvent()) {
                        isStepEvent = true;
                    } else if (locWrapper.isExceptionEvent()) {
                        isExceptionEvent = true;
                    }
                }
                cfmlPath = this.canonicalCfmlPathToNonCanonicalPath(((LocatableEvent)evt).location().sourcePath());
            }
            if (isBPEvent) {
                LocatableEvent bpe = (LocatableEvent)evt;
                Location loc = bpe.location();
                ThreadReference thr = bpe.thread();
                JVMDebugThread debugThread = JVMDebugThreadManager.getThread(thr);
                debugThread.setProcessingBpOrStepEvent(true);
                Method mth = loc.method();
                String methodName = mth == null ? null : mth.name();
                CFBreakpointEvent cfBpe = new CFBreakpointEvent(thr.name(), cfmlPath, loc.lineNumber(), methodName);
                this.setEventInformation(cfBpe, thr, fetchFlags);
                debugThread.setProcessingBpOrStepEvent(false);
                return cfBpe;
            }
            if (isStepEvent) {
                LocatableEvent se = (LocatableEvent)evt;
                Location loc = se.location();
                ThreadReference thr = se.thread();
                JVMDebugThread debugThread = JVMDebugThreadManager.getThread(thr);
                debugThread.setProcessingBpOrStepEvent(true);
                Method mth = loc.method();
                String methodName = mth == null ? null : mth.name();
                CFStepEvent cfSe = new CFStepEvent(thr.name(), cfmlPath, loc.lineNumber(), methodName);
                this.setEventInformation(cfSe, thr, fetchFlags);
                debugThread.setProcessingBpOrStepEvent(false);
                return cfSe;
            }
            if (isExceptionEvent) {
                LocatableEvent ex = (LocatableEvent)evt;
                Location loc = ex.location();
                ThreadReference thr = ex.thread();
                Method mth = loc.method();
                String methodName = mth == null ? null : mth.name();
                CFExceptionBreakpointEvent ebe = new CFExceptionBreakpointEvent(thr.name(), cfmlPath, loc.lineNumber(), methodName, ExceptionBreakpointHandler.getExceptionDetails(ex));
                this.setEventInformation(ebe, thr, fetchFlags);
                JVMDebugThread debugThread = JVMDebugThreadManager.getThread(thr.name());
                Object[] exceptionTraces = null;
                if (debugThread != null && (exceptionTraces = debugThread.getExceptionTraces()) != null) {
                    ebe.setJavaStackTrace(exceptionTraces);
                    debugThread.setExceptionTraces(null);
                }
                return ebe;
            }
            if (evt instanceof VMDisconnectEvent || evt instanceof VMDeathEvent) {
                return new CFDisconnectEvent();
            }
        }
        catch (Throwable e) {
            CFDebuggerLogger.log(e);
        }
        return null;
    }

    private HashMap getScopes(ThreadReference th, String scopeFilter) throws Throwable {
        boolean getAllScope;
        HashMap<String, Map> allScopes = new HashMap<String, Map>();
        Map tmpMap = null;
        boolean bl = getAllScope = scopeFilter == null;
        if ((getAllScope || scopeFilter.indexOf("SERVER") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("SERVER", th)) != null && tmpMap.size() > 0) {
            allScopes.put("SERVER", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("SESSION") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("SESSION", th)) != null && tmpMap.size() > 0) {
            allScopes.put("SESSION", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("CGI") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("CGI", th)) != null && tmpMap.size() > 0) {
            allScopes.put("CGI", tmpMap);
        }
        if (getAllScope || scopeFilter.indexOf("VARIABLES") != -1) {
            Map allVars = null;
            tmpMap = CFDebuggerUtils.getScopeVariables("VARIABLES", th);
            if (tmpMap != null && tmpMap.size() > 0) {
                allVars = tmpMap;
            }
            if ((tmpMap = CFDebuggerUtils.getFunctionLocalScopeVariables(th)) != null && tmpMap.size() > 0) {
                allScopes.put("FUNCTION_VARIABLES", tmpMap);
            }
            if (allVars != null) {
                allScopes.put("VARIABLES", allVars);
            }
        }
        if ((getAllScope || scopeFilter.indexOf("ARGUMENTS") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("ARGUMENTS", th)) != null && tmpMap.size() > 0) {
            allScopes.put("ARGUMENTS", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("FLASH") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("FLASH", th)) != null && tmpMap.size() > 0) {
            allScopes.put("FLASH", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("CLIENT") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("CLIENT", th)) != null && tmpMap.size() > 0) {
            allScopes.put("CLIENT", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("COOKIE") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("COOKIE", th)) != null && tmpMap.size() > 0) {
            allScopes.put("COOKIE", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("REQUEST") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("REQUEST", th)) != null && tmpMap.size() > 0) {
            allScopes.put("REQUEST", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("THISTAG") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("THISTAG", th)) != null && tmpMap.size() > 0) {
            allScopes.put("THISTAG", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("CALLER") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("CALLER", th)) != null && tmpMap.size() > 0) {
            allScopes.put("CALLER", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("ATTRIBUTES") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("ATTRIBUTES", th)) != null && tmpMap.size() > 0) {
            allScopes.put("ATTRIBUTES", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("FORM") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("FORM", th)) != null && tmpMap.size() > 0) {
            allScopes.put("FORM", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("APPLICATION") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("APPLICATION", th)) != null && tmpMap.size() > 0) {
            allScopes.put("APPLICATION", tmpMap);
        }
        if ((getAllScope || scopeFilter.indexOf("URL") != -1) && (tmpMap = CFDebuggerUtils.getScopeVariables("URL", th)) != null && tmpMap.size() > 0) {
            allScopes.put("URL", tmpMap);
        }
        return allScopes;
    }

    public HashMap getVariableValues(String[] varNames, ThreadReference thr) throws Throwable {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < varNames.length; ++i) {
            Object value = CFDebuggerUtils.getVariableValue(varNames[i], thr);
            if (value == null) continue;
            result.put(varNames[i], value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBreakpointHit(LocatableEvent bpe) {
        ArrayList arrayList;
        try {
            JVMDebugThread thr = JVMDebugThreadManager.getThread(bpe.thread().name());
            if (!this.canStopAtLocation(bpe)) {
                thr.resumeExecution();
                return;
            }
            Location loc = bpe.location();
            String sourcePath = loc.sourcePath();
            if (!DebugEventHandler.isCfmlFile(sourcePath)) {
                thr.resumeExecution();
                return;
            }
            if (!this.isBreakpointSet(loc.sourcePath(), loc.lineNumber())) {
                if (thr == null) {
                    return;
                }
                thr.resumeExecution();
                return;
            }
        }
        catch (Throwable e) {
            return;
        }
        CFDebugEvent de = this.wrapEvent(bpe, this.lastFetchFlagMap);
        if (de == null) {
            bpe.thread().resume();
            return;
        }
        if (this.syncronousStepRequest && this.syncStepWaitingThreadName != null) {
            arrayList = this.syncStepEventQueue;
            synchronized (arrayList) {
                this.syncStepEventQueue.add(de);
                this.syncStepEventQueue.notifyAll();
            }
        }
        arrayList = this.debugEventQueue;
        synchronized (arrayList) {
            this.debugEventQueue.add(de);
            this.debugEventQueue.notifyAll();
        }
        this.lastLocation = bpe.location();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExceptionEvent(LocatableEvent exEvt) {
        JVMDebugThread thr = JVMDebugThreadManager.getThread(exEvt.thread());
        try {
            if (!this.isBreakOnException()) {
                thr.setProcessingBPException(false);
                thr.resumeExecution();
                return;
            }
            if (!this.canStopAtLocation(exEvt)) {
                thr.setProcessingBPException(false);
                thr.resumeExecution();
                return;
            }
        }
        catch (Throwable e) {
            if (thr != null) {
                thr.setProcessingBPException(false);
            }
            return;
        }
        CFDebugEvent de = this.wrapEvent(exEvt, this.lastFetchFlagMap);
        if (de == null) {
            thr.setProcessingBPException(false);
            exEvt.thread().resume();
            return;
        }
        ArrayList arrayList = this.debugEventQueue;
        synchronized (arrayList) {
            this.debugEventQueue.add(de);
            this.debugEventQueue.notifyAll();
        }
        this.lastLocation = exEvt.location();
        thr.setProcessingBPException(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStepEvent(LocatableEvent se) {
        JVMDebugThread thr = JVMDebugThreadManager.getThread(se.thread().name());
        if (!this.canStopAtLocation(se)) {
            try {
                thr.resumeExecution();
            }
            catch (Throwable e) {
                se.thread().resume();
            }
            return;
        }
        CFDebugEvent de = this.wrapEvent(se, this.lastFetchFlagMap);
        if (de == null) {
            se.thread().resume();
            return;
        }
        if (this.syncronousStepRequest) {
            ArrayList arrayList = this.syncStepEventQueue;
            synchronized (arrayList) {
                this.syncStepEventQueue.add(de);
                this.syncStepEventQueue.notify();
            }
        }
        ArrayList arrayList = this.debugEventQueue;
        synchronized (arrayList) {
            this.debugEventQueue.add(de);
            this.debugEventQueue.notify();
        }
        this.lastLocation = se.location();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVMDisconnect(Event evt) {
        ArrayList arrayList = this.debugEventQueue;
        synchronized (arrayList) {
            if (evt == null) {
                this.debugEventQueue.add(new CFDisconnectEvent());
            } else {
                this.debugEventQueue.add(evt);
            }
            this.debugEventQueue.notify();
        }
    }

    public void closeSession(VirtualMachine vm, String threadName) {
        this.stopBPCheckTask();
        try {
            if (threadName != null && threadName.length() > 0) {
                StringTokenizer tokens = new StringTokenizer(threadName);
                while (tokens.hasMoreElements()) {
                    String aThreadName = tokens.nextElement().toString();
                    JVMDebugThread thr = JVMDebugThreadManager.getThread(aThreadName);
                    if (thr == null) continue;
                    if (thr.getThreadReference().isAtBreakpoint() || thr.getThreadReference().isSuspended()) {
                        thr.resumeExecution();
                    }
                    thr.setSession(null);
                }
            }
        }
        catch (Throwable e) {
            CFDebuggerLogger.log(e);
        }
        try {
            this.removeAllBreakpoints(vm);
        }
        catch (Throwable e) {
            CFDebuggerLogger.log(e);
        }
        this.pendingBPs = new HashMap();
        this.isClosed = true;
    }

    public void setCFVariableValue(String threadName, String varName, Object value) throws Throwable {
        JVMDebugThread thr = JVMDebugThreadManager.getThread(threadName);
        if (thr == null) {
            CFDebuggerExceptions.throwDebuggerThreadNotFoundException(threadName);
        }
        thr.setCFVariableValue(varName, value);
    }

    public void setWatchVariableNames(String[] variableNames) {
        this.watchVariables = variableNames;
    }

    public String[] getWatchVariableNames() {
        return this.watchVariables;
    }

    public HashMap getCFVariables(String threadName) throws Throwable {
        JVMDebugThread thr = JVMDebugThreadManager.getThread(threadName);
        if (thr == null) {
            CFDebuggerExceptions.throwDebuggerThreadNotFoundException(threadName);
        }
        if (!thr.getThreadReference().isAtBreakpoint() && !thr.getThreadReference().isSuspended()) {
            return null;
        }
        HashMap scopes = this.getScopes(thr.getThreadReference(), this.scopeFilter);
        HashMap watchVars = null;
        if (this.watchVariables != null) {
            watchVars = this.getVariableValues(this.watchVariables, thr.getThreadReference());
        }
        if (!(scopes != null && scopes.size() != 0 || watchVars != null && watchVars.size() != 0)) {
            return null;
        }
        HashMap<String, HashMap> variables = new HashMap<String, HashMap>();
        if (scopes != null) {
            variables.put("SCOPES", scopes);
        }
        if (watchVars != null) {
            variables.put("WATCH", watchVars);
        }
        return variables;
    }

    public HashMap getSingleCFVariable(String threadName, String varName) throws Throwable {
        JVMDebugThread thr = JVMDebugThreadManager.getThread(threadName);
        if (thr == null) {
            CFDebuggerExceptions.throwDebuggerThreadNotFoundException(threadName);
        }
        if (!thr.getThreadReference().isAtBreakpoint() && !thr.getThreadReference().isSuspended()) {
            return null;
        }
        Object value = CFDebuggerUtils.getVariableValue(varName, thr.getThreadReference());
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put("VARIABLE_VALUE", value);
        return returnValue;
    }

    public HashMap getCFScopes(String threadName) throws Throwable {
        JVMDebugThread thr = JVMDebugThreadManager.getThread(threadName);
        if (thr == null) {
            CFDebuggerExceptions.throwDebuggerThreadNotFoundException(threadName);
        }
        if (!thr.getThreadReference().isAtBreakpoint() && !thr.getThreadReference().isSuspended()) {
            return null;
        }
        HashMap scopes = this.getScopes(thr.getThreadReference(), this.scopeFilter);
        if (scopes == null || scopes.size() == 0) {
            return null;
        }
        return scopes;
    }

    public HashMap getWatchVariables(String threadName) throws Throwable {
        JVMDebugThread thr = JVMDebugThreadManager.getThread(threadName);
        if (thr == null) {
            CFDebuggerExceptions.throwDebuggerThreadNotFoundException(threadName);
        }
        if (!thr.getThreadReference().isAtBreakpoint() && !thr.getThreadReference().isSuspended()) {
            return null;
        }
        HashMap watchVars = this.getVariableValues(this.watchVariables, thr.getThreadReference());
        if (watchVars == null || watchVars.size() == 0) {
            return null;
        }
        return watchVars;
    }

    public Object getCFVariableValue(String threadName, String varName) throws Throwable {
        JVMDebugThread thr = JVMDebugThreadManager.getThread(threadName);
        if (thr == null) {
            CFDebuggerExceptions.throwDebuggerThreadNotFoundException(threadName);
        }
        if (!thr.getThreadReference().isAtBreakpoint() && !thr.getThreadReference().isSuspended()) {
            return null;
        }
        return CFDebuggerUtils.getVariableValue(varName, thr.getThreadReference());
    }

    public boolean isReturnVMThreads() {
        return this.returnVMThreads;
    }

    public void setReturnVMThreads(boolean returnVMThreads) {
        this.returnVMThreads = returnVMThreads;
    }

    public void setStepEventSynchronous(boolean isSync) {
        this.syncronousStepRequest = isSync;
    }

    public boolean isStepEventSynchronous() {
        return this.syncronousStepRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCFRequestEnd(String threadName) {
        Cloneable cloneable;
        if (this.syncStepWaitingThreadName != null && threadName.equals(this.syncStepWaitingThreadName)) {
            cloneable = this.syncStepEventQueue;
            synchronized (cloneable) {
                this.currentCfPageComplete = true;
                this.syncStepEventQueue.notifyAll();
            }
        }
        this.resetLastLocation(threadName);
        cloneable = this.skipBpMap;
        synchronized (cloneable) {
            this.skipBpMap.clear();
        }
    }

    public String getCFOutput(String threadName, boolean getOnlyBody) throws Throwable {
        JVMDebugThread th = JVMDebugThreadManager.getThread(threadName);
        if (th == null) {
            return null;
        }
        if (th.getSessionId() != null && !th.getSessionId().equals(this.getSessionId())) {
            return null;
        }
        ThreadReference thr = th.getThreadReference();
        if (!thr.isAtBreakpoint() && !thr.isSuspended()) {
            return null;
        }
        return CFDebuggerUtils.getCFOutput(thr, getOnlyBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canStopAtLocation(LocatableEvent evt) {
        String string = "";
        synchronized ("") {
            boolean ret = true;
            if (this.lastExecutingThread.length() == 0) {
                ret = true;
            } else if (!evt.thread().name().equals(this.lastExecutingThread)) {
                ret = false;
            }
            if (ret) {
                this.lastExecutingThread = evt.thread().name();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLastLocation(String threadName) {
        String string = "";
        synchronized ("") {
            if (threadName.equals(this.lastExecutingThread)) {
                this.lastLocation = null;
                this.lastExecutingThread = "";
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void startFailedBPCheckerTimer() {
        if (this.bpCheckTimer != null && this.bpCheckTask != null) {
            return;
        }
        this.stopBPCheckTask();
        this.bpCheckTimer = new Timer();
        this.bpCheckTask = new FailedBPCheckerTask(this.failedBPInfoList, this);
        this.bpCheckTimer.schedule((TimerTask)this.bpCheckTask, 0L, 4000L);
    }

    private void stopBPCheckTask() {
        if (this.bpCheckTimer != null) {
            this.bpCheckTimer.cancel();
        }
        if (this.bpCheckTask != null) {
            this.bpCheckTask.stopTask();
        }
    }

    void onInvalidBreakPoint(String cfmlPath, int lineNum) {
        Object obj = this.breakpoints.get(cfmlPath);
        if (obj == null && (obj = this.pendingBPs.get(cfmlPath)) == null) {
            return;
        }
        ArrayList bps = (ArrayList)obj;
        Integer lineNumObj = new Integer(lineNum);
        bps.remove(lineNumObj);
        CFDebuggerExceptions.InvalidBreakpointLocationException e = CFDebuggerExceptions.createInvalidBreakpointLocationException(cfmlPath, lineNum, -1);
        this.createExceptionEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBPSuccessfullySet(String cfmlPath, int lineNum) {
        ArrayList arrayList = this.failedBPInfoList;
        synchronized (arrayList) {
            for (int i = this.failedBPInfoList.size() - 1; i >= 0; --i) {
                FailedBPInfo bpInfo = (FailedBPInfo)this.failedBPInfoList.get(i);
                if (!bpInfo.cfmlPath.equals(cfmlPath) || bpInfo.lineNum != lineNum) continue;
                this.failedBPInfoList.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFailedBP(String cfmlPath, int lineNum) {
        ArrayList arrayList = this.failedBPInfoList;
        synchronized (arrayList) {
            FailedBPInfo bpInfo = new FailedBPInfo();
            bpInfo.cfmlPath = cfmlPath;
            bpInfo.lineNum = lineNum;
            this.failedBPInfoList.add(bpInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkFailedBPs() {
        if (this.failedBPInfoList == null) {
            return;
        }
        ArrayList arrayList = this.failedBPInfoList;
        synchronized (arrayList) {
            for (int i = this.failedBPInfoList.size() - 1; i >= 0; --i) {
                FailedBPInfo bpInfo = (FailedBPInfo)this.failedBPInfoList.get(i);
                long delay = System.currentTimeMillis() - bpInfo.failedAtTime;
                if (delay < 4000L) continue;
                this.failedBPInfoList.remove(i);
                this.onInvalidBreakPoint(bpInfo.cfmlPath, bpInfo.lineNum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBreakpointSetEvent(String cfmlPath, int reqLineNum, int actualLineNum) {
        CFBreakpointSetEvent setEvt = new CFBreakpointSetEvent(cfmlPath, reqLineNum, actualLineNum);
        ArrayList arrayList = this.debugEventQueue;
        synchronized (arrayList) {
            this.debugEventQueue.add(setEvt);
            this.debugEventQueue.notify();
        }
    }

    public void addPendingBreakpoint(String cfmlPath, int lineNum) {
        this.addToBPHashMap(cfmlPath, lineNum, this.pendingBPs);
    }

    public void removePendingBreakpoint(String cfmlPath, int lineNum) {
        Object obj = this.pendingBPs.get(cfmlPath);
        if (obj == null) {
            return;
        }
        Integer lineNumObj = new Integer(lineNum);
        ArrayList lineNums = (ArrayList)obj;
        lineNums.remove(lineNumObj);
    }

    private void addToBPHashMap(String cfmlPath, int lineNum, HashMap bpMap) {
        Integer lineNumObj;
        ArrayList bps;
        Object obj = bpMap.get(cfmlPath);
        if (obj == null) {
            obj = new ArrayList();
            bpMap.put(cfmlPath, obj);
        }
        if ((bps = (ArrayList)obj).indexOf(lineNumObj = new Integer(lineNum)) == -1) {
            bps.add(lineNumObj);
        }
    }

    public boolean searchBreakpointMap(String cfmlPath, int lineNum, HashMap bpMap) {
        Object obj = bpMap.get(cfmlPath);
        if (obj == null) {
            return false;
        }
        ArrayList bps = (ArrayList)obj;
        Integer lineNumObj = new Integer(lineNum);
        return bps.indexOf(lineNumObj) != -1;
    }

    public boolean removeFromBreakpointMap(String cfmlPath, int lineNum, VirtualMachine vm, HashMap bpMap) throws Throwable {
        Object obj = bpMap.get(cfmlPath);
        if (obj == null) {
            return false;
        }
        Integer lineNumObj = new Integer(lineNum);
        ArrayList lineNums = (ArrayList)obj;
        if (vm != null) {
            List<BreakpointRequest> bps = vm.eventRequestManager().breakpointRequests();
            for (BreakpointRequest bpr : bps) {
                Location loc = bpr.location();
                if (!loc.sourcePath().equals(cfmlPath) || loc.lineNumber() != lineNum) continue;
                vm.eventRequestManager().deleteEventRequest(bpr);
                break;
            }
        }
        return lineNums.remove(lineNumObj);
    }

    public boolean isRemoteSession() {
        return this.remoteSession;
    }

    public void setRemoteSession(boolean remoteSession) {
        this.remoteSession = remoteSession;
    }

    public boolean isBreakOnException() {
        if (!this.debugMgr.isBreakOnException()) {
            return false;
        }
        return this.breakOnException;
    }

    public void setBreakOnException(boolean doBreak) {
        this.breakOnException = !this.debugMgr.isBreakOnException() ? false : doBreak;
    }
}

