/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import coldfusion.xml.rpc.WebServiceUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.dispatchers.AbstractServiceDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CFRequestURIBasedServiceDispatcher
extends AbstractServiceDispatcher {
    private static final Log log = LogFactory.getLog(CFRequestURIBasedServiceDispatcher.class);

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " Checking for Service using target endpoint address : " + toEPR.getAddress()));
            }
            String filePart = toEPR.getAddress();
            ConfigurationContext configurationContext = messageContext.getConfigurationContext();
            HttpServletRequest request = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest");
            String[] values = new String[]{this.extractServiceName(request)};
            if (values.length >= 1 && values[0] != null) {
                Map endpoints;
                AxisConfiguration registry = configurationContext.getAxisConfiguration();
                AxisService axisService = registry.getService(values[0]);
                if (axisService != null && (endpoints = axisService.getEndpoints()) != null) {
                    if (endpoints.size() == 1) {
                        messageContext.setProperty("endpoint", endpoints.get(axisService.getEndpointName()));
                    } else {
                        String endpointName = values[0].substring(values[0].indexOf(".") + 1);
                        messageContext.setProperty("endpoint", endpoints.get(endpointName));
                    }
                }
                return axisService;
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " Attempted to check for Service using target endpoint URI, but the service fragment was missing"));
            }
            return null;
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)(messageContext.getLogIDString() + " Attempted to check for Service using null target endpoint URI"));
        }
        return null;
    }

    private String extractServiceName(HttpServletRequest req) {
        return WebServiceUtil.getServiceName((String)req.getRequestURL().toString());
    }

    public void initDispatcher() {
        this.init(new HandlerDescription("AbstractServiceDispatcher"));
    }
}

