/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.document.CFDocument;
import coldfusion.document.DocumentNotAllowedEncryptionPermission;
import coldfusion.document.DocumentSection;
import coldfusion.document.pdf.core.PdfPermissions;
import coldfusion.pdf.PDFForm;
import coldfusion.pdf.PDFFormException;
import coldfusion.runtime.ApplicationException;
import coldfusion.util.RB;
import com.adobe.internal.io.ByteArrayByteWriter;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptions;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMService;
import com.adobe.internal.pdftoolkit.services.security.SecurityLockPassword;
import com.adobe.internal.pdftoolkit.services.security.StandardEncryptionPermissions;
import com.rsa.jsafe.provider.JsafeJCE;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.List;

public class PDFFormCFDocProcessor {
    public static final String PDFFORM_PAGE_COUNT = "PDFFORM_PAGE_COUNT";
    private PDFDocument pdfForm;
    private int numPagesB4PDFFormTag;
    private CFDocument cfDocument;
    private int numPagesInPDFForm = 0;
    private int numPDFTagsInCfDocument = 0;
    private String encryption = "none";
    private String ownerpassword;
    private String userpassword;
    private int permissionsbits;

    public PDFFormCFDocProcessor(CFDocument cfDocument) {
        this.cfDocument = cfDocument;
    }

    public void setPdfForm(PDFDocument pdfForm) {
        this.pdfForm = pdfForm;
        try {
            this.numPagesInPDFForm = pdfForm.requirePages().getNumPages();
        }
        catch (PDFInvalidDocumentException pdfInvaliddocex) {
            throw new PDFFormException(pdfInvaliddocex, RB.getString(PDFFormException.class, (String)"cfpdfform.PDFInvalidDocumentException"));
        }
        catch (PDFSecurityException pdfSecurityex) {
            throw new PDFFormException(pdfSecurityex, RB.getString(PDFFormException.class, (String)"cfpdfform.PDFSecurityException"));
        }
        catch (PDFIOException pdfioex) {
            throw new PDFFormException(pdfioex, RB.getString(PDFFormException.class, (String)"cfpdfform.PDFIOException"));
        }
    }

    public int getNumPagesInPDFForm() {
        return this.numPagesInPDFForm;
    }

    public void calculatePagesInCFDocB4PDFForm(List docSections) {
        if (docSections != null && !docSections.isEmpty()) {
            int totalPageNumber = 0;
            for (DocumentSection section : docSections) {
                totalPageNumber += section.getSectiontotalpagecount();
            }
            this.numPagesB4PDFFormTag = totalPageNumber;
        }
    }

    public byte[] mergePDF(byte[] cfDocumentPDFbytes, String encryption, String ownerpassword, String userpassword, PdfPermissions pdfPermissions) {
        if (pdfPermissions != null) {
            this.permissionsbits = pdfPermissions.getPermissionBits();
        }
        if (encryption != null && !"none".equalsIgnoreCase(encryption)) {
            this.encryption = encryption;
            this.ownerpassword = ownerpassword;
            this.userpassword = userpassword;
            this.permissionsbits |= 0xFFFFF0C0;
            this.permissionsbits &= 0xFFFFFFFC;
        }
        PDFDocument cfDocumentPDF = null;
        ByteArrayByteWriter outByteWriter = null;
        try {
            InputStreamByteReader byteReader = new InputStreamByteReader((InputStream)new ByteArrayInputStream(cfDocumentPDFbytes));
            cfDocumentPDF = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)PDFOpenOptions.newInstance());
            PMMOptions options = PMMOptions.newInstanceAll();
            PMMService pmmService = new PMMService(this.pdfForm);
            PDFPageTree pageTree = cfDocumentPDF.requirePages();
            PDFPage pg = pageTree.getPage(0);
            if (pg != null) {
                if (this.numPagesB4PDFFormTag > 0) {
                    pmmService.insertPages(null, pg, this.numPagesB4PDFFormTag, null, options);
                    pmmService.insertPages(this.pdfForm.requirePages().getPage(this.pdfForm.requirePages().getNumPages() - 1), pageTree.getPage(this.numPagesB4PDFFormTag), this.cfDocument.getTotalPageCount() - this.numPagesB4PDFFormTag, null, options);
                } else {
                    pmmService.appendPages(cfDocumentPDF, null, options);
                }
            }
            outByteWriter = new ByteArrayByteWriter();
            if (encryption != null && !"none".equalsIgnoreCase(encryption)) {
                this.encryptNSave(this.pdfForm, (ByteWriter)outByteWriter);
            } else {
                PDFForm.savePDF(this.pdfForm, (ByteWriter)outByteWriter);
            }
            byte[] byArray = outByteWriter.toByteArray();
            return byArray;
        }
        catch (PDFException e) {
            throw new PDFFormException(e, RB.getString(PDFFormException.class, (String)"cfpdfform.MergeException"));
        }
        catch (UnsupportedEncodingException e) {
            throw new PDFFormException(e, RB.getString(PDFFormException.class, (String)"cfpdfform.MergeException"));
        }
        catch (IOException ioe) {
            throw new PDFFormException(ioe, RB.getString(PDFFormException.class, (String)"cfpdfform.MergeException"));
        }
        finally {
            try {
                if (cfDocumentPDF != null) {
                    cfDocumentPDF.close();
                }
                if (this.pdfForm != null) {
                    this.pdfForm.close();
                }
                if (outByteWriter != null) {
                    outByteWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void addNumPDFTagsInCfDocument() {
        ++this.numPDFTagsInCfDocument;
        if (this.numPDFTagsInCfDocument > 1) {
            throw new MoreThanOnePDFFormException();
        }
    }

    private void encryptNSave(PDFDocument pdfDocuemnt, ByteWriter byteWriter) throws PDFSecurityException, UnsupportedEncodingException, PDFException {
        if (Security.getProvider("JsafeJCE") == null) {
            Security.addProvider((Provider)new JsafeJCE());
        }
        StandardEncryptionPermissions encryptPerms = StandardEncryptionPermissions.newInstance((int)this.permissionsbits);
        PermissionProvider permsProvider = encryptPerms.getPermissionProvider();
        SecurityLockPassword securityLock = null;
        if (this.encryption.equals("40-bit")) {
            if ((this.permissionsbits & 0x100) == 256 || (this.permissionsbits & 0x200) == 512 || (this.permissionsbits & 0x400) == 1024 || (this.permissionsbits & 4) == 4 && (this.permissionsbits & 0x804) != 2052) {
                throw new DocumentNotAllowedEncryptionPermission();
            }
            securityLock = SecurityLockPassword.newRC4_40bit((byte[])(this.ownerpassword == null ? null : this.ownerpassword.getBytes("US-ASCII")), this.userpassword == null ? null : this.userpassword.getBytes("US-ASCII"), (PermissionProvider)permsProvider);
        } else {
            securityLock = this.encryption.equals("128-bit") ? SecurityLockPassword.newRC4_128bit((byte[])(this.ownerpassword == null ? null : this.ownerpassword.getBytes("US-ASCII")), this.userpassword == null ? null : this.userpassword.getBytes("US-ASCII"), (PermissionProvider)permsProvider) : null;
        }
        PDFSaveFullOptions saveFullOptions = securityLock != null ? PDFSaveFullOptions.newInstance(securityLock) : PDFSaveFullOptions.newInstance();
        this.pdfForm.save(byteWriter, (PDFSaveOptions)saveFullOptions);
    }

    public class MoreThanOnePDFFormException
    extends ApplicationException {
    }
}

