/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.retry;

import java.time.Duration;
import java.util.Collections;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.util.CapacityManager;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.RetryUtils;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;

@SdkInternalApi
public final class RetryHandler {
    public static final String HEADER_SDK_RETRY_INFO = "amz-sdk-retry";
    private final RetryPolicy retryPolicy;
    private final CapacityManager retryCapacity;
    private Duration lastBackoffDelay = Duration.ZERO;
    private boolean retryCapacityConsumed;
    private RetryPolicyContext retryPolicyContext;
    private SdkException lastRetriedException;

    public RetryHandler(RetryPolicy retryPolicy, CapacityManager retryCapacity) {
        this.retryPolicy = retryPolicy;
        this.retryCapacity = retryCapacity;
    }

    public boolean shouldRetry(SdkHttpFullResponse httpResponse, SdkHttpFullRequest request, RequestExecutionContext context, SdkException exception, int requestCount) {
        int retriesAttempted = requestCount - 1;
        if (!RetryUtils.isThrottlingException(exception)) {
            if (!this.retryCapacity.acquire(5)) {
                return false;
            }
            this.retryCapacityConsumed = true;
        }
        this.retryPolicyContext = RetryPolicyContext.builder().request(request).originalRequest(context.originalRequest()).exception(exception).retriesAttempted(retriesAttempted).executionAttributes(context.executionAttributes()).httpStatusCode(httpResponse == null ? null : Integer.valueOf(httpResponse.statusCode())).build();
        if (!this.retryPolicy.retryCondition().shouldRetry(this.retryPolicyContext)) {
            if (this.retryCapacityConsumed) {
                this.retryCapacity.release(5);
            }
            return false;
        }
        return true;
    }

    public void releaseRetryCapacity() {
        if (this.isRetry() && this.retryCapacityConsumed) {
            this.retryCapacity.release(5);
        } else {
            this.retryCapacity.release();
        }
    }

    public Duration computeDelayBeforeNextRetry() {
        this.lastBackoffDelay = RetryUtils.isThrottlingException(this.retryPolicyContext.exception()) ? this.retryPolicy.throttlingBackoffStrategy().computeDelayBeforeNextRetry(this.retryPolicyContext) : this.retryPolicy.backoffStrategy().computeDelayBeforeNextRetry(this.retryPolicyContext);
        return this.lastBackoffDelay;
    }

    public void retryCapacityConsumed(boolean retryCapacityConsumed) {
        this.retryCapacityConsumed = retryCapacityConsumed;
    }

    public SdkHttpFullRequest addRetryInfoHeader(SdkHttpFullRequest request, int requestCount) throws Exception {
        int availableRetryCapacity = this.retryCapacity.availableCapacity();
        return request.toBuilder().putHeader(HEADER_SDK_RETRY_INFO, Collections.singletonList(String.format("%s/%s/%s", requestCount - 1, this.lastBackoffDelay.toMillis(), availableRetryCapacity >= 0 ? Integer.valueOf(availableRetryCapacity) : ""))).build();
    }

    public void setLastRetriedException(SdkException exception) {
        this.lastRetriedException = exception;
    }

    public boolean isRetry() {
        return this.lastRetriedException != null;
    }
}

