/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkStandardLogger;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.internal.Response;
import software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import software.amazon.awssdk.core.internal.http.InterruptMonitor;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import software.amazon.awssdk.core.internal.http.pipeline.RequestToResponsePipeline;
import software.amazon.awssdk.core.internal.retry.ClockSkewAdjuster;
import software.amazon.awssdk.core.internal.retry.RetryHandler;
import software.amazon.awssdk.core.internal.util.CapacityManager;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class RetryableStage<OutputT>
implements RequestToResponsePipeline<OutputT> {
    private static final Logger log = Logger.loggerFor(RetryableStage.class);
    private final RequestPipeline<SdkHttpFullRequest, Response<OutputT>> requestPipeline;
    private final HttpClientDependencies dependencies;
    private final CapacityManager retryCapacity;
    private final RetryPolicy retryPolicy;

    public RetryableStage(HttpClientDependencies dependencies, RequestPipeline<SdkHttpFullRequest, Response<OutputT>> requestPipeline) {
        this.dependencies = dependencies;
        this.retryCapacity = dependencies.retryCapacity();
        this.retryPolicy = dependencies.clientConfiguration().option(SdkClientOption.RETRY_POLICY);
        this.requestPipeline = requestPipeline;
    }

    @Override
    public Response<OutputT> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        return new RetryExecutor(request, context).execute();
    }

    private class RetryExecutor {
        private final SdkHttpFullRequest request;
        private final RequestExecutionContext context;
        private final RetryHandler retryHandler;
        private int requestCount = 0;

        private RetryExecutor(SdkHttpFullRequest request, RequestExecutionContext context) {
            this.request = request;
            this.context = context;
            this.retryHandler = new RetryHandler(RetryableStage.this.retryPolicy, RetryableStage.this.retryCapacity);
        }

        public Response<OutputT> execute() throws Exception {
            while (true) {
                try {
                    while (true) {
                        this.beforeExecute();
                        Response response = this.doExecute();
                        if (response.isSuccess()) {
                            this.retryHandler.releaseRetryCapacity();
                            return response;
                        }
                        this.retryHandler.setLastRetriedException(this.handleUnmarshalledException(response));
                    }
                }
                catch (IOException | SdkClientException e) {
                    this.retryHandler.setLastRetriedException(this.handleThrownException(e));
                    continue;
                }
                break;
            }
        }

        private void beforeExecute() throws InterruptedException {
            this.retryHandler.retryCapacityConsumed(false);
            InterruptMonitor.checkInterrupted();
            ++this.requestCount;
        }

        private Response<OutputT> doExecute() throws Exception {
            if (this.retryHandler.isRetry()) {
                this.doPauseBeforeRetry();
            }
            SdkStandardLogger.REQUEST_LOGGER.debug(() -> (this.retryHandler.isRetry() ? "Retrying " : "Sending ") + "Request: " + this.request);
            return (Response)RetryableStage.this.requestPipeline.execute(this.retryHandler.addRetryInfoHeader(this.request, this.requestCount), this.context);
        }

        private SdkException handleUnmarshalledException(Response<OutputT> response) {
            SdkException exception = response.exception();
            ClockSkewAdjuster clockSkewAdjuster = RetryableStage.this.dependencies.clockSkewAdjuster();
            if (clockSkewAdjuster.shouldAdjust(exception)) {
                RetryableStage.this.dependencies.updateTimeOffset(clockSkewAdjuster.getAdjustmentInSeconds((SdkHttpResponse)response.httpResponse()));
            }
            if (!this.retryHandler.shouldRetry(response.httpResponse(), this.request, this.context, exception, this.requestCount)) {
                throw exception;
            }
            return exception;
        }

        private SdkException handleThrownException(Exception e) {
            SdkClientException sdkClientException = e instanceof SdkClientException ? (SdkClientException)e : SdkClientException.builder().message("Unable to execute HTTP request: " + e.getMessage()).cause(e).build();
            boolean willRetry = this.retryHandler.shouldRetry(null, this.request, this.context, sdkClientException, this.requestCount);
            log.debug(() -> sdkClientException.getMessage() + (willRetry ? " Request will be retried." : ""), (Throwable)e);
            if (!willRetry) {
                throw sdkClientException;
            }
            return sdkClientException;
        }

        private void doPauseBeforeRetry() throws InterruptedException {
            int retriesAttempted = this.requestCount - 2;
            Duration delay = this.retryHandler.computeDelayBeforeNextRetry();
            SdkStandardLogger.REQUEST_LOGGER.debug(() -> "Retryable error detected, will retry in " + delay.toMillis() + "ms, attempt number " + retriesAttempted);
            TimeUnit.MILLISECONDS.sleep(delay.toMillis());
        }
    }
}

