/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.pipeline.MutableRequestToRequestPipeline;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public final class MoveParametersToBodyStage
implements MutableRequestToRequestPipeline {
    @Override
    public SdkHttpFullRequest.Builder execute(SdkHttpFullRequest.Builder input, RequestExecutionContext context) {
        if (this.shouldPutParamsInBody(input)) {
            return MoveParametersToBodyStage.changeQueryParametersToFormData(input);
        }
        return input;
    }

    private boolean shouldPutParamsInBody(SdkHttpFullRequest.Builder input) {
        return input.method() == SdkHttpMethod.POST && input.contentStreamProvider() == null && !CollectionUtils.isNullOrEmpty((Map)input.rawQueryParameters());
    }

    private static SdkHttpFullRequest.Builder changeQueryParametersToFormData(SdkHttpFullRequest.Builder input) {
        byte[] params = SdkHttpUtils.encodeAndFlattenFormData((Map)input.rawQueryParameters()).orElse("").getBytes(StandardCharsets.UTF_8);
        return input.clearQueryParameters().contentStreamProvider(() -> new ByteArrayInputStream(params)).putHeader("Content-Length", Collections.singletonList(String.valueOf(params.length))).putHeader("Content-Type", Collections.singletonList("application/x-www-form-urlencoded; charset=" + StringUtils.lowerCase((String)StandardCharsets.UTF_8.toString())));
    }
}

