/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkStandardLogger;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.Response;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.utils.IoUtils;

@SdkInternalApi
public class HandleResponseStage<OutputT>
implements RequestPipeline<SdkHttpFullResponse, Response<OutputT>> {
    private static final Logger log = LoggerFactory.getLogger(HandleResponseStage.class);
    private final HttpResponseHandler<OutputT> successResponseHandler;
    private final HttpResponseHandler<? extends SdkException> errorResponseHandler;

    public HandleResponseStage(HttpResponseHandler<OutputT> successResponseHandler, HttpResponseHandler<? extends SdkException> errorResponseHandler) {
        this.successResponseHandler = successResponseHandler;
        this.errorResponseHandler = errorResponseHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<OutputT> execute(SdkHttpFullResponse httpResponse, RequestExecutionContext context) throws Exception {
        boolean didRequestFail = true;
        try {
            Response<OutputT> response = this.handleResponse(httpResponse, context);
            didRequestFail = response.isFailure();
            Response<OutputT> response2 = response;
            return response2;
        }
        finally {
            this.closeInputStreamIfNeeded(httpResponse, didRequestFail);
        }
    }

    private Response<OutputT> handleResponse(SdkHttpFullResponse httpResponse, RequestExecutionContext context) throws IOException, InterruptedException {
        if (httpResponse.isSuccessful()) {
            OutputT response = this.handleSuccessResponse(httpResponse, context);
            return Response.fromSuccess(response, httpResponse);
        }
        return Response.fromFailure(this.handleErrorResponse(httpResponse, context), httpResponse);
    }

    private OutputT handleSuccessResponse(SdkHttpFullResponse httpResponse, RequestExecutionContext context) throws IOException, InterruptedException {
        try {
            SdkStandardLogger.REQUEST_LOGGER.debug(() -> "Received successful response: " + httpResponse.statusCode());
            return this.successResponseHandler.handle(httpResponse, context.executionAttributes());
        }
        catch (IOException | InterruptedException | RetryableException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof SdkException && ((SdkException)e).retryable()) {
                throw (SdkException)e;
            }
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + "). Response Code: " + httpResponse.statusCode() + ", Response Text: " + (String)httpResponse.statusText().orElse(null);
            throw SdkClientException.builder().message(errorMessage).cause(e).build();
        }
    }

    private SdkException handleErrorResponse(SdkHttpFullResponse httpResponse, RequestExecutionContext context) throws IOException, InterruptedException {
        try {
            SdkException exception = this.errorResponseHandler.handle(httpResponse, context.executionAttributes());
            exception.fillInStackTrace();
            SdkStandardLogger.REQUEST_LOGGER.debug(() -> "Received error response: " + exception);
            return exception;
        }
        catch (IOException | InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Unable to unmarshall error response (%s). Response Code: %d, Response Text: %s", e.getMessage(), httpResponse.statusCode(), httpResponse.statusText().orElse("null"));
            throw SdkClientException.builder().message(errorMessage).cause(e).build();
        }
    }

    private void closeInputStreamIfNeeded(SdkHttpFullResponse httpResponse, boolean didRequestFail) {
        if (didRequestFail || !this.successResponseHandler.needsConnectionLeftOpen()) {
            Optional.ofNullable(httpResponse).flatMap(SdkHttpFullResponse::content).ifPresent(s -> IoUtils.closeQuietly((AutoCloseable)s, (Logger)log));
        }
    }
}

