/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkGlobalTime;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.internal.retry.ClockSkewAdjuster;
import software.amazon.awssdk.core.internal.util.CapacityManager;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class HttpClientDependencies
implements SdkAutoCloseable {
    private final ClockSkewAdjuster clockSkewAdjuster = new ClockSkewAdjuster();
    private final SdkClientConfiguration clientConfiguration;
    private final CapacityManager capacityManager;
    private volatile int timeOffset = SdkGlobalTime.getGlobalTimeOffset();

    private HttpClientDependencies(Builder builder) {
        this.clientConfiguration = (SdkClientConfiguration)Validate.paramNotNull((Object)builder.clientConfiguration, (String)"ClientConfiguration");
        this.capacityManager = (CapacityManager)Validate.paramNotNull((Object)builder.capacityManager, (String)"CapacityManager");
    }

    public static Builder builder() {
        return new Builder();
    }

    public SdkClientConfiguration clientConfiguration() {
        return this.clientConfiguration;
    }

    public CapacityManager retryCapacity() {
        return this.capacityManager;
    }

    public ClockSkewAdjuster clockSkewAdjuster() {
        return this.clockSkewAdjuster;
    }

    public int timeOffset() {
        return this.timeOffset;
    }

    public void updateTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
        SdkGlobalTime.setGlobalTimeOffset(timeOffset);
    }

    public void close() {
        this.clientConfiguration.close();
    }

    public static class Builder {
        private SdkClientConfiguration clientConfiguration;
        private CapacityManager capacityManager;

        private Builder() {
        }

        public Builder clientConfiguration(SdkClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public Builder capacityManager(CapacityManager capacityManager) {
            this.capacityManager = capacityManager;
            return this;
        }

        public HttpClientDependencies build() {
            return new HttpClientDependencies(this);
        }
    }
}

