/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.client.handler;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.BaseClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.core.exception.NonRetryableException;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.internal.http.AmazonSyncHttpClient;
import software.amazon.awssdk.core.internal.http.InterruptMonitor;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;

@SdkProtectedApi
public abstract class BaseSyncClientHandler
extends BaseClientHandler
implements SyncClientHandler {
    private final SdkClientConfiguration clientConfiguration;
    private final AmazonSyncHttpClient client;

    protected BaseSyncClientHandler(SdkClientConfiguration clientConfiguration, AmazonSyncHttpClient client) {
        super(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.client = client;
    }

    @Override
    public <InputT extends SdkRequest, OutputT extends SdkResponse, ReturnT> ReturnT execute(ClientExecutionParams<InputT, OutputT> executionParams, ResponseTransformer<OutputT, ReturnT> responseTransformer) {
        ExecutionContext executionContext = this.createExecutionContext(executionParams);
        HttpResponseHandler<OutputT> decoratedResponseHandlers = this.decorateResponseHandlers(executionParams.getResponseHandler(), executionContext);
        HttpResponseHandlerAdapter httpResponseHandler = new HttpResponseHandlerAdapter(decoratedResponseHandlers, responseTransformer);
        return this.execute(executionParams, executionContext, httpResponseHandler);
    }

    @Override
    public <InputT extends SdkRequest, OutputT extends SdkResponse> OutputT execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        ExecutionContext executionContext = this.createExecutionContext(executionParams);
        HttpResponseHandler<OutputT> decoratedResponseHandlers = this.decorateResponseHandlers(executionParams.getResponseHandler(), executionContext);
        return (OutputT)((SdkResponse)this.execute(executionParams, executionContext, decoratedResponseHandlers));
    }

    public void close() {
        this.client.close();
    }

    protected <OutputT> OutputT invoke(SdkHttpFullRequest request, SdkRequest originalRequest, ExecutionContext executionContext, HttpResponseHandler<OutputT> responseHandler, HttpResponseHandler<? extends SdkException> errorResponseHandler) {
        return this.client.requestExecutionBuilder().request(request).originalRequest(originalRequest).executionContext(executionContext).errorResponseHandler(errorResponseHandler).execute(responseHandler);
    }

    private <InputT extends SdkRequest, OutputT, ReturnT> ReturnT execute(ClientExecutionParams<InputT, OutputT> executionParams, ExecutionContext executionContext, HttpResponseHandler<ReturnT> responseHandler) {
        SdkRequest inputT = BaseSyncClientHandler.finalizeSdkRequest(executionContext).request();
        InterceptorContext sdkHttpFullRequestContext = BaseSyncClientHandler.finalizeSdkHttpFullRequest(executionParams, executionContext, inputT, this.clientConfiguration);
        SdkHttpFullRequest marshalled = (SdkHttpFullRequest)sdkHttpFullRequestContext.httpRequest();
        if (sdkHttpFullRequestContext.requestBody().isPresent()) {
            marshalled = marshalled.toBuilder().contentStreamProvider(sdkHttpFullRequestContext.requestBody().get().contentStreamProvider()).build();
        }
        return this.invoke(marshalled, inputT, executionContext, responseHandler, executionParams.getErrorResponseHandler());
    }

    private static class HttpResponseHandlerAdapter<ReturnT, OutputT extends SdkResponse>
    implements HttpResponseHandler<ReturnT> {
        private final HttpResponseHandler<OutputT> httpResponseHandler;
        private final ResponseTransformer<OutputT, ReturnT> responseTransformer;

        private HttpResponseHandlerAdapter(HttpResponseHandler<OutputT> httpResponseHandler, ResponseTransformer<OutputT, ReturnT> responseTransformer) {
            this.httpResponseHandler = httpResponseHandler;
            this.responseTransformer = responseTransformer;
        }

        @Override
        public ReturnT handle(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) throws Exception {
            SdkResponse resp = (SdkResponse)this.httpResponseHandler.handle(response, executionAttributes);
            return this.transformResponse(resp, (AbortableInputStream)response.content().get());
        }

        @Override
        public boolean needsConnectionLeftOpen() {
            return this.responseTransformer.needsConnectionLeftOpen();
        }

        private ReturnT transformResponse(OutputT resp, AbortableInputStream inputStream) throws Exception {
            try {
                InterruptMonitor.checkInterrupted();
                ReturnT result = this.responseTransformer.transform(resp, inputStream);
                InterruptMonitor.checkInterrupted();
                return result;
            }
            catch (InterruptedException | AbortedException | RetryableException e) {
                throw e;
            }
            catch (Exception e) {
                InterruptMonitor.checkInterrupted();
                throw NonRetryableException.builder().cause(e).build();
            }
        }
    }
}

