/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.client.handler;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AttachHttpMetadataResponseHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptorChain;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.utils.StringUtils;

@SdkProtectedApi
public abstract class BaseClientHandler {
    private SdkClientConfiguration clientConfiguration;

    protected BaseClientHandler(SdkClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    static InterceptorContext finalizeSdkRequest(ExecutionContext executionContext) {
        BaseClientHandler.runBeforeExecutionInterceptors(executionContext);
        return BaseClientHandler.runModifyRequestInterceptors(executionContext);
    }

    static <InputT extends SdkRequest, OutputT> InterceptorContext finalizeSdkHttpFullRequest(ClientExecutionParams<InputT, OutputT> executionParams, ExecutionContext executionContext, InputT inputT, SdkClientConfiguration clientConfiguration) {
        BaseClientHandler.runBeforeMarshallingInterceptors(executionContext);
        SdkHttpFullRequest request = executionParams.getMarshaller().marshall(inputT);
        request = BaseClientHandler.modifyEndpointHostIfNeeded(request, clientConfiguration, executionParams);
        BaseClientHandler.addHttpRequest(executionContext, request);
        BaseClientHandler.runAfterMarshallingInterceptors(executionContext);
        return BaseClientHandler.runModifyHttpRequestAndHttpContentInterceptors(executionContext);
    }

    private static void runBeforeExecutionInterceptors(ExecutionContext executionContext) {
        executionContext.interceptorChain().beforeExecution(executionContext.interceptorContext(), executionContext.executionAttributes());
    }

    private static InterceptorContext runModifyRequestInterceptors(ExecutionContext executionContext) {
        InterceptorContext interceptorContext = executionContext.interceptorChain().modifyRequest(executionContext.interceptorContext(), executionContext.executionAttributes());
        executionContext.interceptorContext(interceptorContext);
        return interceptorContext;
    }

    private static void runBeforeMarshallingInterceptors(ExecutionContext executionContext) {
        executionContext.interceptorChain().beforeMarshalling(executionContext.interceptorContext(), executionContext.executionAttributes());
    }

    private static SdkHttpFullRequest modifyEndpointHostIfNeeded(SdkHttpFullRequest originalRequest, SdkClientConfiguration clientConfiguration, ClientExecutionParams executionParams) {
        if (executionParams.discoveredEndpoint() != null) {
            URI discoveredEndpoint = executionParams.discoveredEndpoint();
            return originalRequest.toBuilder().host(discoveredEndpoint.getHost()).port(Integer.valueOf(discoveredEndpoint.getPort())).build();
        }
        Boolean disableHostPrefixInjection = clientConfiguration.option(SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION);
        if (disableHostPrefixInjection != null && disableHostPrefixInjection.equals(Boolean.TRUE) || StringUtils.isEmpty((CharSequence)executionParams.hostPrefixExpression())) {
            return originalRequest;
        }
        return originalRequest.toBuilder().host(executionParams.hostPrefixExpression() + originalRequest.host()).build();
    }

    private static void addHttpRequest(ExecutionContext executionContext, SdkHttpFullRequest request) {
        InterceptorContext interceptorContext = (InterceptorContext)executionContext.interceptorContext().copy(b -> b.httpRequest((SdkHttpRequest)request));
        executionContext.interceptorContext(interceptorContext);
    }

    private static void runAfterMarshallingInterceptors(ExecutionContext executionContext) {
        executionContext.interceptorChain().afterMarshalling(executionContext.interceptorContext(), executionContext.executionAttributes());
    }

    private static InterceptorContext runModifyHttpRequestAndHttpContentInterceptors(ExecutionContext executionContext) {
        InterceptorContext interceptorContext = executionContext.interceptorChain().modifyHttpRequestAndHttpContent(executionContext.interceptorContext(), executionContext.executionAttributes());
        executionContext.interceptorContext(interceptorContext);
        return interceptorContext;
    }

    private static <OutputT extends SdkResponse> OutputT runAfterUnmarshallingInterceptors(OutputT response, ExecutionContext context) {
        InterceptorContext interceptorContext = (InterceptorContext)context.interceptorContext().copy(b -> b.response(response));
        context.interceptorChain().afterUnmarshalling(interceptorContext, context.executionAttributes());
        interceptorContext = context.interceptorChain().modifyResponse(interceptorContext, context.executionAttributes());
        context.interceptorContext(interceptorContext);
        return (OutputT)interceptorContext.response();
    }

    static <OutputT extends SdkResponse> HttpResponseHandler<OutputT> interceptorCalling(HttpResponseHandler<OutputT> delegate, ExecutionContext context) {
        return (response, executionAttributes) -> BaseClientHandler.runAfterUnmarshallingInterceptors((SdkResponse)delegate.handle(response, executionAttributes), context);
    }

    protected <InputT extends SdkRequest, OutputT extends SdkResponse> ExecutionContext createExecutionContext(ClientExecutionParams<InputT, OutputT> params) {
        InputT originalRequest = params.getInput();
        ExecutionAttributes executionAttributes = new ExecutionAttributes().putAttribute(SdkExecutionAttribute.SERVICE_CONFIG, this.clientConfiguration.option(SdkClientOption.SERVICE_CONFIGURATION)).putAttribute(SdkExecutionAttribute.SERVICE_NAME, this.clientConfiguration.option(SdkClientOption.SERVICE_NAME));
        ExecutionInterceptorChain interceptorChain = new ExecutionInterceptorChain(this.clientConfiguration.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        return ExecutionContext.builder().interceptorChain(interceptorChain).interceptorContext(InterceptorContext.builder().request((SdkRequest)originalRequest).build()).executionAttributes(executionAttributes).signer(this.clientConfiguration.option(SdkAdvancedClientOption.SIGNER)).build();
    }

    protected boolean isCalculateCrc32FromCompressedData() {
        return this.clientConfiguration.option(SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED);
    }

    <OutputT extends SdkResponse> HttpResponseHandler<OutputT> decorateResponseHandlers(HttpResponseHandler<OutputT> delegate, ExecutionContext executionContext) {
        HttpResponseHandler<OutputT> interceptorCallingResponseHandler = BaseClientHandler.interceptorCalling(delegate, executionContext);
        return new AttachHttpMetadataResponseHandler<OutputT>(interceptorCallingResponseHandler);
    }
}

